/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.invocation;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.DeleteParameterBindingCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteParameterBindingCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private NameColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Invocation invocation;
    private Binding binding;
    private GridData uiModel;
    private GridRow uiGridRow;
    private DeleteParameterBindingCommand command;

    @Before
    public void setup() {
        this.invocation = new Invocation();
        this.binding = this.makeBinding("p" + this.invocation.getBinding().size());
        this.invocation.getBinding().add(this.binding);
        this.uiModel = new BaseGridData(false);
        this.uiGridRow = new BaseGridRow();
        this.uiModel.appendRow(this.uiGridRow);
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((NameColumn)Mockito.doReturn((Object)1).when((Object)this.uiNameColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)2).when((Object)this.uiExpressionEditorColumn)).getIndex();
    }

    private void makeCommand(int uiRowIndex) {
        this.command = (DeleteParameterBindingCommand)Mockito.spy((Object)new DeleteParameterBindingCommand(this.invocation, this.uiModel, uiRowIndex, this.canvasOperation));
    }

    private Binding makeBinding(String bindingName) {
        Binding newBinding = new Binding();
        InformationItem parameter = new InformationItem();
        parameter.setName(new Name(bindingName));
        newBinding.setParameter(parameter);
        return newBinding;
    }

    private void assertRowValues(int rowNumberIndex, int rowNumberValue, String nameColumnValue) {
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(rowNumberIndex)).getCells().size());
        Assert.assertEquals((Object)rowNumberValue, (Object)this.uiModel.getCell(rowNumberIndex, 0).getValue().getValue());
        Assert.assertEquals((Object)nameColumnValue, (Object)this.uiModel.getCell(rowNumberIndex, 1).getValue().getValue());
        Assert.assertNull((Object)this.uiModel.getCell(rowNumberIndex, 2));
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.invocation.getBinding().size());
    }

    @Test
    public void testGraphCommandExecuteRemoveFromMiddle() {
        Binding firstBinding = new Binding();
        Binding lastBinding = new Binding();
        this.invocation.getBinding().add(0, firstBinding);
        this.invocation.getBinding().add(lastBinding);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assertions.assertThat((List)this.invocation.getBinding()).containsExactly((Object[])new Binding[]{firstBinding, lastBinding});
    }

    @Test
    public void testGraphCommandUndo() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.invocation.getBinding().size());
        Assert.assertEquals((Object)this.binding, this.invocation.getBinding().get(0));
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        ((DeleteParameterBindingCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteParameterBindingCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteDeleteOneOfThree() {
        Binding secondBinding = new Binding();
        Binding thirdBinding = new Binding();
        this.invocation.getBinding().add(secondBinding);
        this.invocation.getBinding().add(thirdBinding);
        BaseGridRow secondRow = new BaseGridRow();
        BaseGridRow thirdRow = new BaseGridRow();
        this.uiModel.appendRow((GridRow)secondRow);
        this.uiModel.appendRow((GridRow)thirdRow);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiGridRow, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)thirdRow, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        ((DeleteParameterBindingCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteParameterBindingCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithNoColumns() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiGridRow, this.uiModel.getRows().get(0));
        ((DeleteParameterBindingCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteParameterBindingCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

