/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.list;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.AddListRowCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddListRowCommandTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    @Mock
    private GridCellTuple parent;
    @Mock
    private ExpressionEditorDefinition<Expression> literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    private List list;
    private HasExpression hasExpression;
    private GridData uiModel;
    private GridRow uiModelRow;
    private ListUIModelMapper uiModelMapper;
    private AddListRowCommand command;

    @Before
    public void setup() {
        this.list = new List();
        this.hasExpression = HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression());
        this.uiModel = new BaseGridData();
        this.uiModelRow = new BaseGridRow();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.handler.getRuleManager()).thenReturn((Object)this.ruleManager);
        Mockito.when((Object)this.uiRowNumberColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiExpressionEditorColumn.getIndex()).thenReturn((Object)1);
        this.uiModel.setCellValue(0, 1, (GridCellValue)new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add(this.literalExpressionEditorDefinition);
        Mockito.when((Object)this.literalExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(new LiteralExpression()));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        this.uiModelMapper = (ListUIModelMapper)Mockito.spy((Object)new ListUIModelMapper(this.gridWidget, () -> this.uiModel, () -> Optional.of(this.list), () -> false, () -> expressionEditorDefinitions, this.listSelector, 0));
    }

    private void makeCommand() {
        this.command = (AddListRowCommand)Mockito.spy((Object)new AddListRowCommand(this.list, this.hasExpression, this.uiModel, this.uiModelRow, this.list.getExpression().size(), this.uiModelMapper, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.list.getExpression().size());
        Assert.assertEquals((Object)this.hasExpression, this.list.getExpression().get(0));
        Assert.assertEquals((Object)this.list, (Object)this.hasExpression.asDMNModelInstrumentedBase().getParent());
    }

    @Test
    public void testGraphCommandExecuteMultipleEntriesPresent() {
        HasExpression firstEntry = HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression());
        this.list.getExpression().add(0, firstEntry);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.list.getExpression().size());
        Assert.assertEquals((Object)firstEntry, this.list.getExpression().get(0));
        Assert.assertEquals((Object)this.hasExpression, this.list.getExpression().get(1));
        Assert.assertEquals((Object)this.list, (Object)this.hasExpression.asDMNModelInstrumentedBase().getParent());
    }

    @Test
    public void testGraphCommandUndo() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.list.getExpression().size());
        Assert.assertNull((Object)this.hasExpression.asDMNModelInstrumentedBase().getParent());
    }

    @Test
    public void testGraphCommandUndoMultipleEntriesPresent() {
        HasExpression firstEntry = HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression());
        this.list.getExpression().add(0, firstEntry);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.list.getExpression().size());
        Assert.assertEquals((Object)firstEntry, this.list.getExpression().get(0));
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 1).getValue() instanceof ExpressionCellValue));
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteMultipleEntries() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command firstEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)firstEntryCanvasCommand.execute((Object)this.handler));
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        HasExpression secondRowEntry = HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression());
        BaseGridRow uiSecondModelRow = new BaseGridRow();
        this.command = (AddListRowCommand)Mockito.spy((Object)new AddListRowCommand(this.list, secondRowEntry, this.uiModel, (GridRow)uiSecondModelRow, this.list.getExpression().size(), this.uiModelMapper, this.canvasOperation));
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command secondEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)secondEntryCanvasCommand.execute((Object)this.handler));
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((Object)uiSecondModelRow, this.uiModel.getRows().get(1));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 1).getValue() instanceof ExpressionCellValue));
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(1)).getCells().size());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 1).getValue() instanceof ExpressionCellValue));
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)2))).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddListRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoRedoReuseEditor() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        ((ListUIModelMapper)Mockito.verify((Object)this.uiModelMapper)).fromDMNModel(0, 1);
        GridCellValue originalCellValue = this.uiModel.getCell(0, 1).getValue();
        Assert.assertTrue((boolean)(originalCellValue instanceof ExpressionCellValue));
        BaseExpressionGrid originalEditor = (BaseExpressionGrid)((Optional)((ExpressionCellValue)originalCellValue).getValue()).get();
        Assert.assertEquals((Object)this.literalExpressionEditor, (Object)originalEditor);
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        ((ListUIModelMapper)Mockito.verify((Object)this.uiModelMapper)).fromDMNModel(0, 1);
        GridCellValue redoCellValue = this.uiModel.getCell(0, 1).getValue();
        Assert.assertTrue((boolean)(redoCellValue instanceof ExpressionCellValue));
        BaseExpressionGrid redoEditor = (BaseExpressionGrid)((Optional)((ExpressionCellValue)redoCellValue).getValue()).get();
        Assert.assertEquals((Object)this.literalExpressionEditor, (Object)redoEditor);
    }
}

