/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.DeleteRelationRowCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteRelationRowCommandTest {
    private static final String VALUE = "value";
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private RelationColumn uiModelColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Relation relation;
    private List rowList;
    private GridData uiModel;
    private RelationUIModelMapper uiModelMapper;
    private DeleteRelationRowCommand command;

    @Before
    public void setup() {
        this.relation = new Relation();
        this.rowList = new List();
        this.relation.getRow().add(this.rowList);
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModelMapper = new RelationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.relation), this.listSelector, 48.0);
        this.makeCommand(0);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn)).getIndex();
    }

    private void makeCommand(int uiRowIndex) {
        this.command = (DeleteRelationRowCommand)Mockito.spy((Object)new DeleteRelationRowCommand(this.relation, this.uiModel, uiRowIndex, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteWithColumns() {
        this.relation.getColumn().add(new InformationItem());
        ((List)this.relation.getRow().get(0)).getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.rowList, (Expression)new LiteralExpression()));
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
    }

    @Test
    public void testGraphCommandExecuteRemoveMiddleWithColumns() {
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        List firstRow = new List();
        List lastRow = new List();
        this.relation.getRow().add(0, firstRow);
        this.relation.getRow().add(lastRow);
        this.relation.getColumn().add(new InformationItem());
        ((List)this.relation.getRow().get(0)).getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.rowList, (Expression)new LiteralExpression()));
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.relation.getRow().size());
        Assert.assertEquals((Object)firstRow, this.relation.getRow().get(0));
        Assert.assertEquals((Object)lastRow, this.relation.getRow().get(1));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
    }

    @Test
    public void testGraphCommandExecuteWithNoColumns() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testGraphCommandUndoWithColumns() {
        this.relation.getColumn().add(new InformationItem());
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getText().setValue(VALUE);
        ((List)this.relation.getRow().get(0)).getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.rowList, (Expression)literalExpression));
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)1L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertEquals((Object)VALUE, (Object)((LiteralExpression)((HasExpression)((List)this.relation.getRow().get(0)).getExpression().get(0)).getExpression()).getText().getValue());
    }

    @Test
    public void testGraphCommandUndoWithNoColumns() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
    }

    @Test
    public void testCanvasCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteWithColumns() {
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteRemoveMiddleWithColumns() {
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        BaseGridRow firstRow = new BaseGridRow();
        BaseGridRow lastRow = new BaseGridRow();
        this.uiModel.insertRow(0, (GridRow)firstRow);
        this.uiModel.appendRow((GridRow)lastRow);
        this.relation.getRow().add(0, new List());
        this.relation.getRow().add(new List());
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)firstRow, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)lastRow, (Object)this.uiModel.getRow(1));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteWithNoColumns() {
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithColumns() {
        this.relation.getColumn().add(new InformationItem());
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getText().setValue(VALUE);
        ((List)this.relation.getRow().get(0)).getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.rowList, (Expression)literalExpression));
        this.uiModel.appendColumn((GridColumn)this.uiModelColumn);
        this.uiModelMapper.fromDMNModel(0, 0);
        this.uiModelMapper.fromDMNModel(0, 1);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)VALUE, (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithNoColumns() {
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteRelationRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

