/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasValue;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasValueCommand;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteHasValueCommandTest {
    private static final String NAME = "name";
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    private HasName hasName = new Decision();
    private DeleteHasValueCommand command;

    @Before
    public void setup() {
        this.hasName.getName().setValue(NAME);
        this.command = new DeleteHasValueCommand((HasValue)this.hasName, (Object)new Name(), this.canvasOperation);
    }

    @Test
    public void checkGraphCommand() {
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void executeGraphCommand() {
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)"", (Object)this.hasName.getName().getValue());
    }

    @Test
    public void undoGraphCommand() {
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((Object)NAME, (Object)this.hasName.getName().getValue());
    }

    @Test
    public void allowCanvasCommand() {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).allow((Object)this.canvasHandler));
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void executeCanvasCommand() {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void undoCanvasCommand() {
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void checkCommandDefinition() {
        Assert.assertTrue((boolean)(this.command instanceof VetoExecutionCommand));
        Assert.assertTrue((boolean)(this.command instanceof VetoUndoCommand));
    }
}

