/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorDock;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorDockTest {
    @Mock
    private UberfireDocks uberfireDocks;
    @Mock
    private DecisionNavigatorPresenter decisionNavigatorPresenter;
    @Mock
    private TranslationService translationService;
    private DecisionNavigatorDock dock;

    @Before
    public void setup() {
        this.dock = (DecisionNavigatorDock)Mockito.spy((Object)new DecisionNavigatorDock(this.uberfireDocks, this.decisionNavigatorPresenter, this.translationService));
    }

    @Test
    public void testInit() {
        String expectedPerspective = "perspective";
        UberfireDock expectedUberfireDock = (UberfireDock)Mockito.mock(UberfireDock.class);
        ((DecisionNavigatorDock)Mockito.doReturn((Object)expectedUberfireDock).when((Object)this.dock)).makeUberfireDock();
        this.dock.init("perspective");
        String actualPerspective = this.dock.perspective();
        UberfireDock actualUberfireDock = this.dock.getUberfireDock();
        Assert.assertEquals((Object)"perspective", (Object)actualPerspective);
        Assert.assertEquals((Object)expectedUberfireDock, (Object)actualUberfireDock);
    }

    @Test
    public void testSetupCanvasHandler() {
        this.dock.reload();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.decisionNavigatorPresenter)).refresh();
    }

    @Test
    public void testResetContent() {
        this.dock.resetContent();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.decisionNavigatorPresenter)).removeAllElements();
    }

    @Test
    public void testOpenWhenItIsOpened() {
        UberfireDockPosition position = UberfireDockPosition.WEST;
        String perspective = "perspective";
        this.dock.setOpened(true);
        ((DecisionNavigatorDock)Mockito.doReturn((Object)position).when((Object)this.dock)).position();
        ((DecisionNavigatorDock)Mockito.doReturn((Object)"perspective").when((Object)this.dock)).perspective();
        this.dock.open();
        Assert.assertTrue((boolean)this.dock.isOpened());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).add((UberfireDock[])Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).show((UberfireDockPosition)Matchers.any(), (String)Matchers.any());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).open((UberfireDock)Matchers.any());
    }

    @Test
    public void testOpenWhenItIsNotOpened() {
        UberfireDock uberfireDock = (UberfireDock)Mockito.mock(UberfireDock.class);
        UberfireDockPosition position = UberfireDockPosition.WEST;
        String perspective = "perspective";
        this.dock.setOpened(false);
        ((DecisionNavigatorDock)Mockito.doReturn((Object)uberfireDock).when((Object)this.dock)).getUberfireDock();
        ((DecisionNavigatorDock)Mockito.doReturn((Object)"perspective").when((Object)this.dock)).perspective();
        this.dock.open();
        Assert.assertTrue((boolean)this.dock.isOpened());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).add(new UberfireDock[]{uberfireDock});
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).show(position, "perspective");
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).open(uberfireDock);
    }

    @Test
    public void testCloseWhenItIsOpened() {
        UberfireDock uberfireDock = (UberfireDock)Mockito.mock(UberfireDock.class);
        this.dock.setOpened(true);
        ((DecisionNavigatorDock)Mockito.doReturn((Object)uberfireDock).when((Object)this.dock)).getUberfireDock();
        this.dock.close();
        Assert.assertFalse((boolean)this.dock.isOpened());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).close(uberfireDock);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).remove(new UberfireDock[]{uberfireDock});
    }

    @Test
    public void testCloseWhenItIsNotOpened() {
        UberfireDock uberfireDock = (UberfireDock)Mockito.mock(UberfireDock.class);
        this.dock.setOpened(false);
        ((DecisionNavigatorDock)Mockito.doReturn((Object)uberfireDock).when((Object)this.dock)).getUberfireDock();
        this.dock.close();
        Assert.assertFalse((boolean)this.dock.isOpened());
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).close(uberfireDock);
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks, (VerificationMode)Mockito.never())).remove(new UberfireDock[]{uberfireDock});
    }

    @Test
    public void testDestroy() {
        UberfireDock uberfireDock = (UberfireDock)Mockito.mock(UberfireDock.class);
        ((DecisionNavigatorDock)Mockito.doReturn((Object)uberfireDock).when((Object)this.dock)).getUberfireDock();
        this.dock.destroy();
        ((UberfireDocks)Mockito.verify((Object)this.uberfireDocks)).remove(new UberfireDock[]{uberfireDock});
    }

    @Test
    public void testMakeUberfireDock() {
        UberfireDockPosition expectedPosition = UberfireDockPosition.WEST;
        String expectedIcon = IconType.MAP.toString();
        String expectedPlaceRequestIdentifier = "org.kie.dmn.decision.navigator";
        String expectedPerspective = "perspective";
        Double expectedSize = 400.0;
        String expectedLabel = "DecisionNavigator";
        Mockito.when((Object)this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0])).thenReturn((Object)"DecisionNavigator");
        ((DecisionNavigatorDock)Mockito.doReturn((Object)"perspective").when((Object)this.dock)).perspective();
        UberfireDock uberfireDock = this.dock.makeUberfireDock();
        UberfireDockPosition actualPosition = uberfireDock.getDockPosition();
        String actualIcon = uberfireDock.getIconType();
        String actualPlaceRequestIdentifier = uberfireDock.getPlaceRequest().getIdentifier();
        String actualPerspective = uberfireDock.getAssociatedPerspective();
        Double actualSize = uberfireDock.getSize();
        String actualLabel = uberfireDock.getLabel();
        Assert.assertEquals((Object)expectedPosition, (Object)actualPosition);
        Assert.assertEquals((Object)expectedIcon, (Object)actualIcon);
        Assert.assertEquals((Object)"org.kie.dmn.decision.navigator", (Object)actualPlaceRequestIdentifier);
        Assert.assertEquals((Object)"perspective", (Object)actualPerspective);
        Assert.assertEquals((Object)expectedSize, (Object)actualSize);
        Assert.assertEquals((Object)"DecisionNavigator", (Object)actualLabel);
    }
}

