/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.common.CanvasFocusUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasFocusedShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class CanvasFocusUtilsTest {
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private EventSourceMock<CanvasFocusedShapeEvent> canvasFocusedSelectionEvent;
    @Mock
    private EventSourceMock<CanvasSelectionEvent> canvasSelectionEvent;
    private CanvasFocusUtils canvasFocusUtils;

    @Before
    public void setup() {
        this.canvasFocusUtils = (CanvasFocusUtils)Mockito.spy((Object)new CanvasFocusUtils(this.dmnGraphUtils, this.canvasFocusedSelectionEvent, this.canvasSelectionEvent));
    }

    @Test
    public void testFocus() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Canvas canvas = (Canvas)Mockito.mock(Canvas.class);
        String uuid = "uuid";
        CanvasSelectionEvent canvasSelection = new CanvasSelectionEvent(canvasHandler, "uuid");
        CanvasFocusedShapeEvent canvasFocusedShape = new CanvasFocusedShapeEvent(canvasHandler, "uuid");
        Mockito.when((Object)this.dmnGraphUtils.getCanvasHandler()).thenReturn((Object)canvasHandler);
        ((CanvasFocusUtils)Mockito.doReturn((Object)canvasSelection).when((Object)this.canvasFocusUtils)).makeCanvasSelectionEvent(canvasHandler, "uuid");
        ((CanvasFocusUtils)Mockito.doReturn((Object)canvasFocusedShape).when((Object)this.canvasFocusUtils)).makeCanvasFocusedShapeEvent(canvasHandler, "uuid");
        ((CanvasHandler)Mockito.doReturn((Object)canvas).when((Object)canvasHandler)).getCanvas();
        this.canvasFocusUtils.focus("uuid");
        ((EventSourceMock)Mockito.verify(this.canvasSelectionEvent)).fire((Object)canvasSelection);
        ((EventSourceMock)Mockito.verify(this.canvasFocusedSelectionEvent)).fire((Object)canvasFocusedShape);
        ((Canvas)Mockito.verify((Object)canvas)).focus();
    }
}

