/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.tree;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorTreePresenterTest {
    @Mock
    private DecisionNavigatorTreePresenter.View view;
    @Mock
    private Map<String, DecisionNavigatorItem> indexedItems;
    private DecisionNavigatorTreePresenter presenter;

    @Before
    public void setup() {
        this.presenter = (DecisionNavigatorTreePresenter)Mockito.spy((Object)new DecisionNavigatorTreePresenter(this.view));
        ((DecisionNavigatorTreePresenter)Mockito.doReturn(this.indexedItems).when((Object)this.presenter)).getIndexedItems();
    }

    @Test
    public void testSetup() {
        this.presenter.setup();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testSetupItems() {
        ArrayList items = new ArrayList();
        ((DecisionNavigatorTreePresenter)Mockito.doNothing().when((Object)this.presenter)).index(items);
        this.presenter.setupItems(items);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(items);
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).clean();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).setup(items);
    }

    @Test
    public void testRemoveAllItems() {
        this.presenter.removeAllItems();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).clean();
        ((Map)Mockito.verify(this.indexedItems)).clear();
    }

    @Test
    public void testGetActiveParent() {
        DecisionNavigatorItem expectedItem = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        String uuid = "uuid";
        Mockito.when((Object)this.indexedItems.get("uuid")).thenReturn((Object)expectedItem);
        this.presenter.setActiveParentUUID("uuid");
        DecisionNavigatorItem actualItem = this.presenter.getActiveParent();
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    @Test
    public void testSelectItem() {
        String uuid = "uuid";
        this.presenter.selectItem("uuid");
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).select("uuid");
    }

    @Test
    public void testDeselectItem() {
        this.presenter.deselectItem();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).deselect();
    }

    @Test
    public void testListIndex() {
        DecisionNavigatorItem item1 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem item2 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        List<DecisionNavigatorItem> items = Arrays.asList(item1, item2);
        this.presenter.index(items);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(item1);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(item2);
    }

    @Test
    public void testItemIndex() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem child1 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem child2 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        TreeSet<DecisionNavigatorItem> children = this.asTreeSet(child1, child2);
        String uuid = "uuid";
        Mockito.when((Object)item.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)item.getChildren()).thenReturn(children);
        this.presenter.index(item);
        ((Map)Mockito.verify(this.indexedItems)).put("uuid", item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(children);
    }

    private TreeSet<DecisionNavigatorItem> asTreeSet(final DecisionNavigatorItem ... items) {
        return new TreeSet<DecisionNavigatorItem>(){
            {
                this.addAll(Arrays.asList(items));
            }
        };
    }
}

