/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasValue;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.IsInformationItem;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.general.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasValueCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCacheImpl;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.AutocompleteTextAreaDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionContainerGridTest {
    private static final String NODE_UUID = "uuid";
    private static final String NAME = "name";
    private static final double COLUMN_NEW_WIDTH = 300.0;
    private static final double LITERAL_EXPRESSION_EDITOR_PADDING = 10.0;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private TranslationService translationService;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ClientSession session;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    @Mock
    private UndefinedExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private UndefinedExpressionGrid undefinedExpressionEditor;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private GraphCommandExecutionContext graphExecutionContext;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private IsInformationItem isInformationItem;
    @Mock
    private ParameterizedCommand<Optional<Expression>> onHasExpressionChanged;
    @Mock
    private ParameterizedCommand<Optional<HasName>> onHasNameChanged;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private CellSelectionManager cellSelectionManager;
    @Mock
    private TextAreaSingletonDOMElementFactory textAreaSingletonDOMElementFactory;
    @Mock
    private AutocompleteTextAreaDOMElementFactory autocompleteTextareaDOMElementFactory;
    @Captor
    private ArgumentCaptor<Optional<HasName>> hasNameCaptor;
    @Captor
    private ArgumentCaptor<ClearExpressionTypeCommand> clearExpressionTypeCommandCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    @Captor
    private ArgumentCaptor<RefreshFormPropertiesEvent> refreshFormPropertiesEventCaptor;
    private MockHasNameHasVariable hasName = new MockHasNameHasVariable(){
        private Name name = new Name("name");

        public Name getName() {
            return this.name;
        }

        public void setName(Name name) {
            this.name = name;
        }

        public IsInformationItem getVariable() {
            return ExpressionContainerGridTest.this.isInformationItem;
        }

        public void setVariable(IsInformationItem informationItem) {
            throw new UnsupportedOperationException("Not supported in this Unit Test");
        }

        public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
            throw new UnsupportedOperationException("Not supported in this Unit Test");
        }
    };
    private LiteralExpression literalExpression = new LiteralExpression();
    private ExpressionGridCache expressionGridCache;
    private DMNGridLayer gridLayer;
    private ExpressionContainerGrid grid;

    @Before
    public void setup() {
        this.expressionGridCache = new ExpressionGridCacheImpl();
        this.gridLayer = (DMNGridLayer)Mockito.spy((Object)new DMNGridLayer());
        this.grid = new ExpressionContainerGrid(this.gridLayer, this.cellEditorControls, this.translationService, this.listSelector, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, this.canvasCommandFactory, this.expressionEditorDefinitionsSupplier, () -> this.expressionGridCache, (ParameterizedCommand)this.onHasExpressionChanged, (ParameterizedCommand)this.onHasNameChanged, (Event)this.refreshFormPropertiesEvent, (Event)this.domainObjectSelectionEvent){

            public CellSelectionManager getCellSelectionManager() {
                return ExpressionContainerGridTest.this.cellSelectionManager;
            }
        };
        this.gridLayer.add((IPrimitive)this.grid);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditor.isCacheable()).thenReturn((Object)true);
        Mockito.when((Object)this.literalExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.literalExpressionEditor.getModel()).thenReturn((Object)new BaseGridData());
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        Mockito.when((Object)this.undefinedExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.undefinedExpressionEditor.getModel()).thenReturn((Object)new BaseGridData());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.undefinedExpressionEditor));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphExecutionContext);
        ((DMNGridLayer)Mockito.doReturn((Object)Mockito.mock(Bounds.class)).when((Object)this.gridLayer)).getVisibleBounds();
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.grid);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)0);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
    }

    @Test
    public void testInitialSetup() {
        GridData uiModel = this.grid.getModel();
        Assertions.assertThat((Object)uiModel).isInstanceOf(DMNGridData.class);
        Assertions.assertThat((int)uiModel.getColumnCount()).isEqualTo(1);
        Assertions.assertThat(uiModel.getColumns().get(0)).isInstanceOf(ExpressionEditorColumn.class);
        Assertions.assertThat((int)uiModel.getRowCount()).isEqualTo(1);
    }

    @Test
    public void testGridDraggingIsDisabled() {
        Assertions.assertThat((boolean)this.grid.onDragHandle((INodeXYEvent)Mockito.mock(INodeXYEvent.class))).isFalse();
    }

    @Test
    public void testDeselect() {
        this.grid.getModel().selectCell(0, 0);
        Assert.assertFalse((boolean)this.grid.getModel().getSelectedCells().isEmpty());
        this.grid.deselect();
        Assert.assertTrue((boolean)this.grid.getModel().getSelectedCells().isEmpty());
    }

    @Test
    public void testSetUndefinedExpression() {
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        GridCellValue gridCellValue = this.grid.getModel().getCell(0, 0).getValue();
        Assertions.assertThat((Object)gridCellValue).isInstanceOf(ExpressionCellValue.class);
        ExpressionCellValue expressionCellValue = (ExpressionCellValue)gridCellValue;
        Assertions.assertThat((boolean)((Optional)expressionCellValue.getValue()).isPresent()).isTrue();
        Assertions.assertThat(((Optional)expressionCellValue.getValue()).get()).isSameAs((Object)this.undefinedExpressionEditor);
        Assertions.assertThat((boolean)this.grid.isOnlyVisualChangeAllowed()).isFalse();
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.undefinedExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSetDefinedExpression() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.literalExpression);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        GridCellValue gridCellValue = this.grid.getModel().getCell(0, 0).getValue();
        Assertions.assertThat((Object)gridCellValue).isInstanceOf(ExpressionCellValue.class);
        ExpressionCellValue expressionCellValue = (ExpressionCellValue)gridCellValue;
        Assertions.assertThat((boolean)((Optional)expressionCellValue.getValue()).isPresent()).isTrue();
        Assertions.assertThat(((Optional)expressionCellValue.getValue()).get()).isSameAs((Object)this.literalExpressionEditor);
        Assertions.assertThat((boolean)this.grid.isOnlyVisualChangeAllowed()).isFalse();
        ((LiteralExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSetExpressionWhenOnlyVisualChangeAllowed() {
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), true);
        Assertions.assertThat((boolean)this.grid.isOnlyVisualChangeAllowed()).isTrue();
    }

    @Test
    public void testResizeContainerCorrectlyResizesExpressionComponentWidth() {
        BaseGridData literalExpressionModel = new BaseGridData();
        LiteralExpressionColumn literalExpressionEditorColumn = new LiteralExpressionColumn(Collections.emptyList(), this.autocompleteTextareaDOMElementFactory, 100.0, this.literalExpressionEditor);
        literalExpressionModel.appendColumn((GridColumn)literalExpressionEditorColumn);
        Mockito.when((Object)this.literalExpressionEditor.getExpression()).thenReturn(() -> Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditor.getModel()).thenReturn((Object)literalExpressionModel);
        Mockito.when((Object)this.literalExpressionEditor.getPadding()).thenReturn((Object)10.0);
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.literalExpression);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        ((GridColumn)this.grid.getModel().getColumns().get(0)).setWidth(300.0);
        Assertions.assertThat((Double)((Double)this.literalExpression.getComponentWidths().get(0))).isEqualTo(280.0);
    }

    @Test
    public void testSetDefinedExpressionWhenReopeningWithResizedColumn() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.literalExpression);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        Mockito.when((Object)this.literalExpressionEditor.getWidth()).thenReturn((Object)300.0);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(0)).getWidth()).isEqualTo(300.0);
    }

    @Test
    public void testSetDefinedExpressionWhenReopeningWhenWorkbenchRestarted() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.literalExpression);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        Mockito.when((Object)this.literalExpressionEditor.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)this.literalExpressionEditor.getMinimumWidth()).thenReturn((Object)150.0);
        this.expressionGridCache.removeExpressionGrid(NODE_UUID);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(0)).getWidth()).isEqualTo(150.0);
    }

    @Test
    public void testGetItemsWithClearEnabled() {
        Mockito.when((Object)this.hasExpression.isClearSupported()).thenReturn((Object)true);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((int)items.size()).isEqualTo(1);
        HasListSelectorControl.ListSelectorItem item = (HasListSelectorControl.ListSelectorItem)items.get(0);
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorTextItem.class);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
        Assertions.assertThat((String)ti.getText()).isEqualTo("ExpressionEditor.Clear");
        ti.getCommand().execute();
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(ClearExpressionTypeCommand.class));
    }

    @Test
    public void testGetItemsWithClearDisabled() {
        Mockito.when((Object)this.hasExpression.isClearSupported()).thenReturn((Object)false);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        List items = this.grid.getItems(0, 0);
        Assertions.assertThat((List)items).isEmpty();
    }

    @Test
    public void testOnItemSelected() {
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testOnClearExpressionItemSelected() {
        Mockito.when((Object)this.literalExpressionEditor.getWidth()).thenReturn((Object)300.0);
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.literalExpression);
        Mockito.when((Object)this.hasExpression.isClearSupported()).thenReturn((Object)true);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.literalExpressionEditor);
        ((LiteralExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorItem item = (HasListSelectorControl.ListSelectorItem)items.get(0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
        ti.getCommand().execute();
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(0)).getWidth()).isEqualTo(300.0);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.clearExpressionTypeCommandCaptor.capture());
        ClearExpressionTypeCommand clearExpressionTypeCommand = (ClearExpressionTypeCommand)this.clearExpressionTypeCommandCaptor.getValue();
        Mockito.reset((Object[])new Object[]{this.hasExpression, this.gridLayer});
        clearExpressionTypeCommand.execute(this.canvasHandler);
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(0)).getWidth()).isEqualTo(100.0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.undefinedExpressionEditor);
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.undefinedExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        clearExpressionTypeCommand.undo(this.canvasHandler);
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(0)).getWidth()).isEqualTo(300.0);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.literalExpressionEditor);
        ((LiteralExpressionGrid)Mockito.verify((Object)this.literalExpressionEditor, (VerificationMode)Mockito.times((int)2))).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)2))).batch();
    }

    @Test
    public void testSpyHasNameWithHasNameGet() {
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        Optional spy = this.grid.spyHasName(Optional.of(this.hasName));
        Assertions.assertThat((boolean)spy.isPresent()).isTrue();
        Assertions.assertThat((String)((HasName)spy.get()).getName().getValue()).isEqualTo(NAME);
    }

    @Test
    public void testSpyHasNameWithHasNameSetNameObject() {
        String NEW_NAME = "new-name";
        Name newName = new Name("new-name");
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        Optional spy = this.grid.spyHasName(Optional.of(this.hasName));
        Assertions.assertThat((boolean)spy.isPresent()).isTrue();
        ((HasName)spy.get()).setName(newName);
        Assertions.assertThat((String)this.hasName.getName().getValue()).isEqualTo("new-name");
        ((IsInformationItem)Mockito.verify((Object)this.isInformationItem)).setName((Name)Matchers.eq((Object)newName));
        ((ParameterizedCommand)Mockito.verify(this.onHasNameChanged)).execute(this.hasNameCaptor.capture());
        Assertions.assertThat((String)((HasName)((Optional)this.hasNameCaptor.getValue()).get()).getName().getValue()).isEqualTo("new-name");
    }

    @Test
    public void testSpyHasNameWithoutHasNameGet() {
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.empty(), false);
        Optional spy = this.grid.spyHasName(Optional.empty());
        Assertions.assertThat((boolean)spy.isPresent()).isTrue();
        Assertions.assertThat((String)((HasName)spy.get()).getName().getValue()).isEqualTo(HasName.NOP.getName().getValue());
    }

    @Test
    public void testSpyHasNameWithoutHasNameSetNameObject() {
        String NEW_NAME = "new-name";
        Name newName = new Name("new-name");
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.empty(), false);
        Optional spy = this.grid.spyHasName(Optional.empty());
        Assertions.assertThat((boolean)spy.isPresent()).isTrue();
        ((HasName)spy.get()).setName(newName);
        Assertions.assertThat((String)this.hasName.getName().getValue()).isEqualTo(NAME);
        ((ParameterizedCommand)Mockito.verify(this.onHasNameChanged, (VerificationMode)Mockito.never())).execute(Matchers.any(Optional.class));
    }

    @Test
    public void testSpyHasNameUpdateUndoWithSetHasNameCommand() {
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        Optional spy = this.grid.spyHasName(Optional.of(this.hasName));
        Name newName = new Name("new-name");
        Name oldName = ((HasName)spy.get()).getName();
        Command canvasOperation = (Command)Mockito.mock(Command.class);
        SetHasValueCommand command = new SetHasValueCommand((HasValue)spy.get(), (Object)newName, canvasOperation);
        command.execute(this.canvasHandler);
        spy.ifPresent(name -> Assertions.assertThat((String)name.getName().getValue()).isEqualTo(newName.getValue()));
        command.undo(this.canvasHandler);
        spy.ifPresent(name -> Assertions.assertThat((String)name.getName().getValue()).isEqualTo(oldName.getValue()));
    }

    @Test
    public void testSpyHasExpressionWithExpressionGet() {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.literalExpression);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        HasExpression spy = this.grid.spyHasExpression(this.hasExpression);
        Assertions.assertThat((Object)spy.getExpression()).isEqualTo((Object)this.literalExpression);
    }

    @Test
    public void testSpyHasExpressionWithoutExpressionGet() {
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        HasExpression spy = this.grid.spyHasExpression(this.hasExpression);
        Assertions.assertThat((Object)spy.getExpression()).isNull();
    }

    @Test
    public void testSpyHasExpressionWithExpressionSet() {
        HasExpression hasExpression = new HasExpression(){
            private Expression expression = new LiteralExpression();

            public Expression getExpression() {
                return this.expression;
            }

            public void setExpression(Expression expression) {
                this.expression = expression;
            }

            public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
                return null;
            }
        };
        this.grid.setExpression(NODE_UUID, hasExpression, Optional.of(this.hasName), false);
        HasExpression spy = this.grid.spyHasExpression(hasExpression);
        spy.setExpression(null);
        Assertions.assertThat((Object)hasExpression.getExpression()).isNull();
    }

    @Test
    public void testSpyHasExpressionWithExpressionAsDMNModelInstrumentedBase() {
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)this.literalExpression);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        HasExpression spy = this.grid.spyHasExpression(this.hasExpression);
        Assertions.assertThat((Object)spy.asDMNModelInstrumentedBase()).isEqualTo((Object)this.literalExpression);
    }

    @Test
    public void testSelectCellWithPoint() {
        Point2D point = (Point2D)Mockito.mock(Point2D.class);
        LiteralExpression domainObject = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)domainObject);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        this.grid.selectCell(point, false, true);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)this.grid));
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)domainObject);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager)).selectCell((Point2D)Matchers.eq((Object)point), Matchers.eq((boolean)false), Matchers.eq((boolean)true));
    }

    @Test
    public void testSelectCellWithCoordinates() {
        boolean uiRowIndex = false;
        boolean uiColumnIndex = true;
        LiteralExpression domainObject = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)domainObject);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        this.grid.selectCell(0, 1, false, true);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)this.grid));
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)domainObject);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)false), Matchers.eq((boolean)true));
    }

    @Test
    public void testSelectCellWithCoordinatesNonDomainObject() {
        boolean uiRowIndex = false;
        boolean uiColumnIndex = true;
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        this.grid.selectCell(0, 1, false, true);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)this.grid));
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getCanvasHandler()).isEqualTo((Object)this.canvasHandler);
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)false), Matchers.eq((boolean)true));
    }

    @Test
    public void testSelectCellWithDomainObjectInStunnerGraph() {
        boolean uiRowIndex = false;
        boolean uiColumnIndex = true;
        LiteralExpression domainObject = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        Mockito.when((Object)this.hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)domainObject);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)NODE_UUID);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)domainObject);
        this.grid.setExpression(NODE_UUID, this.hasExpression, Optional.of(this.hasName), false);
        this.grid.selectCell(0, 1, false, true);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)this.grid));
        ((EventSourceMock)Mockito.verify(this.refreshFormPropertiesEvent)).fire(this.refreshFormPropertiesEventCaptor.capture());
        RefreshFormPropertiesEvent refreshFormPropertiesEvent = (RefreshFormPropertiesEvent)this.refreshFormPropertiesEventCaptor.getValue();
        Assertions.assertThat((String)refreshFormPropertiesEvent.getUuid()).isEqualTo(NODE_UUID);
        Assertions.assertThat((Object)refreshFormPropertiesEvent.getSession()).isEqualTo((Object)this.session);
        ((CellSelectionManager)Mockito.verify((Object)this.cellSelectionManager)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)false), Matchers.eq((boolean)true));
    }

    @Test
    public void testGetBaseExpressionGrid() {
        Optional<Object> expectedBaseExpressionGrid = Optional.of(Mockito.mock(LiteralExpressionGrid.class));
        ExpressionCellValue value = (ExpressionCellValue)Mockito.mock(ExpressionCellValue.class);
        BaseGridCell cell = new BaseGridCell((GridCellValue)value);
        Supplier<GridCell> cellSupplier = () -> ExpressionContainerGridTest.lambda$testGetBaseExpressionGrid$5((GridCell)cell);
        Mockito.when((Object)value.getValue()).thenReturn(expectedBaseExpressionGrid);
        this.grid.getModel().setCell(0, 0, cellSupplier);
        Assert.assertEquals(expectedBaseExpressionGrid, (Object)this.grid.getBaseExpressionGrid());
    }

    private static /* synthetic */ GridCell lambda$testGetBaseExpressionGrid$5(GridCell cell) {
        return cell;
    }

    private static interface MockHasNameHasVariable
    extends HasName,
    HasVariable {
    }
}

