/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasText;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseColumnHeaderMetaDataContextMenuTest;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumnHeaderMetaData;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InputClauseColumnHeaderMetaDataTest
extends BaseColumnHeaderMetaDataContextMenuTest<InputClauseColumnHeaderMetaData, Text, HasText> {
    private static final String VALUE = "value";
    @Mock
    private HasText hasValue;

    @Override
    protected InputClauseColumnHeaderMetaData getHeaderMetaData() {
        return new InputClauseColumnHeaderMetaData(this.hasValue, () -> this.hasTypeRef, this.clearValueConsumer, this.setValueConsumer, this.setTypeRefConsumer, this.translationService, this.cellEditorControls, this.editor, this.listSelector, this.listSelectorItemsSupplier, this.listSelectorItemConsumer);
    }

    @Test
    public void testIsEmptyValue_WhenNull() {
        Assertions.assertThat((boolean)((InputClauseColumnHeaderMetaData)this.headerMetaData).isEmptyValue(null)).isTrue();
    }

    @Test
    public void testIsEmptyValue_WhenEmptyString() {
        Assertions.assertThat((boolean)((InputClauseColumnHeaderMetaData)this.headerMetaData).isEmptyValue(new Text())).isTrue();
    }

    @Test
    public void testToModelValue() {
        Assertions.assertThat((String)((InputClauseColumnHeaderMetaData)this.headerMetaData).toModelValue(VALUE).getValue()).isEqualTo(VALUE);
    }

    @Test
    public void testToWidgetValue() {
        Assertions.assertThat((String)((InputClauseColumnHeaderMetaData)this.headerMetaData).toWidgetValue(new Text(VALUE))).isEqualTo(VALUE);
    }

    @Test
    public void testGetValueLabel() {
        Assertions.assertThat((String)((InputClauseColumnHeaderMetaData)this.headerMetaData).getValueLabel()).isEqualTo("DecisionTableEditor.InputClauseColumnHeaderMetaData.ValueLabel");
    }

    @Test
    public void testNormaliseValue() {
        String value = "   value   ";
        Assertions.assertThat((String)((InputClauseColumnHeaderMetaData)this.headerMetaData).normaliseValue("   value   ")).isEqualTo("   value   ");
    }

    @Test
    public void testGetValue() {
        Mockito.when((Object)this.hasValue.getValue()).thenReturn((Object)new Text(VALUE));
        Assertions.assertThat((Object)((InputClauseColumnHeaderMetaData)this.headerMetaData).getValue()).isNotNull();
        Assertions.assertThat((String)((InputClauseColumnHeaderMetaData)this.headerMetaData).getValue().getValue()).isEqualTo(VALUE);
    }

    @Test
    public void testGetPopoverTitle() {
        Assertions.assertThat((String)((InputClauseColumnHeaderMetaData)this.headerMetaData).getPopoverTitle()).isEqualTo("DecisionTableEditor.EditInputClause");
    }
}

