/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGrid;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public abstract class BaseFunctionSupplementaryGridTest<D extends ExpressionEditorDefinition<Context>> {
    @Mock
    protected DMNGridPanel gridPanel;
    @Mock
    protected DMNGridLayer gridLayer;
    @Mock
    protected DefinitionUtils definitionUtils;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected DMNSession session;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    protected CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    protected ListSelectorView.Presenter listSelector;
    @Mock
    protected TranslationService translationService;
    @Mock
    protected Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    protected EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    protected EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    protected EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    private Optional<Context> expression = Optional.empty();
    private Optional<HasName> hasName = Optional.empty();
    private D definition;
    protected FunctionSupplementaryGrid grid;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.definition = this.getEditorDefinition();
        this.expression = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), this.hasExpression, this.expression);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add(this.definition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        this.setupEditorDefinitions(expressionEditorDefinitions);
    }

    protected void setupGrid(int nesting) {
        Mockito.when((Object)this.hasExpression.getExpression()).thenReturn((Object)this.expression.get());
        this.grid = (FunctionSupplementaryGrid)this.definition.getEditor(this.parent, Optional.empty(), this.hasExpression, this.hasName, false, nesting).get();
    }

    protected abstract D getEditorDefinition();

    protected abstract String[] getExpectedNames();

    protected abstract void setupEditorDefinitions(ExpressionEditorDefinitions var1);

    protected abstract BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper> getExpectedExpressionValueEditor(int var1);

    @Test
    public void testInitialColumnWidthsFromDefinition() {
        this.setupGrid(0);
        this.assertComponentWidths(50.0, 100.0, 200.0);
    }

    @Test
    public void testInitialColumnWidthsFromExpression() {
        List componentWidths = this.expression.get().getComponentWidths();
        componentWidths.set(0, 100.0);
        componentWidths.set(1, 200.0);
        componentWidths.set(2, 300.0);
        this.setupGrid(0);
        this.assertComponentWidths(100.0, 200.0, 300.0);
    }

    private void assertComponentWidths(double ... widths) {
        GridData uiModel = this.grid.getModel();
        IntStream.range(0, widths.length).forEach(i -> Assert.assertEquals((double)widths[i], (double)((GridColumn)uiModel.getColumns().get(i)).getWidth(), (double)0.0));
    }

    @Test
    public void testCacheable() {
        this.setupGrid(0);
        Assert.assertTrue((boolean)this.grid.isCacheable());
    }

    @Test
    public void testGetExpressionValue() {
        this.setupGrid(0);
        String[] expectedNames = this.getExpectedNames();
        for (int uiRowIndex = 0; uiRowIndex < expectedNames.length; ++uiRowIndex) {
            String value = expectedNames[uiRowIndex] + "-value";
            ((IsLiteralExpression)((ContextEntry)this.expression.get().getContextEntry().get(uiRowIndex)).getExpression()).getText().setValue(value);
            Assert.assertEquals((Object)value, (Object)this.grid.getExpressionValue(this.getExpectedNames()[uiRowIndex]));
        }
    }

    @Test
    public void testGetExpressionValueQuoteRemoval() {
        this.setupGrid(0);
        String[] expectedNames = this.getExpectedNames();
        for (int uiRowIndex = 0; uiRowIndex < expectedNames.length; ++uiRowIndex) {
            String value = expectedNames[uiRowIndex] + "-value";
            ((IsLiteralExpression)((ContextEntry)this.expression.get().getContextEntry().get(uiRowIndex)).getExpression()).getText().setValue("\"" + value + "\"");
            Assert.assertEquals((Object)value, (Object)this.grid.getExpressionValue(this.getExpectedNames()[uiRowIndex]));
        }
    }

    @Test
    public void testGetExpressionValueEditor() {
        this.setupGrid(0);
        String[] expectedNames = this.getExpectedNames();
        for (int uiRowIndex = 0; uiRowIndex < expectedNames.length; ++uiRowIndex) {
            Optional valueEditor = this.grid.getExpressionValueEditor(this.getExpectedNames()[uiRowIndex]);
            Assert.assertTrue((boolean)valueEditor.isPresent());
            Assert.assertEquals(this.getExpectedExpressionValueEditor(uiRowIndex), valueEditor.get());
        }
    }
}

