/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.list;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.list.ListUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

@RunWith(value=MockitoJUnitRunner.class)
public class ListUIModelMapperTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    @Mock
    private UndefinedExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid undefinedExpressionEditor;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private GridWidget gridWidget;
    @Captor
    private ArgumentCaptor<GridCellTuple> parentCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private BaseGridData uiModel;
    private List list;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private ListUIModelMapper mapper;

    public void setup(Expression expression, boolean isOnlyVisualChangeAllowedSupplier) {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        Mockito.when((Object)this.uiRowNumberColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.uiExpressionEditorColumn.getIndex()).thenReturn((Object)1);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditor.getExpression()).thenReturn(() -> Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        Mockito.when((Object)this.undefinedExpressionEditor.getExpression()).thenReturn(Optional::empty);
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.undefinedExpressionEditor));
        this.list = new List();
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)expression));
        this.mapper = new ListUIModelMapper(this.gridWidget, () -> this.uiModel, () -> Optional.of(this.list), () -> isOnlyVisualChangeAllowedSupplier, this.expressionEditorDefinitionsSupplier, this.listSelector, 0);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.setup((Expression)new LiteralExpression(), false);
        this.mapper.fromDMNModel(0, 0);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 0).getValue().getValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 0).getSelectionStrategy()).isSameAs((Object)RowSelectionStrategy.INSTANCE);
    }

    @Test
    public void testFromDMNModelUndefinedExpression() {
        this.setup(null, false);
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, null));
        this.mapper.fromDMNModel(0, 1);
        this.assertFromDMNModelUndefinedExpression(false);
    }

    @Test
    public void testFromDMNModelUndefinedExpressionWhenOnlyVisualChangeAllowed() {
        this.setup(null, true);
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, null));
        this.mapper.fromDMNModel(0, 1);
        this.assertFromDMNModelUndefinedExpression(true);
    }

    private void assertFromDMNModelUndefinedExpression(boolean isOnlyVisualChangeAllowed) {
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 1).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)this.uiModel.getCell(0, 1).getValue();
        Assert.assertEquals((Object)this.undefinedExpressionEditor, ((Optional)dcv.getValue()).get());
        ((UndefinedExpressionEditorDefinition)Mockito.verify((Object)this.undefinedExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)Matchers.eq(Optional.empty()), (HasExpression)Matchers.eq(this.list.getExpression().get(0)), (Optional)Matchers.eq(Optional.empty()), Matchers.eq((boolean)isOnlyVisualChangeAllowed), Matchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)1L, (long)parent.getColumnIndex());
        Assert.assertEquals((Object)this.gridWidget, (Object)parent.getGridWidget());
    }

    @Test
    public void testFromDMNModelLiteralExpression() {
        this.setup((Expression)new LiteralExpression(), false);
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression()));
        this.mapper.fromDMNModel(0, 1);
        this.assertFromDMNModelLiteralExpression(false);
    }

    @Test
    public void testFromDMNModelLiteralExpressionWhenOnlyVisualChangeAllowed() {
        this.setup((Expression)new LiteralExpression(), true);
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression()));
        this.mapper.fromDMNModel(0, 1);
        this.assertFromDMNModelLiteralExpression(true);
    }

    private void assertFromDMNModelLiteralExpression(boolean isOnlyVisualChangeAllowed) {
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 1).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)this.uiModel.getCell(0, 1).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv.getValue()).get());
        ((ExpressionEditorDefinition)Mockito.verify((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)this.parentCaptor.capture(), (Optional)Matchers.eq(Optional.empty()), (HasExpression)Matchers.eq(this.list.getExpression().get(0)), (Optional)Matchers.eq(Optional.empty()), Matchers.eq((boolean)isOnlyVisualChangeAllowed), Matchers.eq((int)1));
        GridCellTuple parent = (GridCellTuple)this.parentCaptor.getValue();
        Assert.assertEquals((long)0L, (long)parent.getRowIndex());
        Assert.assertEquals((long)1L, (long)parent.getColumnIndex());
        Assert.assertEquals((Object)this.gridWidget, (Object)parent.getGridWidget());
    }

    @Test
    public void testFromDMNModelCellTypes() {
        this.setup((Expression)new LiteralExpression(), false);
        IntStream.range(0, 1).forEach(rowIndex -> {
            this.mapper.fromDMNModel(rowIndex, 0);
            this.mapper.fromDMNModel(rowIndex, 1);
        });
        Assertions.assertThat((Object)this.uiModel.getCell(0, 0)).isInstanceOf(ContextGridCell.class);
        Assertions.assertThat((Object)this.uiModel.getCell(0, 1)).isInstanceOf(ContextGridCell.class);
    }

    @Test
    public void testToDMNModelExpressionNull() {
        this.setup((Expression)new LiteralExpression(), false);
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.undefinedExpressionEditor)));
        this.mapper.toDMNModel(0, 1, this.cellValueSupplier);
        Assert.assertNull((Object)((HasExpression)this.list.getExpression().get(0)).getExpression());
    }

    @Test
    public void testToDMNModelExpressionNonNull() {
        this.setup(null, false);
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        this.mapper.toDMNModel(0, 1, this.cellValueSupplier);
        Assert.assertEquals((Object)this.literalExpression, (Object)((HasExpression)this.list.getExpression().get(0)).getExpression());
    }
}

