/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.literal;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.GridFactoryCommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.BaseLiteralExpressionGridTest;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseDelegatingExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.DelegatingGridWidgetCellSelectorMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.EditableHeaderGridWidgetEditCellMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class LiteralExpressionGridTest
extends BaseLiteralExpressionGridTest<LiteralExpressionGrid> {
    private static final String NAME_NEW = "name-new";

    @Override
    protected BaseEditorDefinition<LiteralExpression, DMNGridData> getDefinition() {
        return new LiteralExpressionEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, (Event)this.editorSelectedEvent, (Event)this.refreshFormPropertiesEvent, (Event)this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.headerEditor, this.readOnlyProvider);
    }

    @Override
    protected void setupGrid(int nesting) {
        this.hasExpression.setExpression((Expression)this.expression.get());
        this.grid = (BaseDelegatingExpressionGrid)Mockito.spy((Object)((LiteralExpressionGrid)this.definition.getEditor(this.parent, nesting == 0 ? Optional.of("uuid") : Optional.empty(), (HasExpression)this.hasExpression, this.hasName, false, nesting).get()));
    }

    @Test
    public void testMouseClickEventHandlers() {
        this.setupGrid(0);
        List handlers = ((LiteralExpressionGrid)this.grid).getNodeMouseClickEventHandlers(this.selectionManager);
        Assertions.assertThat((List)handlers).hasSize(2);
        Assertions.assertThat(handlers.get(0)).isInstanceOf(DelegatingGridWidgetCellSelectorMouseEventHandler.class);
        Assertions.assertThat(handlers.get(1)).isInstanceOf(EditableHeaderGridWidgetEditCellMouseEventHandler.class);
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid(0);
        GridData uiModel = ((LiteralExpressionGrid)this.grid).getModel();
        Assertions.assertThat((Object)uiModel).isInstanceOf(DMNGridData.class);
        Assertions.assertThat((int)uiModel.getColumnCount()).isEqualTo(1);
        Assertions.assertThat(uiModel.getColumns().get(0)).isInstanceOf(LiteralExpressionColumn.class);
        Assertions.assertThat((int)uiModel.getRowCount()).isEqualTo(1);
        Assertions.assertThat((Object)uiModel.getCell(0, 0).getValue().getValue()).isEqualTo((Object)"expression");
    }

    @Test
    public void testBodyFactoryWhenNested() {
        this.setupGrid(1);
        TextAreaSingletonDOMElementFactory factory = ((LiteralExpressionGrid)this.grid).getBodyTextAreaFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testBodyFactoryWhenNotNested() {
        this.setupGrid(0);
        TextAreaSingletonDOMElementFactory factory = ((LiteralExpressionGrid)this.grid).getBodyTextAreaFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testGetDisplayName() {
        this.setupGrid(0);
        Assertions.assertThat((String)this.extractHeaderMetaData().getValue().getValue()).isEqualTo("name");
    }

    private LiteralExpressionColumnHeaderMetaData extractHeaderMetaData() {
        LiteralExpressionColumn column = (LiteralExpressionColumn)((LiteralExpressionGrid)this.grid).getModel().getColumns().get(0);
        return (LiteralExpressionColumnHeaderMetaData)column.getHeaderMetaData().get(0);
    }

    @Test
    public void testSetDisplayNameWithNoChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setValue((Object)new Name("name"));
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (Command)Matchers.any(Command.class));
    }

    @Test
    public void testSetDisplayNameWithEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setValue((Object)new Name());
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((Command)this.compositeCommandCaptor.getValue(), DeleteHasValueCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNullValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setValue(null);
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((Command)this.compositeCommandCaptor.getValue(), DeleteHasValueCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNonEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setValue((Object)new Name(NAME_NEW));
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((Command)this.compositeCommandCaptor.getValue(), SetHasValueCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testGetTypeRef() {
        this.setupGrid(0);
        Assertions.assertThat((Object)this.extractHeaderMetaData().getTypeRef()).isNotNull();
    }

    @Test
    public void testSetTypeRef() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName("", BuiltInType.DATE.getName()));
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSetTypeRefWithoutChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName());
        ((SessionCommandManager)Mockito.verify((Object)this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSelectHeader() {
        this.setupGrid(0);
        ((LiteralExpressionGrid)this.grid).selectHeaderCell(0, 0, false, false);
        ((EventSourceMock)Mockito.verify((Object)this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)this.hasExpression);
    }

    @Test
    public void testAsDMNModelInstrumentedBase() {
        this.setupGrid(0);
        Assertions.assertThat((Object)this.extractHeaderMetaData().asDMNModelInstrumentedBase()).isInstanceOf(this.hasExpression.getVariable().getClass());
    }

    @Override
    protected double getDefaultWidth() {
        return 300.0;
    }
}

