/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.appformer.client.context.Channel;
import org.appformer.client.context.EditorContextProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.included.common.IncludedModelsContext;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class IncludedModelsContextTest {
    @Mock
    private EditorContextProvider contextProvider;
    private IncludedModelsContext includedModelsContext;

    @Before
    public void setup() {
        this.includedModelsContext = new IncludedModelsContext(this.contextProvider);
    }

    @Test
    public void testIsIncludedModelChannelWhenChannelIsDefault() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.DEFAULT);
        Assert.assertTrue((boolean)this.includedModelsContext.isIncludedModelChannel());
    }

    @Test
    public void testIsIncludedModelChannelWhenChannelIsVSCode() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.VSCODE);
        Assert.assertTrue((boolean)this.includedModelsContext.isIncludedModelChannel());
    }

    @Test
    public void testIsIncludedModelChannelWhenChannelIsEmbedded() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.EMBEDDED);
        Assert.assertTrue((boolean)this.includedModelsContext.isIncludedModelChannel());
    }

    @Test
    public void testIsIncludedModelChannelWhenChannelIsOnline() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.ONLINE);
        Assert.assertFalse((boolean)this.includedModelsContext.isIncludedModelChannel());
    }

    @Test
    public void testIsIncludedModelChannelWhenChannelIsGithub() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.GITHUB);
        Assert.assertFalse((boolean)this.includedModelsContext.isIncludedModelChannel());
    }

    @Test
    public void testIsIncludedModelChannelWhenChannelIsDesktop() {
        Mockito.when((Object)this.contextProvider.getChannel()).thenReturn((Object)Channel.DESKTOP);
        Assert.assertFalse((boolean)this.includedModelsContext.isIncludedModelChannel());
    }
}

