/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.grid;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DMNIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.DefaultIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.PMMLIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardsGridComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.DefaultCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.PMMLCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.empty.DMNCardsEmptyStateView;
import org.kie.workbench.common.widgets.client.cards.CardsGridComponent;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNCardsGridComponentTest {
    @Mock
    private ManagedInstance<DMNCardComponent> dmnCardComponent;
    @Mock
    private ManagedInstance<PMMLCardComponent> pmmlCardComponent;
    @Mock
    private ManagedInstance<DefaultCardComponent> defaultCardComponent;
    @Mock
    private CardsGridComponent cardsGridComponent;
    @Mock
    private IncludedModelsPageState pageState;
    @Mock
    private DMNCardsEmptyStateView emptyStateView;
    private DMNCardsGridComponent grid;

    @Before
    public void setup() {
        this.grid = new DMNCardsGridComponent(this.dmnCardComponent, this.pmmlCardComponent, this.defaultCardComponent, this.cardsGridComponent, this.pageState, this.emptyStateView);
    }

    @Test
    public void testInit() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.emptyStateView.getElement()).thenReturn((Object)element);
        this.grid.init();
        ((CardsGridComponent)Mockito.verify((Object)this.cardsGridComponent)).setEmptyState(element);
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.cardsGridComponent.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.grid.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testRefresh() {
        DefaultIncludedModelActiveRecord includedModel1 = (DefaultIncludedModelActiveRecord)Mockito.mock(DefaultIncludedModelActiveRecord.class);
        DMNIncludedModelActiveRecord includedModel2 = (DMNIncludedModelActiveRecord)Mockito.mock(DMNIncludedModelActiveRecord.class);
        PMMLIncludedModelActiveRecord includedModel3 = (PMMLIncludedModelActiveRecord)Mockito.mock(PMMLIncludedModelActiveRecord.class);
        DefaultCardComponent card1 = (DefaultCardComponent)Mockito.mock(DefaultCardComponent.class);
        DMNCardComponent card2 = (DMNCardComponent)Mockito.mock(DMNCardComponent.class);
        PMMLCardComponent card3 = (PMMLCardComponent)Mockito.mock(PMMLCardComponent.class);
        List<BaseIncludedModelActiveRecord> includedModels = Arrays.asList(includedModel1, includedModel2, includedModel3);
        Mockito.when((Object)this.pageState.generateIncludedModels()).thenReturn(includedModels);
        Mockito.when((Object)this.defaultCardComponent.get()).thenReturn((Object)card1);
        Mockito.when((Object)this.dmnCardComponent.get()).thenReturn((Object)card2);
        Mockito.when((Object)this.pmmlCardComponent.get()).thenReturn((Object)card3);
        this.grid.refresh();
        ((DefaultCardComponent)Mockito.verify((Object)card1)).setup(this.grid, (BaseIncludedModelActiveRecord)includedModel1);
        ((DMNCardComponent)Mockito.verify((Object)card2)).setup(this.grid, (BaseIncludedModelActiveRecord)includedModel2);
        ((PMMLCardComponent)Mockito.verify((Object)card3)).setup(this.grid, (BaseIncludedModelActiveRecord)includedModel3);
        ((CardsGridComponent)Mockito.verify((Object)this.cardsGridComponent)).setupCards(Arrays.asList(card1, card2, card3));
    }
}

