/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditor;
import org.kie.workbench.common.dmn.client.editors.search.DMNDataTypesSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNEditorSearchIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNGraphSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNGridSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.widgets.client.search.common.HasSearchableElements;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNEditorSearchIndexTest {
    @Mock
    private DMNGraphSubIndex graphSubIndex;
    @Mock
    private DMNGridSubIndex gridSubIndex;
    @Mock
    private DMNDataTypesSubIndex dataTypesSubIndex;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession dmnSession;
    @Mock
    private ExpressionEditor expressionEditor;
    private List<DMNSearchableElement> expectedElements = Arrays.asList((DMNSearchableElement)Mockito.mock(DMNSearchableElement.class), (DMNSearchableElement)Mockito.mock(DMNSearchableElement.class));
    private DMNEditorSearchIndex searchIndex;

    @Before
    public void setup() {
        this.searchIndex = (DMNEditorSearchIndex)Mockito.spy((Object)new DMNEditorSearchIndex(this.graphSubIndex, this.gridSubIndex, this.dataTypesSubIndex, this.sessionManager, null));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.dmnSession);
        Mockito.when((Object)this.dmnSession.getExpressionEditor()).thenReturn((Object)this.expressionEditor);
    }

    @Test
    public void testInit() {
        Command noResultsFoundCallback = (Command)Mockito.mock(Command.class);
        Command searchClosedCallback = (Command)Mockito.mock(Command.class);
        ((DMNEditorSearchIndex)Mockito.doReturn((Object)noResultsFoundCallback).when((Object)this.searchIndex)).getNoResultsFoundCallback();
        ((DMNEditorSearchIndex)Mockito.doReturn((Object)searchClosedCallback).when((Object)this.searchIndex)).getSearchClosedCallback();
        this.searchIndex.init();
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.searchIndex)).registerSubIndex((HasSearchableElements)this.graphSubIndex);
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.searchIndex)).registerSubIndex((HasSearchableElements)this.gridSubIndex);
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.searchIndex)).setNoResultsFoundCallback(noResultsFoundCallback);
        ((DMNEditorSearchIndex)Mockito.verify((Object)this.searchIndex)).setSearchClosedCallback(searchClosedCallback);
    }

    @Test
    public void testGetNoResultsFoundCallbackWhenDataTypesTabIsActive() {
        this.searchIndex.setIsDataTypesTabActiveSupplier(() -> true);
        this.searchIndex.getNoResultsFoundCallback().execute();
        ((DMNDataTypesSubIndex)Mockito.verify((Object)this.dataTypesSubIndex)).onNoResultsFound();
    }

    @Test
    public void testGetNoResultsFoundCallbackWhenExpressionEditorIsActive() {
        Mockito.when((Object)this.expressionEditor.isActive()).thenReturn((Object)true);
        this.searchIndex.getNoResultsFoundCallback().execute();
        ((DMNGridSubIndex)Mockito.verify((Object)this.gridSubIndex)).onNoResultsFound();
    }

    @Test
    public void testGetNoResultsFoundCallbackWhenExpressionEditorIsNotActive() {
        Mockito.when((Object)this.expressionEditor.isActive()).thenReturn((Object)false);
        this.searchIndex.getNoResultsFoundCallback().execute();
        ((DMNGraphSubIndex)Mockito.verify((Object)this.graphSubIndex)).onNoResultsFound();
    }

    @Test
    public void testSearchClosedCallbackExpressionEditorIsActive() {
        Mockito.when((Object)this.expressionEditor.isActive()).thenReturn((Object)true);
        this.searchIndex.getSearchClosedCallback().execute();
        ((DMNGridSubIndex)Mockito.verify((Object)this.gridSubIndex)).onSearchClosed();
    }

    @Test
    public void testSearchClosedCallbackDataTypeEditorIsActive() {
        this.searchIndex.setIsDataTypesTabActiveSupplier(() -> true);
        this.searchIndex.getSearchClosedCallback().execute();
        ((DMNDataTypesSubIndex)Mockito.verify((Object)this.dataTypesSubIndex)).onSearchClosed();
    }

    @Test
    public void testSearchClosedCallbackGraphEditorIsActive() {
        Mockito.when((Object)this.expressionEditor.isActive()).thenReturn((Object)false);
        this.searchIndex.getSearchClosedCallback().execute();
        ((DMNGraphSubIndex)Mockito.verify((Object)this.graphSubIndex)).onSearchClosed();
    }

    @Test
    public void testGetSearchableElementsWhenDataTypesTabIsActive() {
        Mockito.when((Object)this.expressionEditor.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypesSubIndex.getSearchableElements()).thenReturn(this.expectedElements);
        Mockito.when((Object)this.gridSubIndex.getSearchableElements()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.graphSubIndex.getSearchableElements()).thenReturn(Collections.emptyList());
        this.searchIndex.setIsDataTypesTabActiveSupplier(() -> true);
        List actualElements = this.searchIndex.getSearchableElements();
        Assert.assertEquals(this.expectedElements, (Object)actualElements);
    }

    @Test
    public void testGetSearchableElementsWhenExpressionEditorIsActive() {
        Mockito.when((Object)this.expressionEditor.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.gridSubIndex.getSearchableElements()).thenReturn(this.expectedElements);
        Mockito.when((Object)this.graphSubIndex.getSearchableElements()).thenReturn(Collections.emptyList());
        List actualElements = this.searchIndex.getSearchableElements();
        Assert.assertEquals(this.expectedElements, (Object)actualElements);
    }

    @Test
    public void testGetSearchableElementsWhenExpressionEditorIsNotActive() {
        Mockito.when((Object)this.expressionEditor.isActive()).thenReturn((Object)false);
        Mockito.when((Object)this.gridSubIndex.getSearchableElements()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.graphSubIndex.getSearchableElements()).thenReturn(this.expectedElements);
        List actualElements = this.searchIndex.getSearchableElements();
        Assert.assertEquals(this.expectedElements, (Object)actualElements);
    }

    @Test
    public void testGetSearchableElementsWhenSessionIsNull() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn(null);
        Mockito.when((Object)this.gridSubIndex.getSearchableElements()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.graphSubIndex.getSearchableElements()).thenReturn(this.expectedElements);
        List actualElements = this.searchIndex.getSearchableElements();
        Assert.assertEquals(this.expectedElements, (Object)actualElements);
    }
}

