/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;

public class DataTypeManagerStackStoreTest {
    private DataTypeManagerStackStore typeStack;
    private String uuid = "123";
    private List<String> types = Arrays.asList("tCity", "tPerson");

    @Before
    public void setup() {
        this.typeStack = new DataTypeManagerStackStore();
        this.typeStack.put(this.uuid, this.types);
    }

    @Test
    public void testGetWhenTypeStackHasTheUUID() {
        Assert.assertEquals(this.types, (Object)this.typeStack.get(this.uuid));
    }

    @Test
    public void testGetWhenTypeStackDoesNotHaveTheUUID() {
        List expectedTypes = Collections.emptyList();
        List actualTypes = this.typeStack.get("otherUUID");
        Assert.assertEquals(expectedTypes, (Object)actualTypes);
    }

    @Test
    public void testPut() {
        String uuid = "456";
        List<String> expectedTypes = Arrays.asList("tCompany", "tPerson");
        this.typeStack.put("456", expectedTypes);
        List actualTypes = this.typeStack.get("456");
        Assert.assertEquals(expectedTypes, (Object)actualTypes);
    }

    @Test
    public void testClear() {
        this.typeStack.clear();
        Assert.assertEquals((long)0L, (long)this.typeStack.size());
    }
}

