/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.DataTypeChangedEvent;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.DataTypeConfirmation;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.validation.DataTypeNameFormatValidator;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeListItemTest {
    @Mock
    private DataTypeListItem.View view;
    @Mock
    private DataTypeSelect dataTypeSelectComponent;
    @Mock
    private DataTypeConstraint dataTypeConstraintComponent;
    @Mock
    private SmallSwitchComponent dataTypeListComponent;
    @Mock
    private DataType dataType;
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private DataTypeList dataTypeList;
    @Mock
    private DataTypeConfirmation confirmation;
    @Mock
    private EventSourceMock<DataTypeEditModeToggleEvent> editModeToggleEvent;
    @Mock
    private DataTypeNameFormatValidator nameFormatValidator;
    @Mock
    private EventSourceMock<DataTypeChangedEvent> dataTypeChangedEvent;
    @Captor
    private ArgumentCaptor<DataTypeEditModeToggleEvent> eventArgumentCaptor;
    private String structure = "Structure";
    private DataTypeManager dataTypeManager;
    private DataTypeListItem listItem;

    @Before
    public void setup() {
        this.dataTypeManager = (DataTypeManager)Mockito.spy((Object)new DataTypeManager(null, null, this.itemDefinitionStore, null, null, null, null, null));
        ((DataTypeManager)Mockito.doReturn((Object)this.structure).when((Object)this.dataTypeManager)).structure();
        this.listItem = (DataTypeListItem)Mockito.spy((Object)new DataTypeListItem(this.view, this.dataTypeSelectComponent, this.dataTypeConstraintComponent, this.dataTypeListComponent, this.dataTypeManager, this.confirmation, this.nameFormatValidator, this.editModeToggleEvent, this.dataTypeChangedEvent));
        this.listItem.setup();
        this.listItem.init(this.dataTypeList);
    }

    @Test
    public void testSetup() {
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).init((Object)this.listItem);
    }

    @Test
    public void testGetContentElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.listItem.getContentElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testSetupDataType() {
        DataType expectedDataType = this.dataType;
        boolean expectedLevel = true;
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).setupDragAndDropComponent();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).setupView();
        this.listItem.setupDataType(expectedDataType, 1);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.listItem});
        ((DataTypeListItem)inOrder.verify((Object)this.listItem)).setupDragAndDropComponent();
        ((DataTypeListItem)inOrder.verify((Object)this.listItem)).setupSelectComponent();
        ((DataTypeListItem)inOrder.verify((Object)this.listItem)).setupListComponent();
        ((DataTypeListItem)inOrder.verify((Object)this.listItem)).setupConstraintComponent();
        ((DataTypeListItem)inOrder.verify((Object)this.listItem)).setupView();
        Assert.assertEquals((Object)expectedDataType, (Object)this.listItem.getDataType());
        Assert.assertEquals((long)1L, (long)this.listItem.getLevel());
    }

    @Test
    public void testSetupDragAndDropComponent() {
        DNDListComponent dragAndDropComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dragAndDropComponent);
        Mockito.when((Object)this.listItem.getContentElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)dragAndDropComponent.registerNewItem(htmlElement)).thenReturn((Object)expectedElement);
        this.listItem.setupDragAndDropComponent();
        HTMLElement actualElement = this.listItem.getDragAndDropElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testSetupConstraintComponent() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        this.listItem.setupConstraintComponent();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).init(this.listItem);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).refreshConstraintComponent();
    }

    @Test
    public void testSetupListComponentWhenDataTypeIsList() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        boolean isList = true;
        Mockito.when((Object)dataType.isList()).thenReturn((Object)true);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        this.listItem.setupListComponent();
        ((SmallSwitchComponent)Mockito.verify((Object)this.dataTypeListComponent)).setValue(true);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).refreshListYesLabel();
    }

    @Test
    public void testSetupListComponentWhenDataTypeIsNotList() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        boolean isList = false;
        Mockito.when((Object)dataType.isList()).thenReturn((Object)false);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        this.listItem.setupListComponent();
        ((SmallSwitchComponent)Mockito.verify((Object)this.dataTypeListComponent)).setValue(false);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).refreshListYesLabel();
    }

    @Test
    public void testSetupSelectComponent() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        this.listItem.setupSelectComponent();
        ((DataTypeSelect)Mockito.verify((Object)this.dataTypeSelectComponent)).init(this.listItem, dataType);
    }

    @Test
    public void testSetupView() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)this.listItem.getDataType()).thenReturn((Object)dataType);
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).setupIndentationLevel();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).hideTooltips();
        this.listItem.setupView();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).setupSelectComponent(this.dataTypeSelectComponent);
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).setupConstraintComponent(this.dataTypeConstraintComponent);
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).setupListComponent(this.dataTypeListComponent);
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).setDataType(dataType);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).setupIndentationLevel();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).hideTooltips();
    }

    @Test
    public void testExpandOrCollapseSubTypesWhenViewIsCollapsed() {
        Mockito.when((Object)this.view.isCollapsed()).thenReturn((Object)true);
        this.listItem.expandOrCollapseSubTypes();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).expand();
    }

    @Test
    public void testExpandOrCollapseSubTypesWhenViewIsNotCollapsed() {
        Mockito.when((Object)this.view.isCollapsed()).thenReturn((Object)false);
        this.listItem.expandOrCollapseSubTypes();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).collapse();
    }

    @Test
    public void testCollapse() {
        HTMLElement dragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dragAndDropElement).when((Object)this.listItem)).getDragAndDropElement();
        this.listItem.collapse();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).collapse();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel((Element)dragAndDropElement);
    }

    @Test
    public void testExpand() {
        HTMLElement dragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dragAndDropElement).when((Object)this.listItem)).getDragAndDropElement();
        this.listItem.expand();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).expand();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel((Element)dragAndDropElement);
    }

    @Test
    public void testRefreshSubItems() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        List<DataType> dataTypes = Collections.singletonList(dataType);
        this.listItem.refreshSubItems(dataTypes, true);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshSubItemsFromListItem(this.listItem, dataTypes);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).expandOrCollapseSubTypes();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).enableFocusMode();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).toggleArrow(Matchers.anyBoolean());
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel(dataType);
    }

    @Test
    public void testRefreshSubItemsNotSetFocus() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        List<DataType> dataTypes = Collections.singletonList(dataType);
        this.listItem.refreshSubItems(dataTypes, false);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshSubItemsFromListItem(this.listItem, dataTypes);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).expandOrCollapseSubTypes();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableFocusMode();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).toggleArrow(Matchers.anyBoolean());
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel(dataType);
    }

    @Test
    public void testEnableEditMode() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String expectedName = "name";
        String expectedType = "type";
        String expectedConstraint = "constraint";
        boolean expectedIsList = true;
        String expectedConstraintType = "";
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"type");
        Mockito.when((Object)dataType.getConstraint()).thenReturn((Object)"constraint");
        Mockito.when((Object)dataType.isList()).thenReturn((Object)true);
        Mockito.when((Object)this.view.isOnFocusMode()).thenReturn((Object)false);
        this.listItem.enableEditMode();
        Assert.assertEquals((Object)"name", (Object)this.listItem.getOldName());
        Assert.assertEquals((Object)"type", (Object)this.listItem.getOldType());
        Assert.assertEquals((Object)"constraint", (Object)this.listItem.getOldConstraint());
        Assert.assertEquals((Object)true, (Object)this.listItem.getOldIsList());
        Assert.assertEquals((Object)"", (Object)this.listItem.getOldConstraintType());
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).showSaveButton();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).showDataTypeNameInput();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).enableFocusMode();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).hideListYesLabel();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).showListContainer();
        ((DataTypeSelect)Mockito.verify((Object)this.dataTypeSelectComponent)).enableEditMode();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).enableEditMode();
        ((EventSourceMock)Mockito.verify(this.editModeToggleEvent)).fire(this.eventArgumentCaptor.capture());
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).fireOnDataTypeListItemUpdateCallback(this.listItem);
        Assert.assertTrue((boolean)((DataTypeEditModeToggleEvent)this.eventArgumentCaptor.getValue()).isEditModeEnabled());
    }

    @Test
    public void testEnableEditModeWhenDataTypeListItemIsAlreadyOnEditMode() {
        Mockito.when((Object)this.view.isOnFocusMode()).thenReturn((Object)true);
        this.listItem.enableEditMode();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showSaveButton();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showDataTypeNameInput();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableFocusMode();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideListYesLabel();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showListContainer();
        ((DataTypeSelect)Mockito.verify((Object)this.dataTypeSelectComponent, (VerificationMode)Mockito.never())).enableEditMode();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent, (VerificationMode)Mockito.never())).enableEditMode();
        ((EventSourceMock)Mockito.verify(this.editModeToggleEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.never())).fireOnDataTypeListItemUpdateCallback((DataTypeListItem)Matchers.any(DataTypeListItem.class));
    }

    @Test
    public void testDisableEditMode() {
        Mockito.when((Object)this.view.isOnFocusMode()).thenReturn((Object)true);
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).discardNewDataType();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).closeEditMode();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).hideTooltips();
        this.listItem.disableEditMode();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).discardNewDataType();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).closeEditMode();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).hideTooltips();
    }

    @Test
    public void testDisableEditModeWhenDataTypeListItemIsNotOnEditMode() {
        Mockito.when((Object)this.view.isOnFocusMode()).thenReturn((Object)false);
        this.listItem.disableEditMode();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).discardNewDataType();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).closeEditMode();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem, (VerificationMode)Mockito.never())).hideTooltips();
    }

    @Test
    public void testSaveAndCloseEditModeWhenDataTypeIsValid() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        DataType updatedDataType = (DataType)Mockito.spy((Object)this.makeDataType());
        Command doSaveAndCloseCommand = (Command)Mockito.mock(Command.class);
        Command doDisableEditMode = (Command)Mockito.mock(Command.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doReturn((Object)updatedDataType).when((Object)this.listItem)).updateProperties(dataType);
        ((DataType)Mockito.doReturn((Object)true).when((Object)updatedDataType)).isValid();
        ((DataTypeListItem)Mockito.doReturn((Object)doSaveAndCloseCommand).when((Object)this.listItem)).doValidateDataTypeNameAndSave(updatedDataType);
        ((DataTypeListItem)Mockito.doReturn((Object)doDisableEditMode).when((Object)this.listItem)).doDisableEditMode();
        this.listItem.saveAndCloseEditMode();
        ((DataTypeConfirmation)Mockito.verify((Object)this.confirmation)).ifDataTypeDoesNotHaveLostSubDataTypes(updatedDataType, doSaveAndCloseCommand, doDisableEditMode);
    }

    @Test
    public void testDoDisableEditMode() {
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).disableEditMode();
        this.listItem.doDisableEditMode().execute();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).disableEditMode();
    }

    @Test
    public void testSaveAndCloseEditModeWhenDataTypeIsNotValid() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        DataType updatedDataType = (DataType)Mockito.spy((Object)this.makeDataType());
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doReturn((Object)updatedDataType).when((Object)this.listItem)).updateProperties(dataType);
        ((DataType)Mockito.doReturn((Object)false).when((Object)updatedDataType)).isValid();
        this.listItem.saveAndCloseEditMode();
        ((DataTypeConfirmation)Mockito.verify((Object)this.confirmation, (VerificationMode)Mockito.never())).ifDataTypeDoesNotHaveLostSubDataTypes((DataType)Matchers.any(), (Command)Matchers.any(), (Command)Matchers.any());
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).discardDataTypeProperties();
    }

    @Test
    public void testDoValidateDataTypeNameAndSave() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        Command saveAndCloseEditMode = (Command)Mockito.mock(Command.class);
        ((DataTypeListItem)Mockito.doReturn((Object)saveAndCloseEditMode).when((Object)this.listItem)).doSaveAndCloseEditMode(dataType);
        this.listItem.doValidateDataTypeNameAndSave(dataType).execute();
        ((DataTypeNameFormatValidator)Mockito.verify((Object)this.nameFormatValidator)).ifIsValid(dataType, saveAndCloseEditMode);
    }

    @Test
    public void testDoSaveAndCloseEditMode() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        List<DataType> updatedDataTypes = Collections.singletonList(this.makeDataType());
        String referenceDataTypeHash = "referenceDataTypeHash";
        String newDataTypeHash = "newDataTypeHash";
        ((DataTypeListItem)Mockito.doReturn(updatedDataTypes).when((Object)this.listItem)).persist(dataType);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doReturn((Object)"newDataTypeHash").when((Object)this.listItem)).getNewDataTypeHash(dataType, "referenceDataTypeHash");
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).insertNewFieldIfDataTypeIsStructure("newDataTypeHash");
        Mockito.when((Object)this.dataTypeList.calculateParentHash(dataType)).thenReturn((Object)"referenceDataTypeHash");
        this.listItem.doSaveAndCloseEditMode(dataType).execute();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshItemsByUpdatedDataTypes(updatedDataTypes);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).closeEditMode();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).fireOnDataTypeListItemUpdateCallback("newDataTypeHash");
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).insertNewFieldIfDataTypeIsStructure("newDataTypeHash");
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).fireDataChangedEvent();
    }

    @Test
    public void testInsertNewFieldIfDataTypeIsStructureWhenDataTypeIsStructure() {
        DataTypeListItem newListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String hash = "hash";
        Mockito.when((Object)newListItem.getDataType()).thenReturn((Object)dataType);
        Mockito.when((Object)dataType.hasSubDataTypes()).thenReturn((Object)false);
        Mockito.when((Object)newListItem.isStructureType()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("hash")).thenReturn(Optional.of(newListItem));
        this.listItem.insertNewFieldIfDataTypeIsStructure("hash");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).insertNestedField("hash");
    }

    @Test
    public void testInsertNewFieldIfDataTypeIsStructureWhenDataTypeIsStructureButHasFields() {
        DataTypeListItem newListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String hash = "hash";
        Mockito.when((Object)newListItem.getDataType()).thenReturn((Object)dataType);
        Mockito.when((Object)dataType.hasSubDataTypes()).thenReturn((Object)true);
        Mockito.when((Object)newListItem.isStructureType()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("hash")).thenReturn(Optional.of(newListItem));
        this.listItem.insertNewFieldIfDataTypeIsStructure("hash");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.never())).insertNestedField(Matchers.anyString());
    }

    @Test
    public void testInsertNewFieldIfDataTypeIsStructureWhenDataTypeIsNotStructure() {
        DataTypeListItem newListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String hash = "hash";
        Mockito.when((Object)newListItem.getDataType()).thenReturn((Object)dataType);
        Mockito.when((Object)dataType.hasSubDataTypes()).thenReturn((Object)false);
        Mockito.when((Object)newListItem.isStructureType()).thenReturn((Object)false);
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("hash")).thenReturn(Optional.of(newListItem));
        this.listItem.insertNewFieldIfDataTypeIsStructure("hash");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList, (VerificationMode)Mockito.never())).insertNestedField(Matchers.anyString());
    }

    @Test
    public void testPersist() {
        String uuid = "uuid";
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<DataType> subDataTypes = Collections.singletonList(this.makeDataType());
        List affectedDataTypes = Collections.emptyList();
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.dataTypeSelectComponent.getSubDataTypes()).thenReturn(subDataTypes);
        ((DataType)Mockito.doReturn((Object)"uuid").when((Object)dataType)).getUUID();
        ((DataType)Mockito.doReturn(affectedDataTypes).when((Object)dataType)).update();
        this.listItem.persist(dataType);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.dataTypeManager, dataType});
        ((DataTypeManager)inOrder.verify((Object)this.dataTypeManager)).from(dataType);
        ((DataTypeManager)inOrder.verify((Object)this.dataTypeManager)).withSubDataTypes(subDataTypes);
        ((DataTypeManager)inOrder.verify((Object)this.dataTypeManager)).get();
        ((DataType)inOrder.verify((Object)dataType)).update();
    }

    @Test
    public void testDiscardNewDataType() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        List subDataTypes = Collections.emptyList();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).setupSelectComponent();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).setupListComponent();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).setupIndentationLevel();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).refreshSubItems(subDataTypes, true);
        ((DataType)Mockito.doReturn(subDataTypes).when((Object)dataType)).getSubDataTypes();
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).discardDataTypeProperties();
        this.listItem.discardNewDataType();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).setDataType(dataType);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).setupListComponent();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).setupSelectComponent();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).setupConstraintComponent();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).refreshSubItems(subDataTypes, true);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).setupIndentationLevel();
    }

    @Test
    public void testDiscardDataTypeProperties() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        String expectedName = "name";
        String expectedType = "type";
        String expectedConstraint = "constraint";
        String expectedConstraintType = "enumeration";
        boolean expectedIsList = true;
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doReturn((Object)"name").when((Object)this.listItem)).getOldName();
        ((DataTypeListItem)Mockito.doReturn((Object)"type").when((Object)this.listItem)).getOldType();
        ((DataTypeListItem)Mockito.doReturn((Object)"constraint").when((Object)this.listItem)).getOldConstraint();
        ((DataTypeListItem)Mockito.doReturn((Object)true).when((Object)this.listItem)).getOldIsList();
        ((DataTypeListItem)Mockito.doReturn((Object)"enumeration").when((Object)this.listItem)).getOldConstraintType();
        this.listItem.discardDataTypeProperties();
        Assert.assertEquals((Object)"name", (Object)dataType.getName());
        Assert.assertEquals((Object)"type", (Object)dataType.getType());
        Assert.assertEquals((Object)"constraint", (Object)dataType.getConstraint());
        Assert.assertEquals((Object)true, (Object)dataType.isList());
        Assert.assertEquals((Object)"enumeration", (Object)dataType.getConstraintType().value());
    }

    @Test
    public void testCloseEditMode() {
        ((DataTypeListItem)Mockito.doReturn((Object)this.dataType).when((Object)this.listItem)).getDataType();
        this.listItem.closeEditMode();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).showEditButton();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).hideDataTypeNameInput();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).disableFocusMode();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).hideListContainer();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).refreshListYesLabel();
        ((DataTypeSelect)Mockito.verify((Object)this.dataTypeSelectComponent)).disableEditMode();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).disableEditMode();
        ((EventSourceMock)Mockito.verify(this.editModeToggleEvent)).fire(this.eventArgumentCaptor.capture());
        Assert.assertFalse((boolean)((DataTypeEditModeToggleEvent)this.eventArgumentCaptor.getValue()).isEditModeEnabled());
    }

    @Test
    public void testRefreshListYesLabelWhenDataTypeIsList() {
        ((DataTypeListItem)Mockito.doReturn((Object)this.dataType).when((Object)this.listItem)).getDataType();
        Mockito.when((Object)this.dataType.isList()).thenReturn((Object)true);
        this.listItem.refreshListYesLabel();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).showListYesLabel();
    }

    @Test
    public void testRefreshListYesLabelWhenDataTypeIsNotList() {
        ((DataTypeListItem)Mockito.doReturn((Object)this.dataType).when((Object)this.listItem)).getDataType();
        Mockito.when((Object)this.dataType.isList()).thenReturn((Object)false);
        this.listItem.refreshListYesLabel();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).hideListYesLabel();
    }

    @Test
    public void testUpdateProperties() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        String uuid = "uuid";
        String expectedName = "name";
        String expectedType = "type";
        String expectedConstraint = "constraint";
        boolean expectedList = true;
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"type");
        Mockito.when((Object)this.dataTypeConstraintComponent.getValue()).thenReturn((Object)"constraint");
        Mockito.when((Object)this.dataTypeListComponent.getValue()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)dataType);
        DataType updatedDataType = this.listItem.updateProperties(dataType);
        Assert.assertEquals((Object)"name", (Object)updatedDataType.getName());
        Assert.assertEquals((Object)"type", (Object)updatedDataType.getType());
        Assert.assertEquals((Object)"constraint", (Object)updatedDataType.getConstraint());
        Assert.assertEquals((Object)true, (Object)updatedDataType.isList());
    }

    @Test
    public void testUpdatePropertiesWithNameWithWhitespace() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        String uuid = "uuid";
        String expectedName = "name";
        String expectedNameWithWhitespace = "  name  ";
        String expectedType = "type";
        String expectedConstraint = "constraint";
        boolean expectedList = true;
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"  name  ");
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"type");
        Mockito.when((Object)this.dataTypeConstraintComponent.getValue()).thenReturn((Object)"constraint");
        Mockito.when((Object)this.dataTypeListComponent.getValue()).thenReturn((Object)true);
        Mockito.when((Object)this.dataTypeManager.get()).thenReturn((Object)dataType);
        DataType updatedDataType = this.listItem.updateProperties(dataType);
        Assert.assertEquals((Object)"name", (Object)updatedDataType.getName());
        Assert.assertEquals((Object)"type", (Object)updatedDataType.getType());
        Assert.assertEquals((Object)"constraint", (Object)updatedDataType.getConstraint());
        Assert.assertEquals((Object)true, (Object)updatedDataType.isList());
    }

    @Test
    public void testRefresh() {
        DataType dataType = (DataType)Mockito.spy((Object)this.makeDataType());
        String expectedConstraint = "constraint";
        String expectedName = "name";
        ((DataType)Mockito.doReturn((Object)"constraint").when((Object)dataType)).getConstraint();
        ((DataType)Mockito.doReturn((Object)"name").when((Object)dataType)).getName();
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).hideTooltips();
        this.listItem.refresh();
        ((DataTypeSelect)Mockito.verify((Object)this.dataTypeSelectComponent)).refresh();
        ((DataTypeSelect)Mockito.verify((Object)this.dataTypeSelectComponent)).init(this.listItem, dataType);
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).refreshView();
        ((DataTypeListItem.View)Mockito.verify((Object)this.view)).setName("name");
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).setupListComponent();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).setupConstraintComponent();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).hideTooltips();
    }

    @Test
    public void testRemove() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Command command = (Command)Mockito.mock(Command.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doReturn((Object)command).when((Object)this.listItem)).removeItem();
        this.listItem.remove();
        ((DataTypeConfirmation)Mockito.verify((Object)this.confirmation)).ifIsNotReferencedDataType(dataType, command);
    }

    @Test
    public void testRemoveItem() {
        Command command = this.listItem.removeItem();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).destroyWithDependentTypes();
        command.execute();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).disableEditModeForChildren(this.listItem);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).destroyWithDependentTypes();
    }

    @Test
    public void testDestroy() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        ArrayList<DataType> destroyedDataTypes = new ArrayList<DataType>(Arrays.asList(dataType0, dataType1, dataType2, dataType3));
        List<DataType> removedDataTypes = Arrays.asList(dataType1, dataType2);
        ((DataType)Mockito.doReturn(destroyedDataTypes).when((Object)dataType)).destroy();
        ((DataTypeListItem)Mockito.doReturn(removedDataTypes).when((Object)this.listItem)).removeTopLevelDataTypes(destroyedDataTypes);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).hideTooltips();
        this.listItem.destroy().execute();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshItemsByUpdatedDataTypes(Arrays.asList(dataType0, dataType3));
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).fireDataChangedEvent();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).hideTooltips();
    }

    @Test
    public void testDestroyWithDependentTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        List<DataType> removedDataTypes = Arrays.asList(dataType0, dataType1);
        Mockito.when((Object)dataType.destroy()).thenReturn(removedDataTypes);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).destroy((List)Matchers.any(), Matchers.eq((boolean)true));
        this.listItem.destroyWithDependentTypes();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).destroy(removedDataTypes, true);
    }

    @Test
    public void testDestroyWithoutDependentTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        List<DataType> removedDataTypes = Arrays.asList(dataType0);
        Mockito.when((Object)dataType.destroyWithoutDependentTypes()).thenReturn(removedDataTypes);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).destroy((List)Matchers.any(), Matchers.eq((boolean)false));
        this.listItem.destroyWithoutDependentTypes();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).destroy(removedDataTypes, false);
    }

    @Test
    public void testRemoveTopLevelDataTypesWhenItemDataTypeIsDestroyedDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        Mockito.when((Object)this.listItem.getDataType()).thenReturn((Object)dataType);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"Structure");
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"345");
        Mockito.when((Object)dataType0.getName()).thenReturn((Object)"tCidade");
        Mockito.when((Object)dataType0.getType()).thenReturn((Object)"tCity");
        Mockito.when((Object)dataType0.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"678");
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tCompany");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"Structure");
        Mockito.when((Object)dataType1.isTopLevel()).thenReturn((Object)true);
        List actualDataTypes = this.listItem.removeTopLevelDataTypes(Arrays.asList(dataType0, dataType1));
        List<DataType> expectedDataTypes = Collections.singletonList(dataType0);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).removeItem(dataType0);
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testRemoveTopLevelDataTypesWhenItemDataTypeIsAReferenceToDestroyedDataType() {
        String uuid = "uuid";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        ((DataTypeListItem)Mockito.doReturn((Object)dataType).when((Object)this.listItem)).getDataType();
        Mockito.when((Object)this.listItem.getDataType()).thenReturn((Object)dataType);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"Structure");
        Mockito.when((Object)dataType.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"012");
        Mockito.when((Object)dataType0.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)dataType0.getType()).thenReturn((Object)"Structure");
        Mockito.when((Object)dataType0.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"678");
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tCompany");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"Structure");
        Mockito.when((Object)dataType1.isTopLevel()).thenReturn((Object)true);
        List actualDataTypes = this.listItem.removeTopLevelDataTypes(Arrays.asList(dataType0, dataType1));
        List<DataType> expectedDataTypes = Collections.singletonList(dataType0);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).removeItem(dataType0);
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testInsertFieldAboveWhenTheNewDataTypeIsTopLevel() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem newListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataType> updatedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        String referenceDataTypeHash = "tDataType.id";
        String newDataTypeHash = "tDataType.name";
        Mockito.when((Object)newDataType.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)newDataType.create(reference, CreationType.ABOVE)).thenReturn(updatedDataTypes);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("tDataType.name")).thenReturn(Optional.of(newListItem));
        Mockito.when((Object)this.dataTypeList.calculateParentHash(reference)).thenReturn((Object)"tDataType.id");
        ((DataTypeListItem)Mockito.doReturn((Object)"tDataType.name").when((Object)this.listItem)).getNewDataTypeHash(newDataType, "tDataType.id");
        ((DataTypeManager)Mockito.doReturn((Object)this.dataTypeManager).when((Object)this.dataTypeManager)).fromNew();
        ((DataTypeManager)Mockito.doReturn((Object)newDataType).when((Object)this.dataTypeManager)).get();
        ((DataTypeListItem)Mockito.doReturn((Object)reference).when((Object)this.listItem)).getDataType();
        this.listItem.insertFieldAbove();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).closeEditMode();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).insertAbove(newDataType, reference);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).refreshItemsCSSAndHTMLPosition();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).enableEditModeAndUpdateCallbacks("tDataType.name");
    }

    @Test
    public void testInsertFieldAboveWhenTheNewDataTypeIsNotTopLevel() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem newListItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataType> updatedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        String referenceDataTypeHash = "tDataType.id";
        String newDataTypeHash = "tDataType.name";
        Mockito.when((Object)newDataType.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)newDataType.create(reference, CreationType.ABOVE)).thenReturn(updatedDataTypes);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("tDataType.name")).thenReturn(Optional.of(newListItem));
        Mockito.when((Object)this.dataTypeList.calculateParentHash(reference)).thenReturn((Object)"tDataType.id");
        ((DataTypeListItem)Mockito.doReturn((Object)"tDataType.name").when((Object)this.listItem)).getNewDataTypeHash(newDataType, "tDataType.id");
        ((DataTypeManager)Mockito.doReturn((Object)this.dataTypeManager).when((Object)this.dataTypeManager)).fromNew();
        ((DataTypeManager)Mockito.doReturn((Object)newDataType).when((Object)this.dataTypeManager)).get();
        ((DataTypeListItem)Mockito.doReturn((Object)reference).when((Object)this.listItem)).getDataType();
        this.listItem.insertFieldAbove();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).closeEditMode();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshItemsByUpdatedDataTypes(updatedDataTypes);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).refreshItemsCSSAndHTMLPosition();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).enableEditModeAndUpdateCallbacks("tDataType.name");
    }

    @Test
    public void testInsertFieldBelowWhenTheNewDataTypeIsTopLevel() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        List<DataType> updatedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        String referenceDataTypeHash = "tDataType.id";
        String newDataTypeHash = "tDataType.name";
        Mockito.when((Object)newDataType.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)newDataType.create(reference, CreationType.BELOW)).thenReturn(updatedDataTypes);
        Mockito.when((Object)this.dataTypeList.calculateParentHash(reference)).thenReturn((Object)"tDataType.id");
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeListItem)Mockito.doReturn((Object)"tDataType.name").when((Object)this.listItem)).getNewDataTypeHash(newDataType, "tDataType.id");
        ((DataTypeManager)Mockito.doReturn((Object)this.dataTypeManager).when((Object)this.dataTypeManager)).fromNew();
        ((DataTypeManager)Mockito.doReturn((Object)newDataType).when((Object)this.dataTypeManager)).get();
        ((DataTypeListItem)Mockito.doReturn((Object)reference).when((Object)this.listItem)).getDataType();
        this.listItem.insertFieldBelow();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).closeEditMode();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).enableEditModeAndUpdateCallbacks("tDataType.name");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).insertBelow(newDataType, reference);
    }

    @Test
    public void testInsertFieldBelowWhenTheNewDataTypeIsNotTopLevel() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        List<DataType> updatedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        String referenceDataTypeHash = "tDataType.id";
        String newDataTypeHash = "tDataType.name";
        Mockito.when((Object)newDataType.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)newDataType.create(reference, CreationType.BELOW)).thenReturn(updatedDataTypes);
        Mockito.when((Object)this.dataTypeList.calculateParentHash(reference)).thenReturn((Object)"tDataType.id");
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeListItem)Mockito.doReturn((Object)"tDataType.name").when((Object)this.listItem)).getNewDataTypeHash(newDataType, "tDataType.id");
        ((DataTypeManager)Mockito.doReturn((Object)this.dataTypeManager).when((Object)this.dataTypeManager)).fromNew();
        ((DataTypeManager)Mockito.doReturn((Object)newDataType).when((Object)this.dataTypeManager)).get();
        ((DataTypeListItem)Mockito.doReturn((Object)reference).when((Object)this.listItem)).getDataType();
        this.listItem.insertFieldBelow();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).closeEditMode();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).enableEditModeAndUpdateCallbacks("tDataType.name");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshItemsByUpdatedDataTypes(updatedDataTypes);
    }

    @Test
    public void testInsertNestedField() {
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        DataType reference = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem referenceItem = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        List<DataType> updatedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        String referenceDataTypeHash = "tDataType.id";
        String newDataTypeHash = "tDataType.id.value";
        Mockito.when((Object)newDataType.create(reference, CreationType.NESTED)).thenReturn(updatedDataTypes);
        Mockito.when((Object)this.dataTypeList.calculateHash(reference)).thenReturn((Object)"tDataType.id");
        Mockito.when((Object)this.dataTypeList.findItemByDataTypeHash("tDataType.id")).thenReturn(Optional.of(referenceItem));
        ((DataTypeListItem)Mockito.doReturn((Object)"tDataType.id.value").when((Object)this.listItem)).getNewDataTypeHash(newDataType, "tDataType.id");
        ((DataTypeManager)Mockito.doReturn((Object)this.dataTypeManager).when((Object)this.dataTypeManager)).fromNew();
        ((DataTypeManager)Mockito.doReturn((Object)newDataType).when((Object)this.dataTypeManager)).get();
        ((DataTypeListItem)Mockito.doReturn((Object)reference).when((Object)this.listItem)).getDataType();
        this.listItem.insertNestedField();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshItemsByUpdatedDataTypes(updatedDataTypes);
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).enableEditModeAndUpdateCallbacks("tDataType.id.value");
        ((DataTypeListItem)Mockito.verify((Object)referenceItem)).expand();
    }

    @Test
    public void testGetNewDataTypeHashWhenReferenceDataTypeHashIsNotEmpty() {
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        String newDataTypeName = "value";
        String referenceDataTypeHash = "tDataType.id";
        Mockito.when((Object)newDataType.getName()).thenReturn((Object)"value");
        String actualHash = this.listItem.getNewDataTypeHash(newDataType, "tDataType.id");
        String expectedHash = "tDataType.id.value";
        Assert.assertEquals((Object)"tDataType.id.value", (Object)actualHash);
    }

    @Test
    public void testGetNewDataTypeHashWhenReferenceDataTypeHashIsEmpty() {
        DataType newDataType = (DataType)Mockito.mock(DataType.class);
        String newDataTypeName = "value";
        String referenceDataTypeHash = "";
        Mockito.when((Object)newDataType.getName()).thenReturn((Object)"value");
        String actualHash = this.listItem.getNewDataTypeHash(newDataType, "");
        String expectedHash = "value";
        Assert.assertEquals((Object)"value", (Object)actualHash);
    }

    @Test
    public void testRefreshConstraintComponentWhenSelectedTypeIsStructure() {
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)this.structure);
        this.listItem.refreshConstraintComponent();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).disable();
    }

    @Test
    public void testRefreshConstraintComponentWhenSelectedTypeIsBoolean() {
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)BuiltInType.BOOLEAN.getName());
        this.listItem.refreshConstraintComponent();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).disable();
    }

    @Test
    public void testRefreshConstraintComponentWhenSelectedTypeIsContext() {
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)BuiltInType.CONTEXT.getName());
        this.listItem.refreshConstraintComponent();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).disable();
    }

    @Test
    public void testRefreshConstraintComponentWhenSelectedTypeIsAList() {
        Mockito.when((Object)this.dataTypeListComponent.getValue()).thenReturn((Object)true);
        this.listItem.refreshConstraintComponent();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).disable();
    }

    @Test
    public void testRefreshConstraintComponentWhenSelectedTypeIsNotBooleanNeitherStructure() {
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)BuiltInType.STRING.getName());
        this.listItem.refreshConstraintComponent();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).enable();
    }

    @Test
    public void testRefreshConstraintComponentWhenTypeIsIndirectTypeOfCanNotHaveConstraints() {
        ((DataTypeListItem)Mockito.doReturn((Object)true).when((Object)this.listItem)).isIndirectCanNotHaveConstraintType();
        this.listItem.refreshConstraintComponent();
        ((DataTypeConstraint)Mockito.verify((Object)this.dataTypeConstraintComponent)).disable();
    }

    @Test
    public void testIsIndirectTypeOfWhenIsBoolean() {
        String currentValue = "tIndirectBoolean";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tIndirectBoolean");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)BuiltInType.BOOLEAN.getName());
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"tIndirectBoolean");
        Mockito.when((Object)this.dataTypeSelectComponent.getCustomDataTypes()).thenReturn(customDataTypes);
        boolean actual = this.listItem.isIndirectCanNotHaveConstraintType();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsIndirectTypeOfWhenIsBooleanRecursive() {
        String indirectType = "tIndirectType";
        String tBoolean = "tIndirectBoolean";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1, dataType2);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tIndirectType");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"tIndirectBoolean");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"tIndirectBoolean");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)BuiltInType.BOOLEAN.getName());
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"tIndirectType");
        Mockito.when((Object)this.dataTypeSelectComponent.getCustomDataTypes()).thenReturn(customDataTypes);
        boolean actual = this.listItem.isIndirectCanNotHaveConstraintType();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsIndirectTypeOfWhenIsStructureRecursive() {
        String indirectType = "tIndirectType";
        String tIndirectStructure = "tIndirectStructure";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1, dataType2);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tIndirectType");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"tIndirectStructure");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"tIndirectStructure");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)this.structure);
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"tIndirectType");
        Mockito.when((Object)this.dataTypeSelectComponent.getCustomDataTypes()).thenReturn(customDataTypes);
        boolean actual = this.listItem.isIndirectCanNotHaveConstraintType();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsIndirectTypeOfWhenIsStructure() {
        String currentValue = "tIndirectStructure";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tIndirectStructure");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)this.structure);
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"tIndirectStructure");
        Mockito.when((Object)this.dataTypeSelectComponent.getCustomDataTypes()).thenReturn(customDataTypes);
        boolean actual = this.listItem.isIndirectCanNotHaveConstraintType();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsIndirectTypeOfWhenIsContextRecursive() {
        String indirectType = "tIndirectType";
        String tIndirectContext = "tIndirectContext";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1, dataType2);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tIndirectType");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"tIndirectContext");
        Mockito.when((Object)dataType2.getName()).thenReturn((Object)"tIndirectContext");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)BuiltInType.CONTEXT.getName());
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"tIndirectType");
        Mockito.when((Object)this.dataTypeSelectComponent.getCustomDataTypes()).thenReturn(customDataTypes);
        boolean actual = this.listItem.isIndirectCanNotHaveConstraintType();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsIndirectTypeOfWhenIsContext() {
        String currentValue = "tIndirectContext";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tIndirectContext");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)BuiltInType.CONTEXT.getName());
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"tIndirectContext");
        Mockito.when((Object)this.dataTypeSelectComponent.getCustomDataTypes()).thenReturn(customDataTypes);
        boolean actual = this.listItem.isIndirectCanNotHaveConstraintType();
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsIndirectTypeOfWhenIsOtherType() {
        String currentValue = "tIndirectOtherType";
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        List<DataType> customDataTypes = Arrays.asList(dataType1);
        Mockito.when((Object)dataType1.getName()).thenReturn((Object)"tIndirectOtherType");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)BuiltInType.STRING.getName());
        Mockito.when((Object)this.dataTypeSelectComponent.getValue()).thenReturn((Object)"tIndirectOtherType");
        Mockito.when((Object)this.dataTypeSelectComponent.getCustomDataTypes()).thenReturn(customDataTypes);
        boolean actual = this.listItem.isIndirectCanNotHaveConstraintType();
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testEnableEditModeAndUpdateCallbacks() {
        String dataTypeHash = "dataTypeHash";
        this.listItem.enableEditModeAndUpdateCallbacks("dataTypeHash");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).enableEditMode("dataTypeHash");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).fireOnDataTypeListItemUpdateCallback("dataTypeHash");
    }

    @Test
    public void testIsReadOnlyWhenItReturnsTrue() {
        ((DataTypeListItem)Mockito.doReturn((Object)this.dataType).when((Object)this.listItem)).getDataType();
        Mockito.when((Object)this.dataType.isReadOnly()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.listItem.isReadOnly());
    }

    @Test
    public void testIsReadOnlyWhenItReturnsFalse() {
        ((DataTypeListItem)Mockito.doReturn((Object)this.dataType).when((Object)this.listItem)).getDataType();
        Mockito.when((Object)this.dataType.isReadOnly()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.listItem.isReadOnly());
    }

    @Test
    public void testRefreshItemsCSSAndHTMLPosition() {
        this.listItem.refreshItemsCSSAndHTMLPosition();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).refreshItemsCSSAndHTMLPosition();
    }

    @Test
    public void testSetPositionX() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        Element element = (Element)Mockito.mock(Element.class);
        int positionX = 2;
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        this.listItem.setPositionX(element, 2.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionX(element, 2.0);
    }

    @Test
    public void testSetPositionY() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        Element element = (Element)Mockito.mock(Element.class);
        int positionY = 2;
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        this.listItem.setPositionY(element, 2.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY(element, 2.0);
    }

    @Test
    public void testGetPositionY() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        Element element = (Element)Mockito.mock(Element.class);
        Integer expectedPositionY = 2;
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        Mockito.when((Object)dndListComponent.getPositionY(element)).thenReturn((Object)expectedPositionY);
        Integer actualPositionY = this.listItem.getPositionY(element);
        Assert.assertEquals((Object)expectedPositionY, (Object)actualPositionY);
    }

    @Test
    public void testGetDragAndDropListElement() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        HTMLElement expectedHTMLElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        Mockito.when((Object)dndListComponent.getElement()).thenReturn((Object)expectedHTMLElement);
        HTMLElement actualHTMLElement = this.listItem.getDragAndDropListElement();
        Assert.assertEquals((Object)expectedHTMLElement, (Object)actualHTMLElement);
    }

    @Test
    public void testSetupIndentationLevel() {
        HTMLElement dragAndDropElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeListItem)Mockito.doReturn((Object)dragAndDropElement).when((Object)this.listItem)).getDragAndDropElement();
        ((DataTypeListItem)Mockito.doReturn((Object)5).when((Object)this.listItem)).getLevel();
        this.listItem.setupIndentationLevel();
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionX((Element)dragAndDropElement, 4.0);
    }

    @Test
    public void testAddDataTypeRowWhenDataTypeIsStructure() {
        ((DataTypeListItem)Mockito.doReturn((Object)true).when((Object)this.listItem)).isStructureType();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).insertNestedField();
        this.listItem.addDataTypeRow();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).insertNestedField();
    }

    @Test
    public void testAddDataTypeRowWhenDataTypeIsNotStructure() {
        ((DataTypeListItem)Mockito.doReturn((Object)false).when((Object)this.listItem)).isStructureType();
        ((DataTypeListItem)Mockito.doNothing().when((Object)this.listItem)).insertFieldBelow();
        this.listItem.addDataTypeRow();
        ((DataTypeListItem)Mockito.verify((Object)this.listItem)).insertFieldBelow();
    }

    @Test
    public void testHideTooltips() {
        HTMLElement listItems = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList tooltips = (NodeList)Mockito.spy((Object)new NodeList());
        Element element0 = (Element)Mockito.mock(Element.class);
        Element element1 = (Element)Mockito.mock(Element.class);
        ((NodeList)Mockito.doReturn((Object)element0).when((Object)tooltips)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)tooltips)).getAt(1);
        tooltips.length = 2;
        element0.parentNode = listItems;
        element1.parentNode = listItems;
        ((DataTypeList)Mockito.doReturn((Object)listItems).when((Object)this.dataTypeList)).getListItems();
        ((HTMLElement)Mockito.doReturn((Object)tooltips).when((Object)listItems)).querySelectorAll(".tooltip");
        this.listItem.hideTooltips();
        ((HTMLElement)Mockito.verify((Object)listItems)).removeChild((Node)element0);
        ((HTMLElement)Mockito.verify((Object)listItems)).removeChild((Node)element1);
    }

    @Test
    public void testHighlight() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.listItem.highlightLevel(dataType);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).highlightLevel(dataType);
    }

    private DataType makeDataType() {
        return new DataType(null);
    }
}

