/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.common;

import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.ListItemViewCssHelper;
import org.mockito.Mockito;

public class ListItemViewCssHelperTest {
    @Test
    public void testAsRightArrow() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ListItemViewCssHelper.asRightArrow((Element)element);
        ((DOMTokenList)Mockito.verify((Object)classList)).add(new String[]{"fa-chevron-right"});
        ((DOMTokenList)Mockito.verify((Object)classList)).remove(new String[]{"fa-chevron-down"});
    }

    @Test
    public void testAsDownArrow() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ListItemViewCssHelper.asDownArrow((Element)element);
        ((DOMTokenList)Mockito.verify((Object)classList)).add(new String[]{"fa-chevron-down"});
        ((DOMTokenList)Mockito.verify((Object)classList)).remove(new String[]{"fa-chevron-right"});
    }

    @Test
    public void testIsRightArrowWhenItIsRightArrow() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains("fa-chevron-right")).thenReturn((Object)true);
        Assert.assertTrue((boolean)ListItemViewCssHelper.isRightArrow((Element)element));
    }

    @Test
    public void testIsRightArrowWhenItIsNotRightArrow() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains("fa-chevron-right")).thenReturn((Object)false);
        Assert.assertFalse((boolean)ListItemViewCssHelper.isRightArrow((Element)element));
    }

    @Test
    public void testAsFocusedDataType() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ListItemViewCssHelper.asFocusedDataType((Element)element);
        ((DOMTokenList)Mockito.verify((Object)classList)).add(new String[]{"focused-data-type"});
    }

    @Test
    public void testAsNonFocusedDataType() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ListItemViewCssHelper.asNonFocusedDataType((Element)element);
        ((DOMTokenList)Mockito.verify((Object)classList)).remove(new String[]{"focused-data-type"});
    }

    @Test
    public void testIsFocusedDataTypeWhenItIsFocused() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains("focused-data-type")).thenReturn((Object)true);
        Assert.assertTrue((boolean)ListItemViewCssHelper.isFocusedDataType((Element)element));
    }

    @Test
    public void testIsFocusedDataTypeWhenItIsNotFocused() {
        DOMTokenList classList;
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains("focused-data-type")).thenReturn((Object)false);
        Assert.assertFalse((boolean)ListItemViewCssHelper.isFocusedDataType((Element)element));
    }
}

