/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateValueFormatter;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time.DateTimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time.DateTimeValueConverter;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValueFormatter;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DateTimeValueConverterTest {
    @Mock
    private DateValueFormatter dateValueFormatter;
    @Mock
    private TimeValueFormatter timeValueFormatter;
    private DateTimeValueConverter converter;

    @Before
    public void setup() {
        this.converter = (DateTimeValueConverter)Mockito.spy((Object)new DateTimeValueConverter(this.dateValueFormatter, this.timeValueFormatter));
    }

    @Test
    public void testToDMNStringValuesNotSet() {
        DateTimeValue value = new DateTimeValue();
        String actual = this.converter.toDMNString(value);
        Assert.assertEquals((Object)"", (Object)actual);
    }

    @Test
    public void testAppendPrefixAndSuffix() {
        String value = "value";
        String expected = "date and time(\"value\")";
        String actual = this.converter.appendPrefixAndSuffix("value");
        Assert.assertEquals((Object)"date and time(\"value\")", (Object)actual);
    }

    @Test
    public void removePrefixAndSuffix() {
        String expected = "value";
        String raw = "date and time(\"value\")";
        String actual = this.converter.removePrefixAndSuffix("date and time(\"value\")");
        Assert.assertEquals((Object)"value", (Object)actual);
    }

    @Test
    public void testGetTime() {
        String time = "19:45:00";
        String expected = "something19:45:00";
        DateTimeValue dateTimeValue = new DateTimeValue();
        dateTimeValue.setTime("19:45:00");
        Mockito.when((Object)this.timeValueFormatter.getTime("19:45:00")).thenReturn((Object)"something19:45:00");
        String actual = this.converter.getTime(dateTimeValue);
        Assert.assertEquals((Object)"something19:45:00", (Object)actual);
    }

    @Test
    public void testGetDate() {
        String date = "2019-06-02";
        String expected = "something2019-06-02";
        DateTimeValue dateTimeValue = new DateTimeValue();
        dateTimeValue.setDate("2019-06-02");
        Mockito.when((Object)this.dateValueFormatter.getDate("2019-06-02")).thenReturn((Object)"something2019-06-02");
        String actual = this.converter.getDate(dateTimeValue);
        Assert.assertEquals((Object)"something2019-06-02", (Object)actual);
    }

    @Test
    public void testExtractTime() {
        String time = "22:45:00-03:00";
        String input = "2019-06-02T22:45:00-03:00";
        String actual = this.converter.extractTime("2019-06-02T22:45:00-03:00");
        Assert.assertEquals((Object)"22:45:00-03:00", (Object)actual);
    }

    @Test
    public void testExtractDate() {
        String date = "2019-06-02";
        String input = "2019-06-02T22:45:00-03:00";
        String actual = this.converter.extractDate("2019-06-02T22:45:00-03:00");
        Assert.assertEquals((Object)"2019-06-02", (Object)actual);
    }

    @Test
    public void testFromDMNString() {
        String input = "some dmn string";
        String value = "some value without prefix and suffix";
        String date = "date";
        String time = "time";
        String expectedTime = "expectedTime";
        String expectedDate = "expectedDate";
        ((DateTimeValueConverter)Mockito.doReturn((Object)"some value without prefix and suffix").when((Object)this.converter)).removePrefixAndSuffix("some dmn string");
        ((DateTimeValueConverter)Mockito.doReturn((Object)"date").when((Object)this.converter)).extractDate("some value without prefix and suffix");
        ((DateTimeValueConverter)Mockito.doReturn((Object)"time").when((Object)this.converter)).extractTime("some value without prefix and suffix");
        Mockito.when((Object)this.dateValueFormatter.addPrefixAndSuffix("date")).thenReturn((Object)"expectedDate");
        Mockito.when((Object)this.timeValueFormatter.appendPrefixAndSuffix("time")).thenReturn((Object)"expectedTime");
        DateTimeValue actual = this.converter.fromDMNString("some dmn string");
        Assert.assertEquals((Object)"expectedDate", (Object)actual.getDate());
        Assert.assertEquals((Object)"expectedTime", (Object)actual.getTime());
    }

    @Test
    public void testToDisplay() {
        String rawString = "raw";
        String date = "date";
        String time = "time";
        String displayDate = "displayDate";
        String displayTime = "displayTime";
        String expected = "displayDate, displayTime";
        DateTimeValue dateTimeValue = new DateTimeValue();
        dateTimeValue.setDate("date");
        dateTimeValue.setTime("time");
        ((DateTimeValueConverter)Mockito.doReturn((Object)dateTimeValue).when((Object)this.converter)).fromDMNString("raw");
        Mockito.when((Object)this.dateValueFormatter.toDisplay("date")).thenReturn((Object)"displayDate");
        Mockito.when((Object)this.timeValueFormatter.toDisplay("time")).thenReturn((Object)"displayTime");
        String actual = this.converter.toDisplay("raw");
        Assert.assertEquals((Object)"displayDate, displayTime", (Object)actual);
    }
}

