/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeValueConverter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.views.pfly.widgets.MomentDuration;
import org.uberfire.client.views.pfly.widgets.MomentDurationObject;

@RunWith(value=GwtMockitoTestRunner.class)
public class DayTimeValueConverterTest {
    @Mock
    private TranslationService translationService;
    @Mock
    private MomentDuration momentDuration;
    @Captor
    private ArgumentCaptor<JavaScriptObject> javaScriptObject;
    private DayTimeValueConverter converter;

    @Before
    public void setup() {
        this.converter = (DayTimeValueConverter)Mockito.spy((Object)new DayTimeValueConverter(this.translationService));
        MomentDuration.moment = this.momentDuration;
    }

    @Test
    public void testToDMNString() {
        DayTimeValue value = new DayTimeValue(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(16));
        String momentISOString = "P2DT4H8M16S";
        String expected = "duration(\"P2DT4H8M16S\")";
        Mockito.when((Object)this.momentDuration.duration((JavaScriptObject)this.javaScriptObject.capture())).thenReturn((Object)this.momentDuration);
        Mockito.when((Object)this.momentDuration.toISOString()).thenReturn((Object)"P2DT4H8M16S");
        String actual = this.converter.toDMNString(value);
        Assert.assertEquals((Object)"duration(\"P2DT4H8M16S\")", (Object)actual);
    }

    @Test
    public void testFromDMNString() {
        String value = "P2DT4H8M16S";
        MomentDurationObject duration = (MomentDurationObject)Mockito.mock(MomentDurationObject.class);
        Integer expectedDays = 2;
        Integer expectedHours = 4;
        Integer expectedMinutes = 8;
        Integer expectedSeconds = 16;
        Mockito.when((Object)MomentDuration.moment.duration("P2DT4H8M16S")).thenReturn((Object)duration);
        Mockito.when((Object)duration.days()).thenReturn((Object)expectedDays);
        Mockito.when((Object)duration.hours()).thenReturn((Object)expectedHours);
        Mockito.when((Object)duration.minutes()).thenReturn((Object)expectedMinutes);
        Mockito.when((Object)duration.seconds()).thenReturn((Object)expectedSeconds);
        DayTimeValue actual = this.converter.fromDMNString("P2DT4H8M16S");
        Assert.assertEquals((Object)expectedDays, (Object)actual.getDays());
        Assert.assertEquals((Object)expectedHours, (Object)actual.getHours());
        Assert.assertEquals((Object)expectedMinutes, (Object)actual.getMinutes());
        Assert.assertEquals((Object)expectedSeconds, (Object)actual.getSeconds());
    }

    @Test
    public void testToDisplayValueWithSingularStrings() {
        String rawValue = "duration(\"P2DT4H8M16S\")";
        DayTimeValue value = new DayTimeValue(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1));
        ((DayTimeValueConverter)Mockito.doReturn((Object)value).when((Object)this.converter)).fromDMNString("duration(\"P2DT4H8M16S\")");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Day", new Object[0])).thenReturn((Object)"day");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Hour", new Object[0])).thenReturn((Object)"hour");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Minute", new Object[0])).thenReturn((Object)"minute");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Second", new Object[0])).thenReturn((Object)"second");
        String actual = this.converter.toDisplayValue("duration(\"P2DT4H8M16S\")");
        String expected = "1 day, 1 hour, 1 minute, 1 second";
        Assert.assertEquals((Object)"1 day, 1 hour, 1 minute, 1 second", (Object)actual);
    }

    @Test
    public void testToDisplayValueWithPluralStrings() {
        String rawValue = "duration(\"P2DT4H8M16S\")";
        DayTimeValue value = new DayTimeValue(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(16));
        ((DayTimeValueConverter)Mockito.doReturn((Object)value).when((Object)this.converter)).fromDMNString("duration(\"P2DT4H8M16S\")");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Days", new Object[0])).thenReturn((Object)"days");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Hours", new Object[0])).thenReturn((Object)"hours");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Minutes", new Object[0])).thenReturn((Object)"minutes");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Seconds", new Object[0])).thenReturn((Object)"seconds");
        String actual = this.converter.toDisplayValue("duration(\"P2DT4H8M16S\")");
        String expected = "2 days, 4 hours, 8 minutes, 16 seconds";
        Assert.assertEquals((Object)"2 days, 4 hours, 8 minutes, 16 seconds", (Object)actual);
    }

    @Test
    public void testToDisplayValueWithZeroHour() {
        String rawValue = "duration(\"P2DT0H8M16S\")";
        DayTimeValue value = new DayTimeValue(Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(8), Integer.valueOf(16));
        ((DayTimeValueConverter)Mockito.doReturn((Object)value).when((Object)this.converter)).fromDMNString("duration(\"P2DT0H8M16S\")");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Days", new Object[0])).thenReturn((Object)"days");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Hours", new Object[0])).thenReturn((Object)"hours");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Minutes", new Object[0])).thenReturn((Object)"minutes");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Seconds", new Object[0])).thenReturn((Object)"seconds");
        String actual = this.converter.toDisplayValue("duration(\"P2DT0H8M16S\")");
        String expected = "2 days, 8 minutes, 16 seconds";
        Assert.assertEquals((Object)"2 days, 8 minutes, 16 seconds", (Object)actual);
    }

    @Test
    public void testToDisplayValueWithZeroDays() {
        String rawValue = "duration(\"P0DT4H8M16S\")";
        DayTimeValue value = new DayTimeValue(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(16));
        ((DayTimeValueConverter)Mockito.doReturn((Object)value).when((Object)this.converter)).fromDMNString("duration(\"P0DT4H8M16S\")");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Days", new Object[0])).thenReturn((Object)"days");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Hours", new Object[0])).thenReturn((Object)"hours");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Minutes", new Object[0])).thenReturn((Object)"minutes");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Seconds", new Object[0])).thenReturn((Object)"seconds");
        String actual = this.converter.toDisplayValue("duration(\"P0DT4H8M16S\")");
        String expected = "4 hours, 8 minutes, 16 seconds";
        Assert.assertEquals((Object)"4 hours, 8 minutes, 16 seconds", (Object)actual);
    }

    @Test
    public void testToDisplayValueWithZeroMinutes() {
        String rawValue = "duration(\"P2DT4H0M16S\")";
        DayTimeValue value = new DayTimeValue(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(0), Integer.valueOf(16));
        ((DayTimeValueConverter)Mockito.doReturn((Object)value).when((Object)this.converter)).fromDMNString("duration(\"P2DT4H0M16S\")");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Days", new Object[0])).thenReturn((Object)"days");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Hours", new Object[0])).thenReturn((Object)"hours");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Minutes", new Object[0])).thenReturn((Object)"minutes");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Seconds", new Object[0])).thenReturn((Object)"seconds");
        String actual = this.converter.toDisplayValue("duration(\"P2DT4H0M16S\")");
        String expected = "2 days, 4 hours, 16 seconds";
        Assert.assertEquals((Object)"2 days, 4 hours, 16 seconds", (Object)actual);
    }

    @Test
    public void testToDisplayValueWithZeroSeconds() {
        String rawValue = "duration(\"P2DT4H8M0S\")";
        DayTimeValue value = new DayTimeValue(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(0));
        ((DayTimeValueConverter)Mockito.doReturn((Object)value).when((Object)this.converter)).fromDMNString("duration(\"P2DT4H8M0S\")");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Days", new Object[0])).thenReturn((Object)"days");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Hours", new Object[0])).thenReturn((Object)"hours");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Minutes", new Object[0])).thenReturn((Object)"minutes");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Seconds", new Object[0])).thenReturn((Object)"seconds");
        String actual = this.converter.toDisplayValue("duration(\"P2DT4H8M0S\")");
        String expected = "2 days, 4 hours, 8 minutes";
        Assert.assertEquals((Object)"2 days, 4 hours, 8 minutes", (Object)actual);
    }

    @Test
    public void testCombineSingularsPluralsEmpty() {
        String rawValue = "duration(\"P2DT0H1M0S\")";
        DayTimeValue value = new DayTimeValue(Integer.valueOf(2), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0));
        ((DayTimeValueConverter)Mockito.doReturn((Object)value).when((Object)this.converter)).fromDMNString("duration(\"P2DT0H1M0S\")");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Days", new Object[0])).thenReturn((Object)"days");
        Mockito.when((Object)this.translationService.format("DayTimeValueConverter.Minute", new Object[0])).thenReturn((Object)"minute");
        String actual = this.converter.toDisplayValue("duration(\"P2DT0H1M0S\")");
        String expected = "2 days, 1 minute";
        Assert.assertEquals((Object)"2 days, 1 minute", (Object)actual);
    }

    @Test
    public void testNumber() {
        JSONValue actual = this.converter.number(Integer.valueOf(1));
        JSONNumber expected = new JSONNumber(1.0);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNumberWithNullValues() {
        JSONValue actual = this.converter.number(null);
        JSONNull expected = JSONNull.getInstance();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

