/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ItemDefinitionStoreTest {
    private ItemDefinitionStore store;
    @Mock
    private ItemDefinition itemDefinition;
    private String uuid = "123";

    @Before
    public void setup() {
        this.store = new ItemDefinitionStore();
        this.store.index(this.uuid, this.itemDefinition);
    }

    @Test
    public void testGetWhenItReturnsNull() {
        Assert.assertNull((Object)this.store.get("456"));
    }

    @Test
    public void testGetWhenItDoesNotReturnNull() {
        Assert.assertNotNull((Object)this.store.get(this.uuid));
        Assert.assertEquals((Object)this.itemDefinition, (Object)this.store.get(this.uuid));
    }

    @Test
    public void testIndex() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String uuid = "789";
        this.store.index("789", itemDefinition);
        Assert.assertEquals((Object)itemDefinition, (Object)this.store.get("789"));
    }

    @Test
    public void testClear() {
        this.store.clear();
        Assert.assertEquals((long)0L, (long)this.store.size());
    }

    @Test
    public void testUnIndex() {
        this.store.unIndex(this.uuid);
        Assert.assertNull((Object)this.store.get(this.uuid));
    }
}

