/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchEngine;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSearchBarTest {
    @Mock
    private DataTypeSearchBar.View view;
    @Mock
    private DataTypeSearchEngine searchEngine;
    @Mock
    private DataTypeList dataTypeList;
    private DataTypeSearchBar searchBar;

    @Before
    public void setup() {
        this.searchBar = (DataTypeSearchBar)Mockito.spy((Object)new DataTypeSearchBar(this.view, this.searchEngine, this.dataTypeList));
    }

    @Test
    public void testSetup() {
        this.searchBar.setup();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).init((Object)this.searchBar);
    }

    @Test
    public void testGetElement() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.searchBar.getElement();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testRefresh() {
        String currentSearch = "currentSearch";
        ((DataTypeSearchBar)Mockito.doReturn((Object)"currentSearch").when((Object)this.searchBar)).getCurrentSearch();
        this.searchBar.refresh();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).search("currentSearch");
    }

    @Test
    public void testReset() {
        this.searchBar.reset();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch("");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).resetSearchBar();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).restoreDataTypeListPositions();
    }

    @Test
    public void testSearchWhenKeywordIsNotEmpty() {
        String keyword = "keyword";
        List<DataType> results = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        Mockito.when((Object)this.searchEngine.search("keyword")).thenReturn(results);
        this.searchBar.search("keyword");
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).storeDataTypeListPositions();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch("keyword");
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).showSearchResults(results);
    }

    @Test
    public void testSearchWhenTheSearchResultIsEmpty() {
        String keyword = "keyword";
        List results = Collections.emptyList();
        Mockito.when((Object)this.searchEngine.search("keyword")).thenReturn(results);
        this.searchBar.search("keyword");
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).storeDataTypeListPositions();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showNoDataTypesFound();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch("keyword");
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).showSearchResults(results);
    }

    @Test
    public void testSearchWhenKeywordIsEmpty() {
        String keyword = "";
        Mockito.when((Object)this.searchEngine.search("")).thenReturn(Collections.emptyList());
        this.searchBar.search("");
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).storeDataTypeListPositions();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showNoDataTypesFound();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar, (VerificationMode)Mockito.times((int)2))).setCurrentSearch("");
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).resetSearchBar();
    }

    @Test
    public void testSearchWhenKeywordIsNull() {
        String keyword = null;
        Mockito.when((Object)this.searchEngine.search(keyword)).thenReturn(Collections.emptyList());
        this.searchBar.search(keyword);
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).storeDataTypeListPositions();
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showNoDataTypesFound();
        ((DataTypeSearchBar)Mockito.verify((Object)this.searchBar)).setCurrentSearch(keyword);
        ((DataTypeList)Mockito.verify((Object)this.dataTypeList)).showListItems();
        ((DataTypeSearchBar.View)Mockito.verify((Object)this.view)).resetSearchBar();
    }

    @Test
    public void testIsEnabledWhenItReturnsTrue() {
        ((DataTypeSearchBar)Mockito.doReturn((Object)"something").when((Object)this.searchBar)).getCurrentSearch();
        Assert.assertTrue((boolean)this.searchBar.isEnabled());
    }

    @Test
    public void testIsEnabledWhenItReturnsFalse() {
        ((DataTypeSearchBar)Mockito.doReturn((Object)"").when((Object)this.searchBar)).getCurrentSearch();
        Assert.assertFalse((boolean)this.searchBar.isEnabled());
    }

    @Test
    public void testGetResultsContainer() {
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.dataTypeList.getElement()).thenReturn((Object)expectedElement);
        HTMLElement actualElement = this.searchBar.getResultsContainer();
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testRestoreDataTypeListPositionsWhenSearchBarHasDataTypeListPositionsStored() {
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem list0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem list1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        List<DataTypeListItem> items = Arrays.asList(list0, list1);
        String uuid0 = "0000-0000-0000-0000";
        String uuid1 = "1111-1111-1111-1111";
        Integer positionY0 = 2;
        Integer positionY1 = -1;
        Map store = (Map)Mockito.spy((Object)new Maps.Builder().put((Object)"0000-0000-0000-0000", (Object)positionY0).put((Object)"1111-1111-1111-1111", (Object)positionY1).build());
        Map collapsedStore = (Map)Mockito.spy((Object)new Maps.Builder().put((Object)"0000-0000-0000-0000", (Object)false).put((Object)"1111-1111-1111-1111", (Object)true).build());
        element0.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)dndListComponent.getPositionY((Element)element0)).thenReturn((Object)positionY0);
        Mockito.when((Object)dndListComponent.getPositionY((Element)element1)).thenReturn((Object)positionY1);
        Mockito.when((Object)list0.getDragAndDropElement()).thenReturn((Object)element0);
        Mockito.when((Object)list1.getDragAndDropElement()).thenReturn((Object)element1);
        Mockito.when((Object)list0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)list1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"0000-0000-0000-0000");
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"1111-1111-1111-1111");
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(items);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeSearchBar)Mockito.doReturn((Object)store).when((Object)this.searchBar)).getDataTypeListPositionsStore();
        ((DataTypeSearchBar)Mockito.doReturn((Object)collapsedStore).when((Object)this.searchBar)).getDataTypeListCollapsedStatusStore();
        this.searchBar.restoreDataTypeListPositions();
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element0, (double)positionY0.intValue());
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element1, (double)positionY1.intValue());
        ((DOMTokenList)Mockito.verify((Object)element0.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).add(new String[]{"hidden"});
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).refreshItemsPosition();
        ((DataTypeListItem)Mockito.verify((Object)list0, (VerificationMode)Mockito.never())).collapse();
        ((DataTypeListItem)Mockito.verify((Object)list1)).collapse();
        ((Map)Mockito.verify((Object)store)).clear();
        ((Map)Mockito.verify((Object)collapsedStore)).clear();
    }

    @Test
    public void testRestoreDataTypeListPositionsWhenSearchBarDoesNotHaveDataTypeListPositionsStored() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        Map store = (Map)Mockito.spy(new HashMap());
        Map collapsedStore = (Map)Mockito.spy(new HashMap());
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeSearchBar)Mockito.doReturn((Object)store).when((Object)this.searchBar)).getDataTypeListPositionsStore();
        ((DataTypeSearchBar)Mockito.doReturn((Object)collapsedStore).when((Object)this.searchBar)).getDataTypeListCollapsedStatusStore();
        this.searchBar.restoreDataTypeListPositions();
        ((DNDListComponent)Mockito.verify((Object)dndListComponent, (VerificationMode)Mockito.never())).setPositionY((Element)Matchers.any(), Matchers.anyDouble());
        ((DNDListComponent)Mockito.verify((Object)dndListComponent, (VerificationMode)Mockito.never())).refreshItemsPosition();
        ((Map)Mockito.verify((Object)store, (VerificationMode)Mockito.never())).clear();
        ((Map)Mockito.verify((Object)collapsedStore, (VerificationMode)Mockito.never())).clear();
    }

    @Test
    public void testStoreDataTypeListPositionsWhenSearchBarDoesNotHaveDataTypeListPositionsStored() {
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem list0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem list1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        List<DataTypeListItem> items = Arrays.asList(list0, list1);
        String uuid0 = "0000-0000-0000-0000";
        String uuid1 = "1111-1111-1111-1111";
        Integer positionY0 = 2;
        Integer positionY1 = 4;
        HashMap store = new HashMap();
        Mockito.when((Object)dndListComponent.getPositionY((Element)element0)).thenReturn((Object)positionY0);
        Mockito.when((Object)dndListComponent.getPositionY((Element)element1)).thenReturn((Object)positionY1);
        Mockito.when((Object)list0.getDragAndDropElement()).thenReturn((Object)element0);
        Mockito.when((Object)list1.getDragAndDropElement()).thenReturn((Object)element1);
        Mockito.when((Object)list0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)list1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"0000-0000-0000-0000");
        Mockito.when((Object)dataType1.getUUID()).thenReturn((Object)"1111-1111-1111-1111");
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(items);
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeSearchBar)Mockito.doReturn(store).when((Object)this.searchBar)).getDataTypeListPositionsStore();
        this.searchBar.storeDataTypeListPositions();
        Assert.assertEquals((long)2L, (long)store.size());
        Assert.assertEquals((Object)positionY0, store.get("0000-0000-0000-0000"));
        Assert.assertEquals((Object)positionY1, store.get("1111-1111-1111-1111"));
    }

    @Test
    public void testStoreDataTypeListPositionsWhenSearchBarHasDataTypeListPositionsStored() {
        String uuid0 = "0000-0000-0000-0000";
        String uuid1 = "1111-1111-1111-1111";
        Integer positionY0 = 2;
        Integer positionY1 = 4;
        Map store = (Map)Mockito.spy((Object)new Maps.Builder().put((Object)"0000-0000-0000-0000", (Object)positionY0).put((Object)"1111-1111-1111-1111", (Object)positionY1).build());
        ((DataTypeSearchBar)Mockito.doReturn((Object)store).when((Object)this.searchBar)).getDataTypeListPositionsStore();
        this.searchBar.storeDataTypeListPositions();
        ((Map)Mockito.verify((Object)store, (VerificationMode)Mockito.never())).put(Matchers.anyString(), Matchers.any());
    }

    @Test
    public void testGetDataTypeListItemsSortedByPositionY() {
        DataTypeListItem list0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem list1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        Integer positionY0 = 3;
        Integer positionY1 = 2;
        HashMap store = new HashMap();
        Mockito.when((Object)dndListComponent.getPositionY((Element)element0)).thenReturn((Object)positionY0);
        Mockito.when((Object)dndListComponent.getPositionY((Element)element1)).thenReturn((Object)positionY1);
        Mockito.when((Object)list0.getDragAndDropElement()).thenReturn((Object)element0);
        Mockito.when((Object)list1.getDragAndDropElement()).thenReturn((Object)element1);
        Mockito.when((Object)this.dataTypeList.getItems()).thenReturn(Arrays.asList(list0, list1));
        Mockito.when((Object)this.dataTypeList.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeSearchBar)Mockito.doReturn(store).when((Object)this.searchBar)).getDataTypeListPositionsStore();
        List actualListItems = this.searchBar.getDataTypeListItemsSortedByPositionY();
        List<DataTypeListItem> expectedListItems = Arrays.asList(list1, list0);
        Assert.assertEquals(expectedListItems, (Object)actualListItems);
    }
}

