/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.marshaller.common.IdUtils;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmndi12.JSIDMNDiagram;
import org.mockito.Mockito;

public class IdUtilsTest {
    @Test
    public void testGetPrefixedId() {
        Assert.assertEquals((Object)"1111#2222", (Object)IdUtils.getPrefixedId((String)"1111", (String)"2222"));
        Assert.assertEquals((Object)"2222", (Object)IdUtils.getPrefixedId((String)"", (String)"2222"));
        Assert.assertEquals((Object)"2222", (Object)IdUtils.getPrefixedId(null, (String)"2222"));
    }

    @Test
    public void testGetRawId() {
        Assert.assertEquals((Object)"2222", (Object)IdUtils.getRawId((String)"1111#2222"));
        Assert.assertEquals((Object)"2222", (Object)IdUtils.getRawId((String)"#2222"));
        Assert.assertEquals((Object)"2222", (Object)IdUtils.getRawId((String)"2222"));
    }

    @Test
    public void testUniqueId() {
        Assert.assertNotEquals((Object)IdUtils.uniqueId(), (Object)IdUtils.uniqueId());
    }

    @Test
    public void testGetComposedId() {
        Assert.assertEquals((Object)"dmnshape-page-1-_1111-2222", (Object)IdUtils.getComposedId((String[])new String[]{"dmnshape", "page 1", "_1111-2222"}));
        Assert.assertEquals((Object)"dmnshape-page-1-_1111-2222", (Object)IdUtils.getComposedId((String[])new String[]{"dmnshape", "page   1   ", "_1111-2222"}));
        Assert.assertEquals((Object)"dmnshape-_1111-2222", (Object)IdUtils.getComposedId((String[])new String[]{"dmnshape", "", "_1111-2222"}));
        Assert.assertEquals((Object)"dmnshape-_1111-2222", (Object)IdUtils.getComposedId((String[])new String[]{"dmnshape", "_1111-2222"}));
    }

    @Test
    public void testGetShapeId() {
        JSIDMNDiagram diagram = (JSIDMNDiagram)Mockito.mock(JSIDMNDiagram.class);
        Mockito.when((Object)diagram.getName()).thenReturn((Object)"DRG");
        Assert.assertEquals((Object)"dmnshape-drg-_1111-2222", (Object)IdUtils.getShapeId((JSIDMNDiagram)diagram, this.list(new String[0]), (String)"_1111-2222"));
        Assert.assertEquals((Object)"dmnshape-drg-2-_1111-2222", (Object)IdUtils.getShapeId((JSIDMNDiagram)diagram, this.list("dmnshape-drg-_1111-2222"), (String)"_1111-2222"));
        Assert.assertEquals((Object)"dmnshape-drg-3-_1111-2222", (Object)IdUtils.getShapeId((JSIDMNDiagram)diagram, this.list("dmnshape-drg-_1111-2222", "dmnshape-drg-2-_1111-2222"), (String)"_1111-2222"));
    }

    @Test
    public void testGetEdgeId() {
        JSIDMNDiagram diagram = (JSIDMNDiagram)Mockito.mock(JSIDMNDiagram.class);
        Mockito.when((Object)diagram.getName()).thenReturn((Object)"DRG");
        Assert.assertEquals((Object)"dmnedge-drg-_1111-2222", (Object)IdUtils.getEdgeId((JSIDMNDiagram)diagram, this.list(new String[0]), (String)"_1111-2222"));
    }

    @Test
    public void testGetShapeIdWhenDiagramNameIsNull() {
        JSIDMNDiagram diagram = (JSIDMNDiagram)Mockito.mock(JSIDMNDiagram.class);
        Assert.assertEquals((Object)"dmnshape-_1111-2222", (Object)IdUtils.getShapeId((JSIDMNDiagram)diagram, this.list(new String[0]), (String)"_1111-2222"));
    }

    @Test
    public void testGetEdgeIdWhenDiagramNameIsNull() {
        JSIDMNDiagram diagram = (JSIDMNDiagram)Mockito.mock(JSIDMNDiagram.class);
        Assert.assertEquals((Object)"dmnedge-_1111-2222", (Object)IdUtils.getEdgeId((JSIDMNDiagram)diagram, this.list(new String[0]), (String)"_1111-2222"));
    }

    private List<String> list(String ... items) {
        return new ArrayList<String>(Arrays.asList(items));
    }
}

