/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.included;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.IsInformationItem;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNIncludedNodeFactory;
import org.mockito.MockSettings;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNIncludedNodeFactoryTest {
    @Test
    public void testDrgElementWithNamespace() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{HasVariable.class}));
        IncludedModel includedModel = (IncludedModel)Mockito.mock(IncludedModel.class);
        DMNIncludedNodeFactory factory = (DMNIncludedNodeFactory)Mockito.mock(DMNIncludedNodeFactory.class);
        Id elementId = (Id)Mockito.mock(Id.class);
        String theId = "theId";
        String theName = "theName";
        String tType = "tType";
        String namespaceUri = "namespaceUri";
        String prefix = "prefix";
        String modelName = "Model Name";
        Name elementName = (Name)Mockito.mock(Name.class);
        IsInformationItem informationItem = (IsInformationItem)Mockito.mock(IsInformationItem.class);
        QName qName = (QName)Mockito.mock(QName.class);
        Name createdName = (Name)Mockito.mock(Name.class);
        QName typeRef = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)includedModel.getModelName()).thenReturn((Object)"Model Name");
        Mockito.when((Object)elementId.getValue()).thenReturn((Object)"theId");
        Mockito.when((Object)elementName.getValue()).thenReturn((Object)"theName");
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)elementName);
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)elementId);
        Mockito.when((Object)((HasVariable)drgElement).getVariable()).thenReturn((Object)informationItem);
        Mockito.when((Object)qName.getLocalPart()).thenReturn((Object)"tType");
        Mockito.when((Object)informationItem.getTypeRef()).thenReturn((Object)qName);
        Mockito.when((Object)qName.getPrefix()).thenReturn((Object)"prefix");
        Mockito.when((Object)qName.getNamespaceURI()).thenReturn((Object)"namespaceUri");
        Mockito.when((Object)factory.createName(drgElement, "Model Name")).thenReturn((Object)createdName);
        Mockito.when((Object)factory.createTypeRef("Model Name", qName)).thenReturn((Object)typeRef);
        ((DMNIncludedNodeFactory)Mockito.doCallRealMethod().when((Object)factory)).drgElementWithNamespace(drgElement, includedModel);
        factory.drgElementWithNamespace(drgElement, includedModel);
        ((DRGElement)Mockito.verify((Object)drgElement)).setName(createdName);
        ((DRGElement)Mockito.verify((Object)drgElement)).setAllowOnlyVisualChange(true);
        ((DMNIncludedNodeFactory)Mockito.verify((Object)factory)).setVariable((HasVariable)drgElement, informationItem, typeRef);
    }

    @Test
    public void testMakeDMNIncludedModel() {
        DMNIncludedNodeFactory factory = (DMNIncludedNodeFactory)Mockito.mock(DMNIncludedNodeFactory.class);
        String path = "path";
        IncludedModel includedModel = (IncludedModel)Mockito.mock(IncludedModel.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement elementWithNamespace = (DRGElement)Mockito.mock(DRGElement.class);
        ((DMNIncludedNodeFactory)Mockito.doCallRealMethod().when((Object)factory)).makeDMNIncludeNode("path", includedModel, drgElement);
        Mockito.when((Object)factory.drgElementWithNamespace(drgElement, includedModel)).thenReturn((Object)elementWithNamespace);
        DMNIncludedNode includedNode = factory.makeDMNIncludeNode("path", includedModel, drgElement);
        ((DMNIncludedNodeFactory)Mockito.verify((Object)factory)).drgElementWithNamespace(drgElement, includedModel);
        Assert.assertEquals((Object)"path", (Object)includedNode.getFileName());
        Assert.assertEquals((Object)elementWithNamespace, (Object)includedNode.getDrgElement());
    }

    @Test
    public void testCreateTypeRef() {
        DMNIncludedNodeFactory factory = new DMNIncludedNodeFactory();
        QName qname = (QName)Mockito.mock(QName.class);
        String modelName = "modelName";
        String namespaceUri = "uri";
        String prefix = "prefix";
        String localPart = "localPart";
        Mockito.when((Object)qname.getNamespaceURI()).thenReturn((Object)"uri");
        Mockito.when((Object)qname.getPrefix()).thenReturn((Object)"prefix");
        Mockito.when((Object)qname.getLocalPart()).thenReturn((Object)"localPart");
        QName typeRef = factory.createTypeRef("modelName", qname);
        Assert.assertEquals((Object)"uri", (Object)typeRef.getNamespaceURI());
        Assert.assertEquals((Object)"modelName.localPart", (Object)typeRef.getLocalPart());
        Assert.assertEquals((Object)"prefix", (Object)typeRef.getPrefix());
    }

    @Test
    public void testCreateName() {
        DMNIncludedNodeFactory factory = new DMNIncludedNodeFactory();
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        String theName = "the name";
        Name name = new Name("the name");
        String modelName = "modelName";
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)name);
        Name createdName = factory.createName(drgElement, "modelName");
        Assert.assertEquals((Object)"modelName.the name", (Object)createdName.getValue());
    }
}

