/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.marshaller.marshall;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.client.marshaller.marshall.DMNMarshaller;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBusinessKnowledgeModel;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeSource;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNMarshallerTest {
    @Test
    public void testMergeOrAddNodeToDefinitions() {
        JSITDecision existingNode1 = this.makeDecision("id1");
        JSITDecision node1 = this.makeDecision("id1");
        JSITBusinessKnowledgeModel node2 = this.makeBusinessKnowledgeModel("id2");
        JSITKnowledgeSource node3 = this.makeKnowledgeSource("id3");
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        JSITDefinitions definitions = (JSITDefinitions)Mockito.spy((Object)new JSITDefinitions());
        ArrayList<JSITDecision> definitionsDRGElements = new ArrayList<JSITDecision>(Collections.singletonList(existingNode1));
        ((DMNMarshaller)Mockito.doReturn((Object)node1).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)Matchers.eq((Object)node1), (DMNMarshaller.JSINodeLocalPartName)Matchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)node2).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)Matchers.eq((Object)node2), (DMNMarshaller.JSINodeLocalPartName)Matchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)node3).when((Object)dmnMarshaller)).getWrappedJSITDRGElement((JSITDRGElement)Matchers.eq((Object)node3), (DMNMarshaller.JSINodeLocalPartName)Matchers.any());
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfDecision((JSITDRGElement)Matchers.eq((Object)node1));
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfBusinessKnowledgeModel((JSITDRGElement)Matchers.eq((Object)node2));
        ((DMNMarshaller)Mockito.doReturn((Object)true).when((Object)dmnMarshaller)).instanceOfKnowledgeSource((JSITDRGElement)Matchers.eq((Object)node3));
        ((JSITDefinitions)Mockito.doReturn(definitionsDRGElements).when((Object)definitions)).getDrgElement();
        ArrayList<JSITAuthorityRequirement> authorityRequirement = new ArrayList<JSITAuthorityRequirement>(Collections.singletonList(new JSITAuthorityRequirement()));
        ArrayList<JSITInformationRequirement> informationRequirement = new ArrayList<JSITInformationRequirement>(Collections.singletonList(new JSITInformationRequirement()));
        ArrayList<JSITKnowledgeRequirement> knowledgeRequirement = new ArrayList<JSITKnowledgeRequirement>(Collections.singletonList(new JSITKnowledgeRequirement()));
        ((JSITDecision)Mockito.doReturn(authorityRequirement).when((Object)node1)).getAuthorityRequirement();
        ((JSITDecision)Mockito.doReturn(informationRequirement).when((Object)node1)).getInformationRequirement();
        ((JSITDecision)Mockito.doReturn(knowledgeRequirement).when((Object)node1)).getKnowledgeRequirement();
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node1, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node2, definitions);
        dmnMarshaller.mergeOrAddNodeToDefinitions((JSITDRGElement)node3, definitions);
        ((JSITDefinitions)Mockito.verify((Object)definitions, (VerificationMode)Mockito.never())).addDrgElement((JSITDRGElement)node1);
        ((JSITDefinitions)Mockito.verify((Object)definitions)).addDrgElement((JSITDRGElement)node2);
        ((JSITDefinitions)Mockito.verify((Object)definitions)).addDrgElement((JSITDRGElement)node3);
        ((JSITDecision)Mockito.verify((Object)existingNode1)).addAllAuthorityRequirement(authorityRequirement.toArray(new JSITAuthorityRequirement[0]));
        ((JSITDecision)Mockito.verify((Object)existingNode1)).addAllInformationRequirement(informationRequirement.toArray(new JSITInformationRequirement[0]));
        ((JSITDecision)Mockito.verify((Object)existingNode1)).addAllKnowledgeRequirement(knowledgeRequirement.toArray(new JSITKnowledgeRequirement[0]));
    }

    @Test
    public void testGetExistingNode() {
        JSITDecision nodeDRGElement = this.makeDecision("id1");
        JSITDecision definitionsDRGElement1 = this.makeDecision("id1");
        JSITDecision definitionsDRGElement2 = this.makeDecision("id2");
        JSITDecision definitionsDRGElement3 = this.makeDecision("id3");
        DMNMarshaller dmnMarshaller = new DMNMarshaller();
        JSITDefinitions definitions = (JSITDefinitions)Mockito.spy((Object)new JSITDefinitions());
        ArrayList<JSITDecision> definitionsDRGElements = new ArrayList<JSITDecision>(Arrays.asList(definitionsDRGElement1, definitionsDRGElement2, definitionsDRGElement3));
        ((JSITDefinitions)Mockito.doReturn(definitionsDRGElements).when((Object)definitions)).getDrgElement();
        Optional existingNode = dmnMarshaller.getExistingNode(definitions, (JSITDRGElement)nodeDRGElement);
        Assert.assertTrue((boolean)existingNode.isPresent());
        Assert.assertEquals((Object)definitionsDRGElement1, existingNode.get());
    }

    @Test
    public void testWithIncludedModelsWhenNodeParentIsDMNDiagram() {
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        Node node = (Node)Mockito.mock(Node.class);
        Definition nodeDefinition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Definitions definitionsStunnerPojo = (Definitions)Mockito.mock(Definitions.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        ArrayList<Import> diagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        DMNDiagram nodeDiagram = (DMNDiagram)Mockito.mock(DMNDiagram.class);
        Definitions nodeDiagramDefinitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList nodeDiagramImports = new ArrayList();
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeDefinition);
        Mockito.when((Object)nodeDefinition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)definitionsStunnerPojo.getImport()).thenReturn(diagramImports);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)nodeDiagram);
        Mockito.when((Object)nodeDiagram.getDefinitions()).thenReturn((Object)nodeDiagramDefinitions);
        Mockito.when((Object)nodeDiagramDefinitions.getImport()).thenReturn(nodeDiagramImports);
        dmnMarshaller.withIncludedModels(node, definitionsStunnerPojo);
        Assert.assertEquals((long)2L, (long)nodeDiagramImports.size());
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import1));
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import2));
    }

    @Test
    public void testWithIncludedModelsWhenNodeAlreadyHasImports() {
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        Node node = (Node)Mockito.mock(Node.class);
        Definition nodeDefinition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Definitions definitionsStunnerPojo = (Definitions)Mockito.mock(Definitions.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        ArrayList<Import> diagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        DMNDiagram nodeDiagram = (DMNDiagram)Mockito.mock(DMNDiagram.class);
        Definitions nodeDiagramDefinitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList<Import> nodeDiagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeDefinition);
        Mockito.when((Object)nodeDefinition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)definitionsStunnerPojo.getImport()).thenReturn(diagramImports);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)nodeDiagram);
        Mockito.when((Object)nodeDiagram.getDefinitions()).thenReturn((Object)nodeDiagramDefinitions);
        Mockito.when((Object)nodeDiagramDefinitions.getImport()).thenReturn(nodeDiagramImports);
        dmnMarshaller.withIncludedModels(node, definitionsStunnerPojo);
        Assert.assertEquals((long)2L, (long)nodeDiagramImports.size());
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import1));
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import2));
    }

    @Test
    public void testWithIncludedModelsWhenNodeParentIsDefinitions() {
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)new DMNMarshaller());
        Node node = (Node)Mockito.mock(Node.class);
        Definition nodeDefinition = (Definition)Mockito.mock(Definition.class);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Definitions definitionsStunnerPojo = (Definitions)Mockito.mock(Definitions.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        ArrayList<Import> diagramImports = new ArrayList<Import>(Arrays.asList(import1, import2));
        Definitions nodeDiagramDefinitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList nodeDiagramImports = new ArrayList();
        Mockito.when((Object)node.getContent()).thenReturn((Object)nodeDefinition);
        Mockito.when((Object)nodeDefinition.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)definitionsStunnerPojo.getImport()).thenReturn(diagramImports);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)nodeDiagramDefinitions);
        Mockito.when((Object)nodeDiagramDefinitions.getImport()).thenReturn(nodeDiagramImports);
        dmnMarshaller.withIncludedModels(node, definitionsStunnerPojo);
        Assert.assertEquals((long)2L, (long)nodeDiagramImports.size());
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import1));
        Assert.assertTrue((boolean)nodeDiagramImports.contains(import2));
    }

    private JSITDecision makeDecision(String id) {
        JSITDecision decision = (JSITDecision)Mockito.spy((Object)new JSITDecision());
        ((JSITDecision)Mockito.doReturn((Object)id).when((Object)decision)).getId();
        return decision;
    }

    private JSITBusinessKnowledgeModel makeBusinessKnowledgeModel(String id) {
        JSITBusinessKnowledgeModel businessKnowledgeModel = (JSITBusinessKnowledgeModel)Mockito.spy((Object)new JSITBusinessKnowledgeModel());
        ((JSITBusinessKnowledgeModel)Mockito.doReturn((Object)id).when((Object)businessKnowledgeModel)).getId();
        return businessKnowledgeModel;
    }

    private JSITKnowledgeSource makeKnowledgeSource(String id) {
        JSITKnowledgeSource knowledgeSource = (JSITKnowledgeSource)Mockito.spy((Object)new JSITKnowledgeSource());
        ((JSITKnowledgeSource)Mockito.doReturn((Object)id).when((Object)knowledgeSource)).getId();
        return knowledgeSource;
    }
}

