/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.QNameFieldType;
import org.kie.workbench.common.dmn.client.property.dmn.QNameFieldDefinition;
import org.kie.workbench.common.dmn.client.property.dmn.QNameFieldProvider;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class QNameFieldProviderTest {
    @Mock
    private TypeInfo typeInfo;
    private QNameFieldProvider provider;

    @Before
    public void setup() {
        this.provider = new QNameFieldProvider();
    }

    @Test
    public void testGetPriority() {
        Assert.assertEquals((long)975L, (long)this.provider.getPriority());
    }

    @Test
    public void testDoRegisterFields() {
        this.provider.doRegisterFields();
        Assert.assertTrue((boolean)this.provider.supports(QName.class));
        Assert.assertFalse((boolean)this.provider.supports(String.class));
    }

    @Test
    public void testCreateFieldByType() {
        QNameFieldDefinition definition1 = this.provider.createFieldByType(this.typeInfo);
        QNameFieldDefinition definition2 = this.provider.createFieldByType(this.typeInfo);
        Assert.assertNotEquals((Object)definition1, (Object)definition2);
    }

    @Test
    public void testGetFieldType() {
        Assert.assertEquals(QNameFieldType.class, (Object)this.provider.getFieldType());
    }

    @Test
    public void testGetFieldTypeName() {
        Assert.assertEquals((Object)QNameFieldDefinition.FIELD_TYPE.getTypeName(), (Object)this.provider.getFieldTypeName());
    }

    @Test
    public void testGetDefaultField() {
        QNameFieldDefinition definition1 = this.provider.getDefaultField();
        QNameFieldDefinition definition2 = this.provider.getDefaultField();
        Assert.assertNotEquals((Object)definition1, (Object)definition2);
    }
}

