/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNEditorSession;
import org.kie.workbench.common.dmn.client.session.NodeTextSetter;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class NodeTextSetterTest {
    @Mock
    private TextPropertyProviderFactory textPropertyProviderFactory;
    @Mock
    private EventSourceMock<CanvasElementUpdatedEvent> canvasElementUpdatedEvent;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Captor
    private ArgumentCaptor<CanvasElementUpdatedEvent> canvasElementUpdatedEventArgumentCaptor;
    private NodeTextSetter nodeTextSetter;

    @Before
    public void setup() {
        this.nodeTextSetter = (NodeTextSetter)Mockito.spy((Object)new NodeTextSetter(this.textPropertyProviderFactory, this.canvasElementUpdatedEvent, this.dmnGraphUtils));
    }

    @Test
    public void testSetText() {
        Node node = (Node)Mockito.mock(Node.class);
        String oldName = "old name";
        String newName = "new name";
        DMNEditorSession dmnEditorSession = (DMNEditorSession)Mockito.mock(DMNEditorSession.class);
        Optional<DMNEditorSession> editorSession = Optional.of(dmnEditorSession);
        TextPropertyProvider textPropertyProvider = (TextPropertyProvider)Mockito.mock(TextPropertyProvider.class);
        CanvasCommandManager commandManager = (CanvasCommandManager)Mockito.mock(CanvasCommandManager.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Optional<AbstractCanvasHandler> optionalCanvasHanlder = Optional.of(canvasHandler);
        Mockito.when((Object)dmnEditorSession.getCommandManager()).thenReturn((Object)commandManager);
        Mockito.when((Object)this.textPropertyProviderFactory.getProvider((Element)node)).thenReturn((Object)textPropertyProvider);
        ((NodeTextSetter)Mockito.doReturn((Object)"old name").when((Object)this.nodeTextSetter)).getName((Object)node);
        ((NodeTextSetter)Mockito.doReturn(editorSession).when((Object)this.nodeTextSetter)).getCurrentSession();
        ((NodeTextSetter)Mockito.doReturn(optionalCanvasHanlder).when((Object)this.nodeTextSetter)).getCanvasHandler(dmnEditorSession);
        this.nodeTextSetter.setText("new name", node);
        ((TextPropertyProvider)Mockito.verify((Object)textPropertyProvider)).setText(canvasHandler, commandManager, (Element)node, "new name");
        ((NodeTextSetter)Mockito.verify((Object)this.nodeTextSetter)).fireCanvasElementUpdated(canvasHandler, node);
    }

    @Test
    public void testFireCanvasElementUpdated() {
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Node node = (Node)Mockito.mock(Node.class);
        this.nodeTextSetter.fireCanvasElementUpdated(canvasHandler, node);
        ((EventSourceMock)Mockito.verify(this.canvasElementUpdatedEvent)).fire(this.canvasElementUpdatedEventArgumentCaptor.capture());
        CanvasElementUpdatedEvent arg = (CanvasElementUpdatedEvent)this.canvasElementUpdatedEventArgumentCaptor.getValue();
        Assert.assertEquals((Object)canvasHandler, (Object)arg.getCanvasHandler());
        Assert.assertEquals((Object)node, (Object)arg.getElement());
    }

    @Test
    public void testGetName() {
        NamedElement named = (NamedElement)Mockito.mock(NamedElement.class);
        Node node = (Node)Mockito.mock(Node.class);
        Name name = (Name)Mockito.mock(Name.class);
        String nodeName = "node name";
        Mockito.when((Object)name.getValue()).thenReturn((Object)"node name");
        Mockito.when((Object)named.getName()).thenReturn((Object)name);
        ((NodeTextSetter)Mockito.doReturn(Optional.of(named)).when((Object)this.nodeTextSetter)).getNamedElement((Object)node);
        String actualName = this.nodeTextSetter.getName((Object)node);
        Assert.assertEquals((Object)"node name", (Object)actualName);
    }

    @Test
    public void testGetNameWhenNamedElementIsNotPresent() {
        Node node = (Node)Mockito.mock(Node.class);
        Name name = (Name)Mockito.mock(Name.class);
        String nodeName = "node name";
        Mockito.when((Object)name.getValue()).thenReturn((Object)"node name");
        ((NodeTextSetter)Mockito.doReturn(Optional.empty()).when((Object)this.nodeTextSetter)).getNamedElement((Object)node);
        String actualName = this.nodeTextSetter.getName((Object)node);
        Assert.assertEquals((Object)"", (Object)actualName);
    }

    @Test
    public void testGetNamedElement() {
        Node node = (Node)Mockito.mock(Node.class);
        View content = (View)Mockito.mock(View.class);
        NamedElement namedElement = (NamedElement)Mockito.mock(NamedElement.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)namedElement);
        Optional actualNamed = this.nodeTextSetter.getNamedElement((Object)node);
        Assert.assertTrue((boolean)actualNamed.isPresent());
        Assert.assertEquals((Object)namedElement, actualNamed.get());
    }

    @Test
    public void testGetNamedElementWhenNamedIsNotPresent() {
        Node node = (Node)Mockito.mock(Node.class);
        View content = (View)Mockito.mock(View.class);
        Object namedElement = Mockito.mock(Object.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn(namedElement);
        Optional actualNamed = this.nodeTextSetter.getNamedElement((Object)node);
        Assert.assertFalse((boolean)actualNamed.isPresent());
    }

    @Test
    public void testGetNamedElementWhenViewIsNotPresent() {
        Node node = (Node)Mockito.mock(Node.class);
        Object content = Mockito.mock(Object.class);
        Mockito.when((Object)node.getContent()).thenReturn(content);
        Optional actualNamed = this.nodeTextSetter.getNamedElement((Object)node);
        Assert.assertFalse((boolean)actualNamed.isPresent());
    }
}

