/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.view.decisionservice;

import com.ait.lienzo.client.core.Attribute;
import com.ait.lienzo.client.core.event.AbstractNodeDragEvent;
import com.ait.lienzo.client.core.event.NodeDragEndEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragStartEvent;
import com.ait.lienzo.client.core.shape.Attributes;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.IControlHandleFactory;
import com.ait.lienzo.client.core.shape.wires.IControlHandleList;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepEvent;
import com.ait.lienzo.client.core.types.DragBounds;
import com.ait.lienzo.client.widget.DragContext;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import java.util.Collections;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.DecisionServiceSVGShapeView;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerEndEvent;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerEndHandler;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStartEvent;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStartHandler;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStepEvent;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStepHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGPrimitiveShape;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DecisionServiceSVGShapeViewTest {
    private static final double WIDTH = 100.0;
    private static final double HEIGHT = 200.0;
    @Mock
    private SVGPrimitiveShape svgPrimitive;
    @Mock
    private Shape shape;
    @Mock
    private Attributes attributes;
    @Mock
    private Node shapeNode;
    @Mock
    private DragHandler dragHandler;
    @Mock
    private DragContext dragContext;
    private NodeDragStartEvent nodeDragStartEvent;
    private NodeDragMoveEvent nodeDragMoveEvent;
    private NodeDragEndEvent nodeDragEndEvent;
    private DecisionServiceSVGShapeView view;

    @Before
    public void setup() {
        Mockito.when((Object)this.svgPrimitive.get()).thenReturn((Object)this.shape);
        Mockito.when((Object)this.shape.getAttributes()).thenReturn((Object)this.attributes);
        Mockito.when((Object)this.shape.asNode()).thenReturn((Object)this.shapeNode);
        Mockito.when((Object)this.attributes.getDouble(Attribute.WIDTH.getProperty())).thenReturn((Object)100.0);
        Mockito.when((Object)this.attributes.getDouble(Attribute.HEIGHT.getProperty())).thenReturn((Object)200.0);
        this.nodeDragStartEvent = new NodeDragStartEvent(this.dragContext);
        this.nodeDragMoveEvent = new NodeDragMoveEvent(this.dragContext);
        this.nodeDragEndEvent = new NodeDragEndEvent(this.dragContext);
        this.view = new DecisionServiceSVGShapeView("name", this.svgPrimitive, 100.0, 200.0, true);
    }

    @Test
    public void testGetDividerLineY() {
        Assertions.assertThat((double)this.view.getDividerLineY()).isEqualTo(0.0);
    }

    @Test
    public void testSetDividerLineY() {
        this.view.setDividerLineY(50.0);
        Assertions.assertThat((double)this.getMoveDividerControlHandle().getControl().getY()).isEqualTo(50.0);
    }

    private DecisionServiceSVGShapeView.MoveDividerControlHandle getMoveDividerControlHandle() {
        IControlHandleFactory controlHandleFactory = this.view.getPath().getControlHandleFactory();
        IControlHandleList controlHandles = (IControlHandleList)controlHandleFactory.getControlHandles(new IControlHandle.ControlHandleType[]{IControlHandle.ControlHandleStandardType.RESIZE}).get(IControlHandle.ControlHandleStandardType.RESIZE);
        return StreamSupport.stream(controlHandles.spliterator(), false).filter(ch -> ch instanceof DecisionServiceSVGShapeView.MoveDividerControlHandle).map(ch -> (DecisionServiceSVGShapeView.MoveDividerControlHandle)ch).findFirst().get();
    }

    @Test
    public void testResize() {
        this.view.getHandlerManager().fireEvent((GwtEvent)new WiresResizeStepEvent((WiresShape)this.view, (AbstractNodeDragEvent)this.nodeDragMoveEvent, 0, 0, 100.0, 200.0));
        Assertions.assertThat((double)this.getMoveDividerControlHandle().getControl().getX()).isEqualTo(50.0);
    }

    @Test
    public void testAddDividerDragHandler() {
        this.view.addDividerDragHandler(this.dragHandler);
        HandlerManager handlerManager = this.view.getHandlerManager();
        Assertions.assertThat((boolean)handlerManager.isEventHandled(MoveDividerStartEvent.TYPE)).isTrue();
        Assertions.assertThat((boolean)handlerManager.isEventHandled(MoveDividerStepEvent.TYPE)).isTrue();
        Assertions.assertThat((boolean)handlerManager.isEventHandled(MoveDividerEndEvent.TYPE)).isTrue();
        Assertions.assertThat((int)handlerManager.getHandlerCount(MoveDividerStartEvent.TYPE)).isEqualTo(1);
        Assertions.assertThat((int)handlerManager.getHandlerCount(MoveDividerStepEvent.TYPE)).isEqualTo(1);
        Assertions.assertThat((int)handlerManager.getHandlerCount(MoveDividerEndEvent.TYPE)).isEqualTo(1);
        ((MoveDividerStartHandler)handlerManager.getHandler(MoveDividerStartEvent.TYPE, 0)).onMoveDividerStart(new MoveDividerStartEvent(this.view, (AbstractNodeDragEvent)this.nodeDragStartEvent));
        ((DragHandler)Mockito.verify((Object)this.dragHandler)).start((DragEvent)Matchers.any(DragEvent.class));
        ((MoveDividerStepHandler)handlerManager.getHandler(MoveDividerStepEvent.TYPE, 0)).onMoveDividerStep(new MoveDividerStepEvent(this.view, (AbstractNodeDragEvent)this.nodeDragMoveEvent));
        ((DragHandler)Mockito.verify((Object)this.dragHandler)).handle((ViewEvent)Matchers.any(DragEvent.class));
        ((MoveDividerEndHandler)handlerManager.getHandler(MoveDividerEndEvent.TYPE, 0)).onMoveDividerEnd(new MoveDividerEndEvent(this.view, (AbstractNodeDragEvent)this.nodeDragEndEvent));
        ((DragHandler)Mockito.verify((Object)this.dragHandler)).end((DragEvent)Matchers.any(DragEvent.class));
    }

    @Test
    public void testShapeControlHandleFactory() {
        IControlHandleFactory controlHandleFactory = this.view.getPath().getControlHandleFactory();
        Assertions.assertThat((Object)controlHandleFactory).isInstanceOf(DecisionServiceSVGShapeView.DecisionServiceControlHandleFactory.class);
    }

    @Test
    public void testShapeControlResizeHandles() {
        IControlHandleFactory controlHandleFactory = this.view.getPath().getControlHandleFactory();
        IControlHandleList controlHandles = (IControlHandleList)controlHandleFactory.getControlHandles(Collections.singletonList(IControlHandle.ControlHandleStandardType.RESIZE)).get(IControlHandle.ControlHandleStandardType.RESIZE);
        Assertions.assertThat((int)controlHandles.size()).isGreaterThan(0);
        Assertions.assertThat((Iterable)controlHandles).areExactly(1, new Condition(ch -> ch instanceof DecisionServiceSVGShapeView.MoveDividerControlHandle, "Is a MoveDividerControlHandle", new Object[0]));
    }

    @Test
    public void testShapeControlResizeHandlersWithList() {
        IControlHandleFactory controlHandleFactory = this.view.getPath().getControlHandleFactory();
        IControlHandleList controlHandles = (IControlHandleList)controlHandleFactory.getControlHandles(new IControlHandle.ControlHandleType[]{IControlHandle.ControlHandleStandardType.RESIZE}).get(IControlHandle.ControlHandleStandardType.RESIZE);
        Assertions.assertThat((int)controlHandles.size()).isGreaterThan(0);
        Assertions.assertThat((Iterable)controlHandles).areExactly(1, new Condition(ch -> ch instanceof DecisionServiceSVGShapeView.MoveDividerControlHandle, "Is a MoveDividerControlHandle", new Object[0]));
    }

    @Test
    public void testShapeControlResizeHandlerMoveDividerEvents() {
        DecisionServiceSVGShapeView.MoveDividerControlHandle moveDividerControlHandle = this.getMoveDividerControlHandle();
        this.view.addDividerDragHandler(this.dragHandler);
        moveDividerControlHandle.getControl().fireEvent((GwtEvent)this.nodeDragStartEvent);
        ((DragHandler)Mockito.verify((Object)this.dragHandler)).start((DragEvent)Matchers.any(DragEvent.class));
        moveDividerControlHandle.getControl().fireEvent((GwtEvent)this.nodeDragMoveEvent);
        ((DragHandler)Mockito.verify((Object)this.dragHandler)).handle((ViewEvent)Matchers.any(DragEvent.class));
        moveDividerControlHandle.getControl().fireEvent((GwtEvent)this.nodeDragEndEvent);
        ((DragHandler)Mockito.verify((Object)this.dragHandler)).end((DragEvent)Matchers.any(DragEvent.class));
    }

    @Test
    public void testDragConstraintHandler() {
        DecisionServiceSVGShapeView.MoveDividerControlHandle moveDividerControlHandle = this.getMoveDividerControlHandle();
        IPrimitive control = moveDividerControlHandle.getControl();
        Mockito.when((Object)this.dragContext.getNode()).thenReturn((Object)control);
        DecisionServiceSVGShapeView.MoveDividerDragHandler dragConstraints = (DecisionServiceSVGShapeView.MoveDividerDragHandler)this.getMoveDividerControlHandle().getControl().getDragConstraints();
        dragConstraints.startDrag(this.dragContext);
        DragBounds dragBounds = control.getDragBounds();
        Assertions.assertThat((double)dragBounds.getX1()).isEqualTo(0.0);
        Assertions.assertThat((double)dragBounds.getY1()).isEqualTo(50.0);
        Assertions.assertThat((double)dragBounds.getX2()).isEqualTo(100.0);
        Assertions.assertThat((double)dragBounds.getY2()).isEqualTo(150.0);
    }
}

