/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.popover;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.CanBeClosedByKeyboard;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverImpl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.PopoverView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractPopoverImplTest {
    private static final int UI_ROW_INDEX = 0;
    private static final int UI_COLUMN_INDEX = 1;
    @Mock
    private PopoverView view;
    @Mock
    private Consumer<CanBeClosedByKeyboard> callback;
    private Object control = new Object();
    private AbstractPopoverImpl<PopoverView, Object> popover;

    @Before
    public void setup() {
        this.popover = (AbstractPopoverImpl)Mockito.spy((Object)new AbstractPopoverImpl<PopoverView, Object>(this.view){});
    }

    @Test
    public void testGetElement() {
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.popover.getElement()).thenReturn((Object)element);
        HTMLElement actual = this.popover.getElement();
        Assert.assertEquals((Object)element, (Object)actual);
    }

    @Test
    public void testSetOnClosedByKeyboardCallbackNullControl() {
        this.popover.setOnClosedByKeyboardCallback(this.callback);
        ((PopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setOnClosedByKeyboardCallback((Consumer)Matchers.any(Consumer.class));
    }

    @Test
    public void testSetOnClosedByKeyboardCallbackNonNullControl() {
        this.popover.bind(this.control, 0, 1);
        this.popover.setOnClosedByKeyboardCallback(this.callback);
        ((PopoverView)Mockito.verify((Object)this.view)).setOnClosedByKeyboardCallback(this.callback);
    }

    @Test
    public void testShowNullControl() {
        this.popover.show();
        ((PopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show((Optional)Matchers.any(Optional.class));
    }

    @Test
    public void testShowNonNullControl() {
        this.popover.bind(this.control, 0, 1);
        Mockito.reset((Object[])new PopoverView[]{this.view});
        this.popover.show();
        ((PopoverView)Mockito.verify((Object)this.view)).show((Optional)Matchers.eq(Optional.empty()));
    }

    @Test
    public void testHideNullControl() {
        this.popover.hide();
        ((PopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testHideNonNullControl() {
        this.popover.bind(this.control, 0, 1);
        Mockito.reset((Object[])new PopoverView[]{this.view});
        this.popover.hide();
        ((PopoverView)Mockito.verify((Object)this.view)).hide();
    }
}

