/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.handlers;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.MouseEvent;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.EditableHeaderGridWidgetEditCellMouseEventHandler;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=LienzoMockitoTestRunner.class)
public class EditableHeaderGridWidgetEditCellMouseEventHandlerTest {
    private static final int MOUSE_EVENT_X = 32;
    private static final int MOUSE_EVENT_Y = 64;
    private static final double GRID_COMPUTED_LOCATION_X = 100.0;
    private static final double GRID_COMPUTED_LOCATION_Y = 200.0;
    @Mock
    private BaseGrid gridWidget;
    @Mock
    private Group gridWidgetHeader;
    @Mock
    private GridColumn gridColumn;
    @Mock
    private Viewport viewport;
    @Mock
    private GridRenderer renderer;
    @Mock
    private MouseEvent nativeClickEvent;
    @Mock
    private DoubleClickEvent nativeDoubleClickEvent;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformation;
    @Mock
    private BaseGridRendererHelper.ColumnInformation columnInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation renderingBlockInformation;
    @Mock
    private EditableHeaderMetaData editableHeaderMetaData;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    @Captor
    private ArgumentCaptor<GridBodyCellEditContext> gridBodyCellEditContextCaptor;
    private NodeMouseClickEvent clickEvent;
    private NodeMouseDoubleClickEvent doubleClickEvent;
    private GridData uiModel;
    private EditableHeaderGridWidgetEditCellMouseEventHandler handler;
    private Point2D relativeLocation = new Point2D(32.0, 64.0);
    private Point2D computedLocation = new Point2D(100.0, 200.0);

    @Before
    public void setup() {
        this.uiModel = new BaseGridData(false);
        this.uiModel.appendColumn(this.gridColumn);
        this.clickEvent = new NodeMouseClickEvent(this.nativeClickEvent);
        this.doubleClickEvent = new NodeMouseDoubleClickEvent(this.nativeDoubleClickEvent);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.gridWidget.getRendererHelper()).thenReturn((Object)this.rendererHelper);
        Mockito.when((Object)this.gridWidget.getRenderer()).thenReturn((Object)this.renderer);
        Mockito.when((Object)this.gridWidget.getHeader()).thenReturn((Object)this.gridWidgetHeader);
        Mockito.when((Object)this.gridWidget.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.gridWidget.getComputedLocation()).thenReturn((Object)this.computedLocation);
        Mockito.when((Object)this.gridWidget.getWidth()).thenReturn((Object)32.0);
        Mockito.when((Object)this.rendererHelper.getRenderingInformation()).thenReturn((Object)this.renderingInformation);
        Mockito.when((Object)this.rendererHelper.getColumnInformation(Matchers.anyDouble())).thenReturn((Object)this.columnInformation);
        Mockito.when((Object)this.columnInformation.getColumn()).thenReturn((Object)this.gridColumn);
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)64.0);
        Mockito.when((Object)this.renderingInformation.getAllColumns()).thenReturn((Object)this.uiModel.getColumns());
        Mockito.when((Object)this.renderingInformation.getBodyBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.renderingInformation.getFloatingBlockInformation()).thenReturn((Object)this.renderingBlockInformation);
        Mockito.when((Object)this.editableHeaderMetaData.getSupportedEditAction()).thenReturn((Object)GridCellEditAction.SINGLE_CLICK);
        this.handler = new EditableHeaderGridWidgetEditCellMouseEventHandler();
    }

    @Test
    public void testOnNodeMouseEventWhenOnlyVisualChangeAllowed() {
        Mockito.when((Object)this.gridWidget.isOnlyVisualChangeAllowed()).thenReturn((Object)true);
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (AbstractNodeMouseEvent)this.clickEvent)).isFalse();
        ((BaseGrid)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.never())).startEditingCell((Point2D)Matchers.any(Point2D.class));
        ((EditableHeaderMetaData)Mockito.verify((Object)this.editableHeaderMetaData, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testOnNodeMouseEventWhenIsReadOnlyDiagram() {
        Mockito.when((Object)this.gridWidget.isOnlyVisualChangeAllowed()).thenReturn((Object)false);
        Mockito.when((Object)this.readOnlyProvider.isReadOnlyDiagram()).thenReturn((Object)true);
        Assertions.assertThat((boolean)this.handler.onNodeMouseEvent((GridWidget)this.gridWidget, this.relativeLocation, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (AbstractNodeMouseEvent)this.clickEvent)).isFalse();
        ((BaseGrid)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.never())).startEditingCell((Point2D)Matchers.any(Point2D.class));
        ((EditableHeaderMetaData)Mockito.verify((Object)this.editableHeaderMetaData, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testHandleHeaderCell_NonEditableColumn() {
        Assertions.assertThat((boolean)this.handler.handleHeaderCell((GridWidget)this.gridWidget, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent)).isFalse();
        ((EditableHeaderMetaData)Mockito.verify((Object)this.editableHeaderMetaData, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_NotEditableRow() {
        Mockito.when((Object)this.gridColumn.getHeaderMetaData()).thenReturn(Collections.singletonList(new BaseHeaderMetaData("column")));
        Assertions.assertThat((boolean)this.handler.handleHeaderCell((GridWidget)this.gridWidget, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.clickEvent)).isFalse();
        ((EditableHeaderMetaData)Mockito.verify((Object)this.editableHeaderMetaData, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_EditableRow_ClickEvent() {
        Mockito.when((Object)this.gridColumn.getHeaderMetaData()).thenReturn(Collections.singletonList(this.editableHeaderMetaData));
        this.uiModel.selectHeaderCell(0, 0);
        this.assertHeaderCellEdited(0);
    }

    @Test
    public void testHandleHeaderCell_EditableMergedColumns_EditableRow_Column0_ClickEvent() {
        this.setupAdditionalColumn();
        this.assertHeaderCellEdited(0);
    }

    @Test
    public void testHandleHeaderCell_EditableMergedColumns_EditableRow_Column1_ClickEvent() {
        this.setupAdditionalColumn();
        this.assertHeaderCellEdited(1);
    }

    private void setupAdditionalColumn() {
        GridColumn additionalGridColumn = (GridColumn)Mockito.mock(GridColumn.class);
        this.uiModel.appendColumn(additionalGridColumn);
        Mockito.when((Object)this.gridColumn.getHeaderMetaData()).thenReturn(Collections.singletonList(this.editableHeaderMetaData));
        Mockito.when((Object)this.gridColumn.getIndex()).thenReturn((Object)0);
        Mockito.when((Object)additionalGridColumn.getHeaderMetaData()).thenReturn(Collections.singletonList(this.editableHeaderMetaData));
        Mockito.when((Object)additionalGridColumn.getIndex()).thenReturn((Object)1);
        this.uiModel.selectHeaderCell(0, 0);
        this.uiModel.selectHeaderCell(0, 1);
    }

    private void assertHeaderCellEdited(int uiHeaderColumnIndex) {
        Assertions.assertThat((boolean)this.handler.handleHeaderCell((GridWidget)this.gridWidget, this.relativeLocation, 0, uiHeaderColumnIndex, (AbstractNodeMouseEvent)this.clickEvent)).isTrue();
        ((EditableHeaderMetaData)Mockito.verify((Object)this.editableHeaderMetaData)).edit((GridBodyCellEditContext)this.gridBodyCellEditContextCaptor.capture());
        GridBodyCellEditContext gridBodyCellEditContext = (GridBodyCellEditContext)this.gridBodyCellEditContextCaptor.getValue();
        Assertions.assertThat((Object)gridBodyCellEditContext).isNotNull();
        Assertions.assertThat((Optional)gridBodyCellEditContext.getRelativeLocation()).isPresent();
        Point2D relativeLocation = (Point2D)gridBodyCellEditContext.getRelativeLocation().get();
        Assertions.assertThat((double)relativeLocation.getX()).isEqualTo(132.0);
        Assertions.assertThat((double)relativeLocation.getY()).isEqualTo(264.0);
    }

    @Test
    public void testHandleHeaderCell_EditableColumn_EditableRow_DoubleClickEvent() {
        Mockito.when((Object)this.gridColumn.getHeaderMetaData()).thenReturn(Collections.singletonList(this.editableHeaderMetaData));
        this.uiModel.selectHeaderCell(0, 0);
        Assertions.assertThat((boolean)this.handler.handleHeaderCell((GridWidget)this.gridWidget, this.relativeLocation, 0, 0, (AbstractNodeMouseEvent)this.doubleClickEvent)).isFalse();
        ((EditableHeaderMetaData)Mockito.verify((Object)this.editableHeaderMetaData, (VerificationMode)Mockito.never())).edit((GridBodyCellEditContext)Matchers.any(GridBodyCellEditContext.class));
    }
}

