/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Java6Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridDataTest {
    @Mock
    private ExpressionEditorColumn resizableUiColumn;
    @Mock
    private DMNGridCell uiCell;
    private DMNGridData uiModel;

    @Before
    public void setup() {
        this.uiModel = new DMNGridData();
        IntStream.range(0, 3).forEach(i -> this.uiModel.appendRow((GridRow)new BaseGridRow()));
        IntStream.range(0, 2).forEach(i -> {
            DMNGridColumn uiColumn = (DMNGridColumn)Mockito.mock(DMNGridColumn.class);
            Mockito.when((Object)uiColumn.getIndex()).thenReturn((Object)i);
            this.uiModel.appendColumn((GridColumn)uiColumn);
        });
        this.uiModel.appendColumn((GridColumn)this.resizableUiColumn);
        Mockito.when((Object)this.resizableUiColumn.getIndex()).thenReturn((Object)2);
    }

    @Test
    public void testSelectCell() {
        GridData.Range r = this.uiModel.selectCell(0, 1);
        Java6Assertions.assertThat((int)r.getMinRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((int)r.getMaxRowIndex()).isEqualTo(0);
        List selections = this.uiModel.getSelectedCells();
        Java6Assertions.assertThat((List)selections).isNotEmpty();
        Java6Assertions.assertThat((int)selections.size()).isEqualTo(1);
        Java6Assertions.assertThat((List)selections).contains((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1)});
    }

    @Test
    public void testSelectCells() {
        GridData.Range r = this.uiModel.selectCells(0, 1, 1, 2);
        Java6Assertions.assertThat((int)r.getMinRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((int)r.getMaxRowIndex()).isEqualTo(0);
        List selections = this.uiModel.getSelectedCells();
        Java6Assertions.assertThat((List)selections).isNotEmpty();
        Java6Assertions.assertThat((int)selections.size()).isEqualTo(2);
        Java6Assertions.assertThat((List)selections).contains((Object[])new GridData.SelectedCell[]{new GridData.SelectedCell(0, 1), new GridData.SelectedCell(1, 1)});
    }

    @Test
    public void testSetCell() {
        GridData.Range r = this.uiModel.setCell(0, 1, () -> this.uiCell);
        Java6Assertions.assertThat((int)r.getMinRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((int)r.getMaxRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((Object)this.uiModel.getCell(0, 1)).isSameAs((Object)this.uiCell);
    }

    @Test
    public void testSetCellValue() {
        GridData.Range r = this.uiModel.setCellValue(0, 1, (GridCellValue)new BaseGridCellValue((Object)"value"));
        Java6Assertions.assertThat((int)r.getMinRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((int)r.getMaxRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((Object)this.uiModel.getCell(0, 1).getValue().getValue()).isEqualTo((Object)"value");
    }

    @Test
    public void testDeleteCell() {
        GridData.Range r = this.uiModel.deleteCell(0, 1);
        Java6Assertions.assertThat((int)r.getMinRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((int)r.getMaxRowIndex()).isEqualTo(0);
        Java6Assertions.assertThat((Object)this.uiModel.getCell(0, 1)).isNull();
    }
}

