/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.layer;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayerControlImpl;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasDomainObjectListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridLayerControlImplTest {
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private ClientSession session;
    @Mock
    private Element element;
    @Mock
    private DomainObject domainObject;
    @Captor
    private ArgumentCaptor<CanvasElementListener> canvasElementListenerCaptor;
    @Captor
    private ArgumentCaptor<CanvasDomainObjectListener> domainObjectListenerCaptor;
    private DMNGridLayerControlImpl control;

    @Before
    public void setup() {
        this.control = new DMNGridLayerControlImpl(){

            DMNGridLayer makeGridLayer() {
                return DMNGridLayerControlImplTest.this.gridLayer;
            }
        };
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
    }

    @Test
    public void testDoInit() {
        DMNGridLayer gridLayer = this.control.getGridLayer();
        Assert.assertNotNull((Object)gridLayer);
        this.control.doInit();
        Assert.assertEquals((Object)gridLayer, (Object)this.control.getGridLayer());
    }

    @Test
    public void testDoDestroy() {
        this.control.doDestroy();
        Assert.assertNull((Object)this.control.getGridLayer());
    }

    @Test
    public void testDoInitWithBoundSession() {
        this.control.bind(this.session);
        this.control.doInit();
        Assert.assertEquals((Object)this.gridLayer, (Object)this.control.getGridLayer());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addRegistrationListener((CanvasElementListener)this.canvasElementListenerCaptor.capture());
        CanvasElementListener canvasElementListener = (CanvasElementListener)this.canvasElementListenerCaptor.getValue();
        canvasElementListener.update(this.element);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        Mockito.reset((Object[])new DMNGridLayer[]{this.gridLayer});
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addDomainObjectListener((CanvasDomainObjectListener)this.domainObjectListenerCaptor.capture());
        CanvasDomainObjectListener domainObjectListener = (CanvasDomainObjectListener)this.domainObjectListenerCaptor.getValue();
        domainObjectListener.update(this.domainObject);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testDoDestroyWithBoundSession() {
        this.control.bind(this.session);
        this.control.doInit();
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addRegistrationListener((CanvasElementListener)this.canvasElementListenerCaptor.capture());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).addDomainObjectListener((CanvasDomainObjectListener)this.domainObjectListenerCaptor.capture());
        CanvasElementListener canvasElementListener = (CanvasElementListener)this.canvasElementListenerCaptor.getValue();
        CanvasDomainObjectListener domainObjectListener = (CanvasDomainObjectListener)this.domainObjectListenerCaptor.getValue();
        this.control.doDestroy();
        Assert.assertNull((Object)this.control.getGridLayer());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).removeRegistrationListener((CanvasElementListener)Matchers.eq((Object)canvasElementListener));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler)).removeDomainObjectListener((CanvasDomainObjectListener)Matchers.eq((Object)domainObjectListener));
    }

    @Test
    public void testGetGridLayer() {
        DMNGridLayer gridLayer = this.control.getGridLayer();
        Assert.assertEquals((String)"GridLayer instances should be identical.", (Object)gridLayer, (Object)this.control.getGridLayer());
    }
}

