/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelCellSelectionHandler;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelCellSelectionHandlerImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridPanelCellSelectionHandlerTest {
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridCell gridCell;
    private DMNGridPanelCellSelectionHandler cellSelectionHandler;

    @Before
    public void setup() {
        this.cellSelectionHandler = new DMNGridPanelCellSelectionHandlerImpl(this.gridLayer);
    }

    @Test
    public void testSelectCellIfRequired() {
        BaseExpressionGrid gridWidget = this.mockGridWidget();
        GridData gridData = gridWidget.getModel();
        gridData.setCell(0, 1, () -> this.gridCell);
        Mockito.when((Object)gridWidget.selectCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)true);
        this.cellSelectionHandler.selectCellIfRequired(0, 1, (GridWidget)gridWidget, true, false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)gridWidget));
        ((GridWidget)Mockito.verify((Object)gridWidget)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)true), Matchers.eq((boolean)false));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSelectCellIfRequiredButSelectionDidNotChanged() {
        BaseExpressionGrid gridWidget = this.mockGridWidget();
        GridData gridData = gridWidget.getModel();
        gridData.setCell(0, 1, () -> this.gridCell);
        Mockito.when((Object)gridWidget.selectCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)false);
        this.cellSelectionHandler.selectCellIfRequired(0, 1, (GridWidget)gridWidget, true, false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)gridWidget));
        ((GridWidget)Mockito.verify((Object)gridWidget)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)true), Matchers.eq((boolean)false));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).batch();
    }

    @Test
    public void testSelectCellIfRequiredWhenAlreadySelected() {
        BaseExpressionGrid gridWidget = this.mockGridWidget();
        GridData gridData = gridWidget.getModel();
        gridData.setCell(0, 1, () -> this.gridCell);
        gridData.selectCell(0, 1);
        this.cellSelectionHandler.selectCellIfRequired(0, 1, (GridWidget)gridWidget, true, false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).select((GridWidget)Matchers.eq((Object)gridWidget));
        ((GridWidget)Mockito.verify((Object)gridWidget, (VerificationMode)Mockito.never())).selectCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean());
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).batch();
    }

    @Test
    public void testSelectHeaderCellIfRequired() {
        BaseExpressionGrid gridWidget = this.mockGridWidget();
        GridData gridData = gridWidget.getModel();
        gridData.setCell(0, 1, () -> this.gridCell);
        Mockito.when((Object)gridWidget.selectHeaderCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)true);
        this.cellSelectionHandler.selectHeaderCellIfRequired(0, 1, (GridWidget)gridWidget, true, false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)gridWidget));
        ((GridWidget)Mockito.verify((Object)gridWidget)).selectHeaderCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)true), Matchers.eq((boolean)false));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testSelectHeaderCellIfRequiredButSelectionDidNotChanged() {
        BaseExpressionGrid gridWidget = this.mockGridWidget();
        GridData gridData = gridWidget.getModel();
        gridData.setCell(0, 1, () -> this.gridCell);
        Mockito.when((Object)gridWidget.selectHeaderCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)false);
        this.cellSelectionHandler.selectHeaderCellIfRequired(0, 1, (GridWidget)gridWidget, true, false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)gridWidget));
        ((GridWidget)Mockito.verify((Object)gridWidget)).selectHeaderCell(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((boolean)true), Matchers.eq((boolean)false));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).batch();
    }

    @Test
    public void testSelectHeaderCellIfRequiredWhenAlreadySelected() {
        BaseExpressionGrid gridWidget = this.mockGridWidget();
        GridData gridData = gridWidget.getModel();
        gridData.setCell(0, 1, () -> this.gridCell);
        gridData.selectHeaderCell(0, 1);
        this.cellSelectionHandler.selectHeaderCellIfRequired(0, 1, (GridWidget)gridWidget, true, false);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).select((GridWidget)Matchers.eq((Object)gridWidget));
        ((GridWidget)Mockito.verify((Object)gridWidget, (VerificationMode)Mockito.never())).selectHeaderCell(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean());
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).batch();
    }

    private BaseExpressionGrid mockGridWidget() {
        BaseExpressionGrid gridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        DMNGridData gridData = new DMNGridData();
        Mockito.when((Object)gridWidget.getModel()).thenReturn((Object)gridData);
        gridData.appendColumn((GridColumn)new RowNumberColumn());
        IntStream.range(0, 3).forEach(arg_0 -> DMNGridPanelCellSelectionHandlerTest.lambda$mockGridWidget$6((GridData)gridData, arg_0));
        gridData.appendRow((GridRow)new BaseGridRow());
        gridData.appendRow((GridRow)new BaseGridRow());
        gridData.appendRow((GridRow)new BaseGridRow());
        return gridWidget;
    }

    private static /* synthetic */ void lambda$mockGridWidget$6(GridData gridData, int i) {
        GridColumn gridColumn = (GridColumn)Mockito.mock(GridColumn.class);
        List<Object> headerMetaData = Collections.singletonList(Mockito.mock(GridColumn.HeaderMetaData.class));
        Mockito.when((Object)gridColumn.getIndex()).thenReturn((Object)i);
        Mockito.when((Object)gridColumn.getHeaderMetaData()).thenReturn(headerMetaData);
        gridData.appendColumn(gridColumn);
    }
}

