/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.panel;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelCellSelectionHandler;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelContextMenuHandler;
import org.kie.workbench.common.stunner.core.client.ReadOnlyProvider;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridPanelContextMenuHandlerTest {
    private static final double COLUMN0_WIDTH = 50.0;
    private static final double COLUMN1_WIDTH = 100.0;
    private static final double HEADER_HEIGHT = 20.0;
    private static final double ROW_HEIGHT = 20.0;
    @Mock
    private ContextMenuEvent event;
    @Mock
    private NativeEvent nativeEvent;
    @Mock
    private Element element;
    @Mock
    private Document document;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridRenderer renderer;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private DMNGridPanelCellSelectionHandler cellSelectionHandler;
    @Mock
    private HasCellEditorControls.Editor editor;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private TranslationService translationService;
    @Mock
    private GridColumn gridColumn;
    @Mock
    private ReadOnlyProvider readOnlyProvider;
    private DMNGridPanelContextMenuHandler handler;

    @Before
    public void setup() {
        this.handler = new DMNGridPanelContextMenuHandler(this.gridLayer, this.cellEditorControls, this.cellSelectionHandler);
        Mockito.when((Object)this.event.getNativeEvent()).thenReturn((Object)this.nativeEvent);
        Mockito.when((Object)this.event.getRelativeElement()).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getAbsoluteLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getAbsoluteTop()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.element.getOwnerDocument()).thenReturn((Object)this.document);
        Mockito.when((Object)this.document.getScrollLeft()).thenReturn((Object)0);
        Mockito.when((Object)this.document.getScrollTop()).thenReturn((Object)0);
        Mockito.when((Object)this.nativeEvent.getShiftKey()).thenReturn((Object)false);
        Mockito.when((Object)this.nativeEvent.getCtrlKey()).thenReturn((Object)false);
        Mockito.when((Object)this.gridColumn.getWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)this.gridColumn.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)this.renderer.getHeaderHeight()).thenReturn((Object)20.0);
        Mockito.when((Object)this.renderer.getHeaderRowHeight()).thenReturn((Object)20.0);
        Mockito.when((Object)this.gridLayer.getVisibleBounds()).thenReturn((Object)new BaseBounds(0.0, 0.0, 1000.0, 1000.0));
    }

    @Test
    public void onContextMenu_NoGridWidgets() {
        this.handler.onContextMenu(this.event);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).show((HasCellEditorControls.Editor)Matchers.any(HasCellEditorControls.Editor.class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void onContextMenu_WithGridWidget_EventOutsideGridBounds() {
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)200);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)70);
        BaseGrid gridWidget = this.mockGridWidget();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        this.handler.onContextMenu(this.event);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).show((HasCellEditorControls.Editor)Matchers.any(HasCellEditorControls.Editor.class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void onContextMenu_WithGridWidget_WithNullCell() {
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)25);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)30);
        BaseGrid gridWidget = this.mockGridWidget();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        this.handler.onContextMenu(this.event);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).show((HasCellEditorControls.Editor)Matchers.any(HasCellEditorControls.Editor.class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void onContextMenu_WithGridWidget_WithCellValueOfWrongType() {
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)25);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)30);
        BaseGrid gridWidget = this.mockGridWidget();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        gridWidget.getModel().setCellValue(1, 0, (GridCellValue)new ExpressionCellValue(Optional.empty()));
        this.handler.onContextMenu(this.event);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).show((HasCellEditorControls.Editor)Matchers.any(HasCellEditorControls.Editor.class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void onContextMenu_WithGridWidget_WithCellValue() {
        int EVENT_X = 25;
        int EVENT_Y = 50;
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)25);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)50);
        BaseGrid gridWidget = this.mockGridWidget();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        MockCell cell = (MockCell)Mockito.mock(MockCell.class);
        gridWidget.getModel().setCell(1, 0, () -> cell);
        Mockito.when((Object)cell.getEditor()).thenReturn(Optional.of(this.editor));
        this.handler.onContextMenu(this.event);
        ((HasCellEditorControls.Editor)Mockito.verify((Object)this.editor)).bind(Matchers.eq((Object)gridWidget), Matchers.eq((int)1), Matchers.eq((int)0));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.editor), Matchers.eq((int)25), Matchers.eq((int)50));
    }

    @Test
    public void onContextMenu_WithGridWidget_WithHeader() {
        int EVENT_X = 100;
        int EVENT_Y = 10;
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)100);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)10);
        BaseGrid gridWidget = this.mockGridWidget();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        MockContextMenuHeaderMetaData headerMetaData = (MockContextMenuHeaderMetaData)Mockito.mock(MockContextMenuHeaderMetaData.class);
        Mockito.when((Object)this.gridColumn.getHeaderMetaData()).thenReturn(Collections.singletonList(headerMetaData));
        Mockito.when((Object)headerMetaData.getEditor()).thenReturn(Optional.of(this.editor));
        this.handler.onContextMenu(this.event);
        ((HasCellEditorControls.Editor)Mockito.verify((Object)this.editor)).bind(Matchers.eq((Object)headerMetaData), Matchers.eq((int)0), Matchers.eq((int)1));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.editor), Matchers.eq((int)100), Matchers.eq((int)10));
    }

    @Test
    public void onContextMenu_WithGridWidget_WithCellValue_WithOnlyVisualChangeAllowed() {
        int EVENT_X = 25;
        int EVENT_Y = 30;
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)25);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)30);
        BaseGrid gridWidget = this.mockGridWidget();
        ((BaseGrid)Mockito.doReturn((Object)true).when((Object)gridWidget)).isOnlyVisualChangeAllowed();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        this.handler.onContextMenu(this.event);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls, (VerificationMode)Mockito.never())).show((HasCellEditorControls.Editor)Matchers.any(HasCellEditorControls.Editor.class), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void onContextMenu_WithGridWidget_WithCellSelectionStrategy_CellNotSelected() {
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)25);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)50);
        BaseGrid gridWidget = this.mockGridWidget();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        MockCell cell = (MockCell)Mockito.mock(MockCell.class);
        CellSelectionStrategy selectionStrategy = (CellSelectionStrategy)Mockito.mock(CellSelectionStrategy.class);
        gridWidget.getModel().setCell(1, 0, () -> cell);
        Mockito.when((Object)cell.getEditor()).thenReturn(Optional.of(this.editor));
        Mockito.when((Object)cell.getSelectionStrategy()).thenReturn((Object)selectionStrategy);
        this.handler.onContextMenu(this.event);
        ((DMNGridPanelCellSelectionHandler)Mockito.verify((Object)this.cellSelectionHandler)).selectCellIfRequired(Matchers.eq((int)1), Matchers.eq((int)0), (GridWidget)Matchers.eq((Object)gridWidget), Matchers.eq((boolean)false), Matchers.eq((boolean)false));
    }

    @Test
    public void onContextMenu_WithGridWidget_WithCellSelectionStrategy_CellAlreadySelected() {
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)25);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)30);
        BaseGrid gridWidget = this.mockGridWidget();
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(Collections.singleton(gridWidget));
        gridWidget.selectCell(1, 0, false, false);
        MockCell cell = (MockCell)Mockito.mock(MockCell.class);
        CellSelectionStrategy selectionStrategy = (CellSelectionStrategy)Mockito.mock(CellSelectionStrategy.class);
        gridWidget.getModel().setCell(1, 0, () -> cell);
        Mockito.when((Object)cell.getEditor()).thenReturn(Optional.of(this.editor));
        Mockito.when((Object)cell.getSelectionStrategy()).thenReturn((Object)selectionStrategy);
        this.handler.onContextMenu(this.event);
        ((CellSelectionStrategy)Mockito.verify((Object)selectionStrategy, (VerificationMode)Mockito.never())).handleSelection((GridData)Matchers.any(GridData.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean());
    }

    @Test
    public void onContextMenu_WithMultipleOverlappingGridWidgets() {
        int EVENT_X = 25;
        int EVENT_Y = 50;
        Mockito.when((Object)this.nativeEvent.getClientX()).thenReturn((Object)25);
        Mockito.when((Object)this.nativeEvent.getClientY()).thenReturn((Object)50);
        BaseGrid gridWidget1 = this.mockGridWidget();
        BaseGrid gridWidget2 = this.mockGridWidget();
        LinkedHashSet<BaseGrid> gridWidgets = new LinkedHashSet<BaseGrid>();
        gridWidgets.add(gridWidget1);
        gridWidgets.add(gridWidget2);
        Mockito.when((Object)this.gridLayer.getGridWidgets()).thenReturn(gridWidgets);
        MockCell cell1 = (MockCell)Mockito.mock(MockCell.class);
        gridWidget1.getModel().setCell(1, 0, () -> cell1);
        Mockito.when((Object)cell1.getEditor()).thenReturn(Optional.of(this.editor));
        MockCell cell2 = (MockCell)Mockito.mock(MockCell.class);
        gridWidget2.getModel().setCell(1, 0, () -> cell2);
        Mockito.when((Object)cell2.getEditor()).thenReturn(Optional.of(this.editor));
        this.handler.onContextMenu(this.event);
        ((HasCellEditorControls.Editor)Mockito.verify((Object)this.editor)).bind(Matchers.eq((Object)gridWidget2), Matchers.eq((int)1), Matchers.eq((int)0));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.editor), Matchers.eq((int)25), Matchers.eq((int)50));
    }

    private BaseGrid mockGridWidget() {
        BaseGrid gridWidget = (BaseGrid)Mockito.spy((Object)new BaseGrid(this.gridLayer, (GridData)new BaseGridData(false), this.renderer, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, this.canvasCommandFactory, (Event)this.refreshFormPropertiesEvent, (Event)this.domainObjectSelectionEvent, this.cellEditorControls, this.translationService){

            public Layer getLayer() {
                return this.gridLayer;
            }
        });
        gridWidget.getModel().appendColumn((GridColumn)new RowNumberColumn());
        gridWidget.getModel().appendColumn(this.gridColumn);
        gridWidget.getModel().appendRow((GridRow)new BaseGridRow());
        gridWidget.getModel().appendRow((GridRow)new BaseGridRow());
        return gridWidget;
    }

    private static interface MockContextMenuHeaderMetaData
    extends GridColumn.HeaderMetaData,
    HasCellEditorControls,
    HasListSelectorControl {
    }

    private static interface MockCell
    extends GridCell,
    HasCellEditorControls {
    }
}

