/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.api.included.legacy;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNIncludeModelsClientTest {
    @Mock
    private DMNClientServicesProxy service;
    @Mock
    private Consumer<List<IncludedModel>> listConsumerDMNModels;
    @Mock
    private Consumer<List<DMNIncludedNode>> listConsumerDMNNodes;
    @Mock
    private Consumer<List<ItemDefinition>> listConsumerDMNItemDefinitions;
    @Mock
    private Path path;
    private DMNIncludeModelsClient client;

    @Before
    public void setup() {
        this.client = new DMNIncludeModelsClient(this.service);
    }

    @Test
    public void testLoadModels() {
        this.client.loadModels(this.path, this.listConsumerDMNModels);
        ((DMNClientServicesProxy)Mockito.verify((Object)this.service)).loadModels((Path)Matchers.eq((Object)this.path), (ServiceCallback)Matchers.any(ServiceCallback.class));
    }

    @Test
    public void testLoadNodesFromImports() {
        DMNIncludedModel includedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        List<DMNIncludedModel> imports = Arrays.asList(includedModel1, includedModel2);
        this.client.loadNodesFromImports(imports, this.listConsumerDMNNodes);
        ((DMNClientServicesProxy)Mockito.verify((Object)this.service)).loadNodesFromImports((List)Matchers.eq(imports), (ServiceCallback)Matchers.any(ServiceCallback.class));
    }

    @Test
    public void testLoadItemDefinitionsByNamespace() {
        String modelName = "model1";
        String namespace = "://namespace1";
        this.client.loadItemDefinitionsByNamespace("model1", "://namespace1", this.listConsumerDMNItemDefinitions);
        ((DMNClientServicesProxy)Mockito.verify((Object)this.service)).loadItemDefinitionsByNamespace((String)Matchers.eq((Object)"model1"), (String)Matchers.eq((Object)"://namespace1"), (ServiceCallback)Matchers.any(ServiceCallback.class));
    }
}

