/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.invocation;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.AddParameterBindingCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddParameterBindingCommandTest {
    @Mock
    private GridWidget gridWidget;
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private NameColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private ExpressionEditorDefinitions expressionEditorDefinitions;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Invocation invocation;
    private Binding binding;
    private GridData uiModel;
    private GridRow uiModelRow;
    private InvocationUIModelMapper uiModelMapper;
    private AddParameterBindingCommand command;

    @Before
    public void setup() {
        this.invocation = new Invocation();
        this.binding = new Binding();
        InformationItem parameter = new InformationItem();
        parameter.setName(new Name("p" + this.invocation.getBinding().size()));
        this.binding.setParameter(parameter);
        this.uiModel = new BaseGridData(false);
        this.uiModelRow = new BaseGridRow();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        this.uiModelMapper = new InvocationUIModelMapper(this.gridWidget, () -> this.uiModel, () -> Optional.of(this.invocation), () -> false, () -> this.expressionEditorDefinitions, this.listSelector, 0);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((NameColumn)Mockito.doReturn((Object)1).when((Object)this.uiNameColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)2).when((Object)this.uiExpressionEditorColumn)).getIndex();
        ((GridWidget)Mockito.doReturn((Object)this.uiModel).when((Object)this.gridWidget)).getModel();
        ((ExpressionEditorDefinitions)Mockito.doReturn(Optional.empty()).when((Object)this.expressionEditorDefinitions)).getExpressionEditorDefinition((Optional)Matchers.any(Optional.class));
    }

    private void makeCommand(int uiRowIndex, Binding rowBindingEntry, GridRow uiGridRow) {
        this.command = new AddParameterBindingCommand(this.invocation, rowBindingEntry, this.uiModel, uiGridRow, uiRowIndex, this.uiModelMapper, this.canvasOperation);
    }

    private void makeCommand() {
        this.makeCommand(this.invocation.getBinding().size(), this.binding, this.uiModelRow);
    }

    private void makeCommand(int uiRowIndex) {
        this.makeCommand(uiRowIndex, this.binding, this.uiModelRow);
    }

    private void makeCommand(int uiRowIndex, GridRow uiGridRow) {
        Binding rowEntry = new Binding();
        InformationItem parameter = new InformationItem();
        parameter.setName(new Name());
        rowEntry.setParameter(parameter);
        this.makeCommand(uiRowIndex, rowEntry, uiGridRow);
    }

    private void assertBindingDefinitions(Binding ... bindings) {
        Assertions.assertThat((List)this.invocation.getBinding()).containsExactly((Object[])bindings);
        Assert.assertEquals((Object)"p-1", (Object)this.binding.getParameter().getName().getValue());
    }

    private void assertRowValues(int rowNumberIndex, int rowNumberValue, String nameColumnValue) {
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(rowNumberIndex)).getCells().size());
        Assert.assertEquals((Object)rowNumberValue, (Object)this.uiModel.getCell(rowNumberIndex, 0).getValue().getValue());
        Assert.assertEquals((Object)nameColumnValue, (Object)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(rowNumberIndex, 1).getValue().getValue()).getName().getValue());
        Assert.assertNull((Object)this.uiModel.getCell(rowNumberIndex, 2));
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteWithParameters() {
        Binding otherBinding = new Binding();
        this.invocation.getBinding().add(otherBinding);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertBindingDefinitions(otherBinding, this.binding);
        Assert.assertEquals((Object)this.invocation, (Object)this.binding.getParent());
        Assert.assertEquals((Object)this.binding, (Object)this.binding.getParameter().getParent());
    }

    @Test
    public void testGraphCommandExecuteInsertToFirstPlace() {
        Binding firstBinding = new Binding();
        Binding secondBinding = new Binding();
        this.invocation.getBinding().add(firstBinding);
        this.invocation.getBinding().add(secondBinding);
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertBindingDefinitions(this.binding, firstBinding, secondBinding);
        Assert.assertEquals((Object)this.invocation, (Object)this.binding.getParent());
        Assert.assertEquals((Object)this.binding, (Object)this.binding.getParameter().getParent());
    }

    @Test
    public void testGraphCommandExecuteInsertIntoMiddle() {
        Binding firstBinding = new Binding();
        Binding secondBinding = new Binding();
        this.invocation.getBinding().add(firstBinding);
        this.invocation.getBinding().add(secondBinding);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertBindingDefinitions(firstBinding, this.binding, secondBinding);
        Assert.assertEquals((Object)this.invocation, (Object)this.binding.getParent());
        Assert.assertEquals((Object)this.binding, (Object)this.binding.getParameter().getParent());
    }

    @Test
    public void testGraphCommandExecuteWithNoParameters() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertBindingDefinitions(this.binding);
        Assert.assertEquals((Object)this.invocation, (Object)this.binding.getParent());
        Assert.assertEquals((Object)this.binding, (Object)this.binding.getParameter().getParent());
    }

    @Test
    public void testGraphCommandUndoWithParameters() {
        Binding otherBinding = new Binding();
        this.invocation.getBinding().add(otherBinding);
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertBindingDefinitions(otherBinding);
    }

    @Test
    public void testGraphCommandUndoFromStart() {
        Binding firstBinding = new Binding();
        Binding secondBinding = new Binding();
        this.invocation.getBinding().add(firstBinding);
        this.invocation.getBinding().add(secondBinding);
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertBindingDefinitions(firstBinding, secondBinding);
    }

    @Test
    public void testGraphCommandUndoFromMiddle() {
        Binding firstBinding = new Binding();
        Binding secondBinding = new Binding();
        this.invocation.getBinding().add(firstBinding);
        this.invocation.getBinding().add(secondBinding);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertBindingDefinitions(firstBinding, secondBinding);
    }

    @Test
    public void testGraphCommandUndoWithNoParameters() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertBindingDefinitions(new Binding[0]);
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"p-1", (Object)((InformationItemCell.HasNameAndDataTypeCell)this.uiModel.getCell(0, 1).getValue().getValue()).getName().getValue());
        Assert.assertNull((Object)this.uiModel.getCell(0, 2));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteMultipleEntries() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command firstEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)firstEntryCanvasCommand.execute((Object)this.handler));
        BaseGridRow uiSecondModelRow = new BaseGridRow();
        this.makeCommand(1, (GridRow)uiSecondModelRow);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command secondEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)secondEntryCanvasCommand.execute((Object)this.handler));
        BaseGridRow uiThirdModelRow = new BaseGridRow();
        this.makeCommand(0, (GridRow)uiThirdModelRow);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command thirdEntryCanvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)thirdEntryCanvasCommand.execute((Object)this.handler));
        Assert.assertEquals((long)3L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)uiThirdModelRow, this.uiModel.getRows().get(0));
        Assert.assertEquals((Object)this.uiModelRow, this.uiModel.getRows().get(1));
        Assert.assertEquals((Object)uiSecondModelRow, this.uiModel.getRows().get(2));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        this.assertRowValues(0, 1, "p-3");
        this.assertRowValues(1, 2, "p-1");
        this.assertRowValues(2, 3, "p-2");
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)3))).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        this.makeCommand();
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Command[]{this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiNameColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((Object)this.uiExpressionEditorColumn, this.uiModel.getColumns().get(2));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

