/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.list;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.expressions.types.list.DeleteListRowCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteListRowCommandTest {
    private static final String VALUE = "value";
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private List list;
    private GridData uiModel;
    private DeleteListRowCommand command;

    @Before
    public void setup() {
        this.list = new List();
        this.uiModel = new BaseGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression()));
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)1).when((Object)this.uiExpressionEditorColumn)).getIndex();
    }

    private void makeCommand(int uiRowIndex) {
        this.command = (DeleteListRowCommand)Mockito.spy((Object)new DeleteListRowCommand(this.list, this.uiModel, uiRowIndex, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecute() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.list.getExpression().size());
    }

    @Test
    public void testGraphCommandExecuteRemoveMiddle() {
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        HasExpression firstRow = HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression());
        HasExpression lastRow = HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)new LiteralExpression());
        this.list.getExpression().add(0, firstRow);
        this.list.getExpression().add(lastRow);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.list.getExpression().size());
        Assert.assertEquals((Object)firstRow, this.list.getExpression().get(0));
        Assert.assertEquals((Object)lastRow, this.list.getExpression().get(1));
    }

    @Test
    public void testGraphCommandUndo() {
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getText().setValue(VALUE);
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)literalExpression));
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.list.getExpression().size());
        Assert.assertEquals((Object)VALUE, (Object)((LiteralExpression)((HasExpression)this.list.getExpression().get(1)).getExpression()).getText().getValue());
    }

    @Test
    public void testCanvasCommandAllow() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((DeleteListRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteListRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteRemoveMiddle() {
        BaseGridRow firstRow = new BaseGridRow();
        BaseGridRow lastRow = new BaseGridRow();
        this.uiModel.insertRow(0, (GridRow)firstRow);
        this.uiModel.appendRow((GridRow)lastRow);
        this.list.getExpression().add(0, HasExpression.wrap((DMNModelInstrumentedBase)this.list, null));
        this.list.getExpression().add(HasExpression.wrap((DMNModelInstrumentedBase)this.list, null));
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)firstRow, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)lastRow, (Object)this.uiModel.getRow(1));
        ((DeleteListRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteListRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        GridRow existingGridRow = this.uiModel.getRow(0);
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new Object[]{this.command, this.canvasOperation});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)existingGridRow, (Object)this.uiModel.getRow(0));
        ((DeleteListRowCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((DeleteListRowCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

