/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.canvas;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.factory.canvas.DMNDeleteCanvasConnectorNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDeleteCanvasConnectorNodeCommandTest {
    @Mock
    private GraphsProvider graphsProvider;
    @Mock
    private Edge candidate;
    @Mock
    private AbstractCanvasHandler context;
    private DMNDeleteCanvasConnectorNodeCommand command;

    @Before
    public void setup() {
        this.command = (DMNDeleteCanvasConnectorNodeCommand)Mockito.spy((Object)new DMNDeleteCanvasConnectorNodeCommand(this.candidate, this.graphsProvider));
    }

    @Test
    public void testUndoWhenCandidateDoesNotBelongsToCurrentGraph() {
        ((DMNDeleteCanvasConnectorNodeCommand)Mockito.doReturn((Object)false).when((Object)this.command)).candidateNodeBelongsToCurrentGraph();
        CommandResult commandResult = this.command.undo(this.context);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)commandResult);
        ((DMNDeleteCanvasConnectorNodeCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.never())).superUndo(this.context);
    }

    @Test
    public void testUndoWhenCandidateDoesBelongsToCurrentGraph() {
        CommandResult superCommandResult = (CommandResult)Mockito.mock(CommandResult.class);
        ((DMNDeleteCanvasConnectorNodeCommand)Mockito.doReturn((Object)superCommandResult).when((Object)this.command)).superUndo(this.context);
        ((DMNDeleteCanvasConnectorNodeCommand)Mockito.doReturn((Object)true).when((Object)this.command)).candidateNodeBelongsToCurrentGraph();
        CommandResult commandResult = this.command.undo(this.context);
        Assert.assertEquals((Object)superCommandResult, (Object)commandResult);
        ((DMNDeleteCanvasConnectorNodeCommand)Mockito.verify((Object)this.command)).superUndo(this.context);
    }
}

