/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.graph;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.factory.graph.DMNSetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.GraphsProvider;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.HasContentDefinitionId;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNSetConnectionTargetNodeCommandTest {
    private static final String EDGE_UUID = "edge uuid";
    private static final String NODE_DIAGRAM_UUID = "the id";
    private static final String TARGET_NODE_UUID = "target node uuid";
    @Mock
    private Node<? extends View<?>, Edge> targetNode;
    @Mock
    private Edge<? extends View, Node> edge;
    @Mock
    private Connection connection;
    @Mock
    private GraphsProvider graphsProvider;
    @Mock
    private GraphCommandExecutionContext context;
    private DMNSetConnectionTargetNodeCommand command;

    @Before
    public void setup() {
        Node edgeSourceNode = this.createNode(NODE_DIAGRAM_UUID);
        Mockito.when((Object)this.targetNode.getUUID()).thenReturn((Object)TARGET_NODE_UUID);
        Mockito.when((Object)this.edge.getUUID()).thenReturn((Object)EDGE_UUID);
        Mockito.when((Object)this.edge.getSourceNode()).thenReturn((Object)edgeSourceNode);
        this.command = (DMNSetConnectionTargetNodeCommand)Mockito.spy((Object)new DMNSetConnectionTargetNodeCommand(this.targetNode, this.edge, this.connection, this.graphsProvider));
    }

    @Test
    public void testGetTargetNodeWhenCommandBelongsToAnotherGraph() {
        Node node = (Node)Mockito.mock(Node.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)true).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)graph).when((Object)this.command)).getEdgesGraph();
        Mockito.when((Object)graph.getNode(TARGET_NODE_UUID)).thenReturn((Object)node);
        Node currentTargetNode = this.command.getTargetNode(this.context);
        Assert.assertEquals((Object)node, (Object)currentTargetNode);
        ((DMNSetConnectionTargetNodeCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.never())).superGetTargetNode(this.context);
    }

    @Test
    public void testGetTargetNodeWhenCommandBelongsToCurrentGraph() {
        Node node = (Node)Mockito.mock(Node.class);
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)false).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)node).when((Object)this.command)).superGetTargetNode(this.context);
        Node currentTargetNode = this.command.getTargetNode(this.context);
        Assert.assertEquals((Object)node, (Object)currentTargetNode);
        ((DMNSetConnectionTargetNodeCommand)Mockito.verify((Object)this.command)).superGetTargetNode(this.context);
    }

    @Test
    public void testGetNodeWhenCommandBelongsToAnotherGraph() {
        String uuid = "uuid";
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node node = (Node)Mockito.mock(Node.class);
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)true).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)graph).when((Object)this.command)).getEdgesGraph();
        Mockito.when((Object)graph.getNode("uuid")).thenReturn((Object)node);
        Node currentNode = this.command.getNode(this.context, "uuid");
        Assert.assertEquals((Object)node, (Object)currentNode);
    }

    @Test
    public void testGetNodeWhenCommandBelongsToCurrentGraph() {
        String uuid = "uuid";
        Node node = (Node)Mockito.mock(Node.class);
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)false).when((Object)this.command)).commandBelongsToAnotherGraph();
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn((Object)node).when((Object)this.command)).superGetNode(this.context, "uuid");
        Node currentNode = this.command.getNode(this.context, "uuid");
        Assert.assertEquals((Object)node, (Object)currentNode);
    }

    @Test
    public void testCommandBelongsToAnotherGraphWhenItIsNot() {
        String diagramId = "diagramId";
        Optional<String> commandDiagramId = Optional.of("diagramId");
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"diagramId");
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn(commandDiagramId).when((Object)this.command)).getDiagramId();
        Assert.assertFalse((boolean)this.command.commandBelongsToAnotherGraph());
    }

    @Test
    public void testCommandBelongsToAnotherGraph() {
        String diagramId = "diagramId";
        String anotherDiagramId = "another diagram id";
        Optional<String> commandDiagramId = Optional.of("diagramId");
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"another diagram id");
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn(commandDiagramId).when((Object)this.command)).getDiagramId();
        Assert.assertTrue((boolean)this.command.commandBelongsToAnotherGraph());
    }

    @Test
    public void testCommandBelongsToAnotherGraphWhenDiagramIdIsNotPresent() {
        String anotherDiagramId = "another diagram id";
        Mockito.when((Object)this.graphsProvider.getCurrentDiagramId()).thenReturn((Object)"another diagram id");
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn(Optional.empty()).when((Object)this.command)).getDiagramId();
        Assert.assertFalse((boolean)this.command.commandBelongsToAnotherGraph());
    }

    @Test
    public void testGetEdgesGraph() {
        String diagramId = "diagram id";
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn(Optional.of("diagram id")).when((Object)this.command)).getDiagramId();
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)this.graphsProvider.getDiagram("diagram id")).thenReturn((Object)diagram);
        Graph actualGraph = this.command.getEdgesGraph();
        Assert.assertEquals((Object)graph, (Object)actualGraph);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetEdgesGraphWhenDiagramIdIsNotSet() {
        ((DMNSetConnectionTargetNodeCommand)Mockito.doReturn(Optional.empty()).when((Object)this.command)).getDiagramId();
        this.command.getEdgesGraph();
    }

    private Node createNode(String diagramId) {
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        HasContentDefinitionId hasContentDefinitionId = (HasContentDefinitionId)Mockito.mock(HasContentDefinitionId.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)hasContentDefinitionId.getDiagramId()).thenReturn((Object)diagramId);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)hasContentDefinitionId);
        return node;
    }
}

