/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.graph;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.factory.graph.SetChildrenCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SetChildrenCommandTest
extends org.kie.workbench.common.stunner.core.graph.command.impl.SetChildrenCommandTest {
    @Mock
    private View parentContent;
    @Mock
    private View candidateContent;
    @Mock
    private DMNDiagram parentDefinition;
    @Mock
    private Decision candidateDefinition;
    @Mock
    private Name candidateDefinitionName;
    @Captor
    private ArgumentCaptor<String> candidateDefinitionNameCaptor;

    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.parent.getContent()).thenReturn((Object)this.parentContent);
        Mockito.when((Object)this.candidate.getContent()).thenReturn((Object)this.candidateContent);
        Mockito.when((Object)this.parentContent.getDefinition()).thenReturn((Object)this.parentDefinition);
        Mockito.when((Object)this.candidateContent.getDefinition()).thenReturn((Object)this.candidateDefinition);
        Mockito.when((Object)this.candidateDefinition.getName()).thenReturn((Object)this.candidateDefinitionName);
    }

    protected SetChildrenCommand createCommandInstance() {
        return new SetChildrenCommand("parentUUID", new String[]{"candidateUUID"});
    }

    @Test
    public void testExecute() {
        super.testExecute();
        ((Decision)Mockito.verify((Object)this.candidateDefinition)).setParent((DMNModelInstrumentedBase)Matchers.eq((Object)this.parentDefinition));
        ((Name)Mockito.verify((Object)this.candidateDefinitionName)).setValue((String)this.candidateDefinitionNameCaptor.capture());
        String name = (String)this.candidateDefinitionNameCaptor.getValue();
        Assertions.assertThat((String)name).startsWith((CharSequence)Decision.class.getSimpleName());
        Assertions.assertThat((String)name).endsWith((CharSequence)"-1");
    }

    public void testExecuteCheckFailed() {
        super.testExecuteCheckFailed();
        ((Decision)Mockito.verify((Object)this.candidateDefinition, (VerificationMode)Mockito.never())).setParent((DMNModelInstrumentedBase)Matchers.any(DMNModelInstrumentedBase.class));
    }
}

