/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.drds;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSessionState;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDiagramsSessionStateTest {
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private Diagram stunnerDiagram1;
    @Mock
    private Diagram stunnerDiagram2;
    @Mock
    private Diagram stunnerDiagram3;
    @Mock
    private DMNDiagramElement dmnDiagram1;
    @Mock
    private DMNDiagramElement dmnDiagram2;
    @Mock
    private DMNDiagramElement dmnDiagram3;
    private String id1 = "1111-1111-1111";
    private String id2 = "2222-2222-2222";
    private String id3 = "3333-3333-3333";
    private String name1 = "DRG";
    private String name2 = "Page 1";
    private String name3 = "Page 2";
    private DMNDiagramsSessionState sessionState;

    @Before
    public void setup() {
        this.sessionState = new DMNDiagramsSessionState(this.dmnDiagramUtils);
        Mockito.when((Object)this.dmnDiagram1.getId()).thenReturn((Object)new Id(this.id1));
        Mockito.when((Object)this.dmnDiagram2.getId()).thenReturn((Object)new Id(this.id2));
        Mockito.when((Object)this.dmnDiagram3.getId()).thenReturn((Object)new Id(this.id3));
        Mockito.when((Object)this.dmnDiagram1.getName()).thenReturn((Object)new Name(this.name1));
        Mockito.when((Object)this.dmnDiagram2.getName()).thenReturn((Object)new Name(this.name2));
        Mockito.when((Object)this.dmnDiagram3.getName()).thenReturn((Object)new Name(this.name3));
        this.sessionState.getDiagramsByDiagramId().put(this.id1, this.stunnerDiagram1);
        this.sessionState.getDiagramsByDiagramId().put(this.id2, this.stunnerDiagram2);
        this.sessionState.getDiagramsByDiagramId().put(this.id3, this.stunnerDiagram3);
        this.sessionState.getDMNDiagramsByDiagramId().put(this.id1, this.dmnDiagram1);
        this.sessionState.getDMNDiagramsByDiagramId().put(this.id2, this.dmnDiagram2);
        this.sessionState.getDMNDiagramsByDiagramId().put(this.id3, this.dmnDiagram3);
    }

    @Test
    public void testGetDiagram() {
        Assert.assertEquals((Object)this.stunnerDiagram1, (Object)this.sessionState.getDiagram(this.id1));
        Assert.assertEquals((Object)this.stunnerDiagram2, (Object)this.sessionState.getDiagram(this.id2));
        Assert.assertEquals((Object)this.stunnerDiagram3, (Object)this.sessionState.getDiagram(this.id3));
    }

    @Test
    public void testGetDMNDiagramElement() {
        Assert.assertEquals((Object)this.dmnDiagram1, (Object)this.sessionState.getDMNDiagramElement(this.id1));
        Assert.assertEquals((Object)this.dmnDiagram2, (Object)this.sessionState.getDMNDiagramElement(this.id2));
        Assert.assertEquals((Object)this.dmnDiagram3, (Object)this.sessionState.getDMNDiagramElement(this.id3));
    }

    @Test
    public void testGetDiagramTuple() {
        DMNDiagramTuple tuple = this.sessionState.getDiagramTuple(this.id1);
        Assert.assertEquals((Object)this.dmnDiagram1, (Object)tuple.getDMNDiagram());
        Assert.assertEquals((Object)this.stunnerDiagram1, (Object)tuple.getStunnerDiagram());
    }

    @Test
    public void testGetDMNDiagrams() {
        List tuples = this.sessionState.getDMNDiagrams();
        Assert.assertEquals((long)3L, (long)tuples.size());
        List dmnDiagrams = tuples.stream().map(DMNDiagramTuple::getDMNDiagram).collect(Collectors.toList());
        List stunnerDiagrams = tuples.stream().map(DMNDiagramTuple::getStunnerDiagram).collect(Collectors.toList());
        Assert.assertTrue((boolean)dmnDiagrams.contains(this.dmnDiagram1));
        Assert.assertTrue((boolean)dmnDiagrams.contains(this.dmnDiagram2));
        Assert.assertTrue((boolean)dmnDiagrams.contains(this.dmnDiagram3));
        Assert.assertTrue((boolean)stunnerDiagrams.contains(this.stunnerDiagram1));
        Assert.assertTrue((boolean)stunnerDiagrams.contains(this.stunnerDiagram2));
        Assert.assertTrue((boolean)stunnerDiagrams.contains(this.stunnerDiagram3));
    }

    @Test
    public void testGetCurrentDMNDiagramElement() {
        this.sessionState.setCurrentDMNDiagramElement(this.dmnDiagram2);
        Optional actual = this.sessionState.getCurrentDMNDiagramElement();
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)this.dmnDiagram2, actual.get());
    }

    @Test
    public void testGetCurrentDMNDiagramElementWhenCurrentDiagramIsNotPresent() {
        this.sessionState.setCurrentDMNDiagramElement(null);
        Optional actual = this.sessionState.getCurrentDMNDiagramElement();
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)this.dmnDiagram1, actual.get());
    }

    @Test
    public void testGetCurrentDiagram() {
        this.sessionState.setCurrentDMNDiagramElement(this.dmnDiagram1);
        Optional actual = this.sessionState.getCurrentDiagram();
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)this.stunnerDiagram1, actual.get());
    }

    @Test
    public void testGetDRGDiagram() {
        Assert.assertEquals((Object)this.stunnerDiagram1, (Object)this.sessionState.getDRGDiagram());
    }

    @Test
    public void testGetDRGDiagramElement() {
        Assert.assertEquals((Object)this.dmnDiagram1, (Object)this.sessionState.getDRGDiagramElement());
    }

    @Test
    public void testGetDRGDiagramTuple() {
        DMNDiagramTuple tuple = this.sessionState.getDRGDiagramTuple();
        Assert.assertEquals((Object)this.dmnDiagram1, (Object)tuple.getDMNDiagram());
        Assert.assertEquals((Object)this.stunnerDiagram1, (Object)tuple.getStunnerDiagram());
    }

    @Test
    public void testClear() {
        this.sessionState.clear();
        Assert.assertEquals((long)0L, (long)this.sessionState.getDiagramsByDiagramId().size());
        Assert.assertEquals((long)0L, (long)this.sessionState.getDMNDiagramsByDiagramId().size());
    }

    @Test
    public void testGetModelDRGElements() {
        DRGElement drgElement1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement2 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement3 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement4 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement5 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement drgElement6 = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)this.dmnDiagramUtils.getDRGElements(this.stunnerDiagram1)).thenReturn(Arrays.asList(drgElement1, drgElement2));
        Mockito.when((Object)this.dmnDiagramUtils.getDRGElements(this.stunnerDiagram2)).thenReturn(Arrays.asList(drgElement3, drgElement4, drgElement5));
        Mockito.when((Object)this.dmnDiagramUtils.getDRGElements(this.stunnerDiagram3)).thenReturn(Collections.singletonList(drgElement6));
        List drgElements = this.sessionState.getModelDRGElements();
        Assert.assertTrue((boolean)drgElements.contains(drgElement1));
        Assert.assertTrue((boolean)drgElements.contains(drgElement2));
        Assert.assertTrue((boolean)drgElements.contains(drgElement3));
        Assert.assertTrue((boolean)drgElements.contains(drgElement4));
        Assert.assertTrue((boolean)drgElements.contains(drgElement5));
        Assert.assertTrue((boolean)drgElements.contains(drgElement6));
    }

    @Test
    public void testGetModelImports() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import import1 = (Import)Mockito.mock(Import.class);
        Import import2 = (Import)Mockito.mock(Import.class);
        Import import3 = (Import)Mockito.mock(Import.class);
        Import import4 = (Import)Mockito.mock(Import.class);
        Import import5 = (Import)Mockito.mock(Import.class);
        Import import6 = (Import)Mockito.mock(Import.class);
        Mockito.when((Object)definitions.getImport()).thenReturn(Arrays.asList(import1, import2, import3, import4, import5, import6));
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions(this.stunnerDiagram1)).thenReturn((Object)definitions);
        List imports = this.sessionState.getModelImports();
        Assert.assertTrue((boolean)imports.contains(import1));
        Assert.assertTrue((boolean)imports.contains(import2));
        Assert.assertTrue((boolean)imports.contains(import3));
        Assert.assertTrue((boolean)imports.contains(import4));
        Assert.assertTrue((boolean)imports.contains(import5));
        Assert.assertTrue((boolean)imports.contains(import6));
    }
}

