/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.drds;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSessionState;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDiagramsSessionTest {
    @Mock
    private ManagedInstance<DMNDiagramsSessionState> dmnDiagramsSessionStates;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private ClientSession clientSession;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Metadata metadata;
    @Mock
    private Path path;
    @Mock
    private Diagram diagram;
    private String uri = "://cyber/v.dmn";
    private Map<String, Diagram> diagramsByDiagramElementId = new HashMap<String, Diagram>();
    private Map<String, DMNDiagramElement> dmnDiagramsByDiagramElementId = new HashMap<String, DMNDiagramElement>();
    private DMNDiagramsSession dmnDiagramsSession;
    private DMNDiagramsSessionState dmnDiagramsSessionState;

    @Before
    public void setup() {
        this.dmnDiagramsSessionState = (DMNDiagramsSessionState)Mockito.spy((Object)new DMNDiagramsSessionState(this.dmnDiagramUtils));
        this.dmnDiagramsSession = (DMNDiagramsSession)Mockito.spy((Object)new DMNDiagramsSession(this.dmnDiagramsSessionStates, this.sessionManager, this.dmnDiagramUtils));
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.clientSession.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.clientSession);
        Mockito.when((Object)this.metadata.getPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)this.uri);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.dmnDiagramsSessionStates.get()).thenReturn((Object)this.dmnDiagramsSessionState);
        this.dmnDiagramsSession.setState(this.metadata, this.diagramsByDiagramElementId, this.dmnDiagramsByDiagramElementId);
    }

    @Test
    public void testDestroyState() {
        Assert.assertNotNull((Object)this.dmnDiagramsSession.getSessionState());
        this.dmnDiagramsSession.destroyState(this.metadata);
        Assert.assertNull((Object)this.dmnDiagramsSession.getSessionState());
    }

    @Test
    public void testGetCurrentSessionKey() {
        Assert.assertEquals((Object)this.uri, (Object)this.dmnDiagramsSession.getCurrentSessionKey());
    }

    @Test
    public void testAddAndRemove() {
        DMNDiagramElement dmnDiagram = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        String diagramId = "0000";
        Mockito.when((Object)dmnDiagram.getId()).thenReturn((Object)new Id("0000"));
        this.dmnDiagramsSession.add(dmnDiagram, stunnerDiagram);
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
        this.dmnDiagramsSession.remove(dmnDiagram);
        Assert.assertNull((Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
    }

    @Test
    public void testGetDMNDiagrams() {
        List<DMNDiagramTuple> expected = Arrays.asList((DMNDiagramTuple)Mockito.mock(DMNDiagramTuple.class), (DMNDiagramTuple)Mockito.mock(DMNDiagramTuple.class));
        ((DMNDiagramsSessionState)Mockito.doReturn(expected).when((Object)this.dmnDiagramsSessionState)).getDMNDiagrams();
        List actual = this.dmnDiagramsSession.getDMNDiagrams();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testSetCurrentDMNDiagramElement() {
        DMNDiagramElement diagramElement = new DMNDiagramElement(new Id(), new Name("DRG"));
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        ((DMNDiagramsSessionState)Mockito.verify((Object)this.dmnDiagramsSessionState)).setCurrentDMNDiagramElement(diagramElement);
    }

    @Test
    public void testGetCurrentDMNDiagramElement() {
        DMNDiagramElement diagramElement = new DMNDiagramElement();
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        Optional currentDMNDiagramElement = this.dmnDiagramsSession.getCurrentDMNDiagramElement();
        Assert.assertTrue((boolean)currentDMNDiagramElement.isPresent());
        Assert.assertEquals((Object)diagramElement, currentDMNDiagramElement.get());
    }

    @Test
    public void testGetCurrentDiagram() {
        DMNDiagramElement diagramElement = new DMNDiagramElement();
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        Optional currentDiagram = this.dmnDiagramsSession.getCurrentDiagram();
        Assert.assertTrue((boolean)currentDiagram.isPresent());
        Assert.assertEquals((Object)stunnerDiagram, currentDiagram.get());
    }

    @Test
    public void testGetDRGDiagram() {
        Diagram expected = (Diagram)Mockito.mock(Diagram.class);
        ((DMNDiagramsSessionState)Mockito.doReturn((Object)expected).when((Object)this.dmnDiagramsSessionState)).getDRGDiagram();
        Diagram actual = this.dmnDiagramsSession.getDRGDiagram();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDRGDiagramElement() {
        DMNDiagramElement expected = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        ((DMNDiagramsSessionState)Mockito.doReturn((Object)expected).when((Object)this.dmnDiagramsSessionState)).getDRGDiagramElement();
        DMNDiagramElement actual = this.dmnDiagramsSession.getDRGDiagramElement();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testClear() {
        DMNDiagramElement dmnDiagram = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        String diagramId = "0000";
        Mockito.when((Object)dmnDiagram.getId()).thenReturn((Object)new Id("0000"));
        this.dmnDiagramsSession.add(dmnDiagram, stunnerDiagram);
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertEquals((Object)dmnDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertEquals((Object)stunnerDiagram, (Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
        this.dmnDiagramsSession.clear();
        Assert.assertNull((Object)this.dmnDiagramsSession.getDMNDiagramElement("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagram("0000"));
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getDMNDiagram());
        Assert.assertNull((Object)this.dmnDiagramsSession.getDiagramTuple("0000").getStunnerDiagram());
    }

    @Test
    public void testGetModelDRGElements() {
        List<DRGElement> expected = Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class));
        ((DMNDiagramsSessionState)Mockito.doReturn(expected).when((Object)this.dmnDiagramsSessionState)).getModelDRGElements();
        List actual = this.dmnDiagramsSession.getModelDRGElements();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetModelImports() {
        List<Import> expected = Arrays.asList((Import)Mockito.mock(Import.class), (Import)Mockito.mock(Import.class));
        ((DMNDiagramsSessionState)Mockito.doReturn(expected).when((Object)this.dmnDiagramsSessionState)).getModelImports();
        List actual = this.dmnDiagramsSession.getModelImports();
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testIsGlobalGraphWhenItReturnsTrue() {
        DMNDiagramElement diagramElement = new DMNDiagramElement(new Id(), new Name("DRG"));
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(new DMNDiagramSelected(diagramElement));
        Assert.assertTrue((boolean)this.dmnDiagramsSession.isGlobalGraphSelected());
    }

    @Test
    public void testIsGlobalGraphWhenItReturnsFalse() {
        DMNDiagramElement diagramElement = new DMNDiagramElement(new Id(), new Name("None"));
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(new DMNDiagramSelected(diagramElement));
        Assert.assertFalse((boolean)this.dmnDiagramsSession.isGlobalGraphSelected());
    }

    @Test
    public void testGetCurrentDiagramId() {
        DMNDiagramElement diagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Diagram stunnerDiagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramSelected selectedDiagram = new DMNDiagramSelected(diagramElement);
        Id id = (Id)Mockito.mock(Id.class);
        String expectedId = "value";
        Mockito.when((Object)id.getValue()).thenReturn((Object)"value");
        Mockito.when((Object)diagramElement.getId()).thenReturn((Object)id);
        this.dmnDiagramsSession.add(diagramElement, stunnerDiagram);
        this.dmnDiagramsSession.onDMNDiagramSelected(selectedDiagram);
        String actualId = this.dmnDiagramsSession.getCurrentDiagramId();
        Assert.assertEquals((Object)"value", (Object)actualId);
    }

    @Test
    public void testsSessionStatePresentWhenItReturnsTrue() {
        DMNDiagramsSessionState sessionState = (DMNDiagramsSessionState)Mockito.mock(DMNDiagramsSessionState.class);
        ((DMNDiagramsSession)Mockito.doReturn((Object)sessionState).when((Object)this.dmnDiagramsSession)).getSessionState();
        Assert.assertTrue((boolean)this.dmnDiagramsSession.isSessionStatePresent());
    }

    @Test
    public void testsSessionStatePresentWhenItReturnsFalse() {
        ((DMNDiagramsSession)Mockito.doReturn(null).when((Object)this.dmnDiagramsSession)).getSessionState();
        Assert.assertFalse((boolean)this.dmnDiagramsSession.isSessionStatePresent());
    }
}

