/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponent;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentsItem;
import org.kie.workbench.common.dmn.client.resources.DMNSVGGlyphFactory;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionComponentsItemTest {
    @Mock
    private DecisionComponentsItem.View view;
    private DecisionComponentsItem item;

    @Before
    public void setup() {
        this.item = (DecisionComponentsItem)Mockito.spy((Object)new DecisionComponentsItem(this.view));
    }

    @Test
    public void testInit() {
        this.item.init();
        ((DecisionComponentsItem.View)Mockito.verify((Object)this.view)).init((Object)this.item);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.item.getView());
    }

    @Test
    public void testSetDecisionComponent() {
        DecisionComponent decisionComponent = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        Mockito.when((Object)decisionComponent.getIcon()).thenReturn((Object)DMNSVGGlyphFactory.DECISION_PALETTE);
        Mockito.when((Object)decisionComponent.getName()).thenReturn((Object)"name");
        Mockito.when((Object)decisionComponent.getFileName()).thenReturn((Object)"file");
        this.item.setDecisionComponent(decisionComponent);
        ((DecisionComponentsItem.View)Mockito.verify((Object)this.view)).setIcon(DMNSVGGlyphFactory.DECISION_PALETTE.getUri().asString());
        ((DecisionComponentsItem.View)Mockito.verify((Object)this.view)).setName(decisionComponent.getName());
        ((DecisionComponentsItem.View)Mockito.verify((Object)this.view)).setFile(decisionComponent.getFileName());
    }

    @Test
    public void testShow() {
        HTMLElement viewElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)viewElement);
        viewElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.item.show();
        ((DOMTokenList)Mockito.verify((Object)viewElement.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHide() {
        HTMLElement viewElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)viewElement);
        viewElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.item.hide();
        ((DOMTokenList)Mockito.verify((Object)viewElement.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testGetDrgElement() {
        DecisionComponent decisionComponent = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        Object expectedDrgElement = null;
        Mockito.when((Object)decisionComponent.getDrgElement()).thenReturn(expectedDrgElement);
        ((DecisionComponentsItem)Mockito.doReturn((Object)decisionComponent).when((Object)this.item)).getDecisionComponent();
        DRGElement actualDrgElement = this.item.getDrgElement();
        Assert.assertEquals(expectedDrgElement, (Object)actualDrgElement);
    }
}

