/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.preview;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.docks.preview.PreviewDiagramScreen;
import org.kie.workbench.common.stunner.client.widgets.presenters.Viewer;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPreview;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class PreviewDiagramScreenTest {
    @Mock
    private SessionManager clientSessionManager;
    @Mock
    private SessionDiagramPreview<AbstractSession> sessionPreview;
    @Mock
    private IsWidget previewWidget;
    @Mock
    private AbstractSession session;
    @Mock
    private PreviewDiagramScreen.View view;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Captor
    private ArgumentCaptor<SessionViewer.SessionViewerCallback> sessionViewerCallbackArgumentCaptor;
    private ManagedInstance<SessionDiagramPreview<AbstractSession>> sessionPreviews;
    private PreviewDiagramScreen tested;

    @Before
    public void setup() {
        Mockito.when((Object)this.clientSessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.sessionPreview.getView()).thenReturn((Object)this.previewWidget);
        Mockito.when((Object)this.sessionPreview.getInstance()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        this.sessionPreviews = new ManagedInstanceStub((Object[])new SessionDiagramPreview[]{this.sessionPreview});
        this.tested = (PreviewDiagramScreen)Mockito.spy((Object)new PreviewDiagramScreen(this.clientSessionManager, this.sessionPreviews, this.view, this.dmnDiagramsSession));
    }

    @Test
    public void testOnOpen() {
        this.tested.onOpen();
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).showPreview((ClientSession)Matchers.any());
    }

    @Test
    public void testOnClose() {
        this.tested.onClose();
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).closePreview();
    }

    @Test
    public void testOnCanvasSessionOpenedWhenItsTheSameSession() {
        SessionOpenedEvent event = (SessionOpenedEvent)Mockito.mock(SessionOpenedEvent.class);
        String currentSessionKey = "key1";
        String eventSessionKey = "key1";
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentSessionKey()).thenReturn((Object)"key1");
        Mockito.when((Object)this.dmnDiagramsSession.getSessionKey(this.metadata)).thenReturn((Object)"key1");
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        this.tested.onCanvasSessionOpened(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).showPreview((ClientSession)this.session);
    }

    @Test
    public void testOnCanvasSessionOpenedWhenItsNotTheSameSession() {
        SessionOpenedEvent event = (SessionOpenedEvent)Mockito.mock(SessionOpenedEvent.class);
        String currentSessionKey = "key1";
        String eventSessionKey = "key2";
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentSessionKey()).thenReturn((Object)"key1");
        Mockito.when((Object)this.dmnDiagramsSession.getSessionKey(this.metadata)).thenReturn((Object)"key2");
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        this.tested.onCanvasSessionOpened(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.never())).showPreview((ClientSession)this.session);
    }

    @Test
    public void testOnCanvasSessionDestroyedWhenItsTheSameSession() {
        SessionDestroyedEvent event = (SessionDestroyedEvent)Mockito.mock(SessionDestroyedEvent.class);
        String currentSessionKey = "key1";
        String eventSessionKey = "key1";
        Mockito.when((Object)event.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentSessionKey()).thenReturn((Object)"key1");
        Mockito.when((Object)this.dmnDiagramsSession.getSessionKey(this.metadata)).thenReturn((Object)"key1");
        this.tested.onCanvasSessionDestroyed(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).closePreview();
    }

    @Test
    public void testOnCanvasSessionDestroyedWhenItsNotTheSameSession() {
        SessionDestroyedEvent event = (SessionDestroyedEvent)Mockito.mock(SessionDestroyedEvent.class);
        String currentSessionKey = "key1";
        String eventSessionKey = "key2";
        Mockito.when((Object)event.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentSessionKey()).thenReturn((Object)"key1");
        Mockito.when((Object)this.dmnDiagramsSession.getSessionKey(this.metadata)).thenReturn((Object)"key2");
        this.tested.onCanvasSessionDestroyed(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.never())).closePreview();
    }

    @Test
    public void testOnSessionDiagramOpenedEventWhenItsTheSameSession() {
        SessionDiagramOpenedEvent event = (SessionDiagramOpenedEvent)Mockito.mock(SessionDiagramOpenedEvent.class);
        String currentSessionKey = "key1";
        String eventSessionKey = "key1";
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentSessionKey()).thenReturn((Object)"key1");
        Mockito.when((Object)this.dmnDiagramsSession.getSessionKey(this.metadata)).thenReturn((Object)"key1");
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        this.tested.onSessionDiagramOpenedEvent(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested)).showPreview((ClientSession)this.session);
    }

    @Test
    public void testOnSessionDiagramOpenedEventWhenItsNotTheSameSession() {
        SessionDiagramOpenedEvent event = (SessionDiagramOpenedEvent)Mockito.mock(SessionDiagramOpenedEvent.class);
        String currentSessionKey = "key1";
        String eventSessionKey = "key2";
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentSessionKey()).thenReturn((Object)"key1");
        Mockito.when((Object)this.dmnDiagramsSession.getSessionKey(this.metadata)).thenReturn((Object)"key2");
        Mockito.when((Object)event.getSession()).thenReturn((Object)this.session);
        this.tested.onSessionDiagramOpenedEvent(event);
        ((PreviewDiagramScreen)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.never())).showPreview((ClientSession)this.session);
    }

    @Test
    public void testView() {
        Assert.assertEquals((Object)this.view, (Object)this.tested.getWidget());
    }

    @Test
    public void testShowPreview() {
        this.tested.showPreview((ClientSession)this.session);
        ((SessionDiagramPreview)Mockito.verify(this.sessionPreview)).open(Matchers.eq((Object)this.session), Mockito.anyInt(), Mockito.anyInt(), (Viewer.Callback)this.sessionViewerCallbackArgumentCaptor.capture());
        SessionViewer.SessionViewerCallback sessionViewerCallback = (SessionViewer.SessionViewerCallback)this.sessionViewerCallbackArgumentCaptor.getValue();
        sessionViewerCallback.onSuccess();
        ((SessionDiagramPreview)Mockito.verify(this.sessionPreview, (VerificationMode)Mockito.never())).clear();
        ((PreviewDiagramScreen.View)Mockito.verify((Object)this.view)).setPreviewWidget(this.previewWidget);
    }

    @Test
    public void testClose() {
        this.tested.showPreview((ClientSession)this.session);
        this.tested.closePreview();
        ((PreviewDiagramScreen.View)Mockito.verify((Object)this.view)).clearPreviewWidget();
        ((SessionDiagramPreview)Mockito.verify(this.sessionPreview)).destroy();
    }
}

