/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.drd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.commands.clone.DMNDeepCloneProcess;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramSelected;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenuService;
import org.kie.workbench.common.dmn.client.marshaller.unmarshall.DMNUnmarshaller;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DRDContextMenuServiceTest {
    private DRDContextMenuService drdContextMenuService;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private Event<DMNDiagramSelected> selectedEvent;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private DMNDeepCloneProcess dmnDeepCloneProcess;
    @Mock
    private Graph graph;
    @Mock
    private DMNUnmarshaller dmnUnmarshaller;

    @Before
    public void setUp() {
        this.drdContextMenuService = new DRDContextMenuService(this.dmnDiagramsSession, this.factoryManager, this.selectedEvent, this.dmnDiagramUtils, this.dmnDeepCloneProcess, this.dmnUnmarshaller);
    }

    @Test
    public void testGetDiagrams() {
        DMNDiagramTuple dmnDiagramTuple = (DMNDiagramTuple)Mockito.mock(DMNDiagramTuple.class);
        Mockito.when((Object)this.dmnDiagramsSession.getDMNDiagrams()).thenReturn(Collections.singletonList(dmnDiagramTuple));
        List diagrams = this.drdContextMenuService.getDiagrams();
        Assertions.assertThat((List)diagrams).isNotEmpty();
        Assertions.assertThat((List)diagrams).hasSize(1);
        Assertions.assertThat((List)diagrams).contains((Object[])new DMNDiagramTuple[]{dmnDiagramTuple});
    }

    @Test
    public void testAddToNewDRD() {
        Collection nodes = (Collection)Mockito.mock(Collection.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Diagram drgDiagram = (Diagram)Mockito.mock(Diagram.class);
        List diagramElements = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.dmnDiagramsSession.getDRGDiagram()).thenReturn((Object)drgDiagram);
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions(drgDiagram)).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getDiagramElements()).thenReturn((Object)diagramElements);
        this.drdContextMenuService.addToNewDRD(nodes);
        ((List)Mockito.verify((Object)diagramElements, (VerificationMode)Mockito.times((int)1))).add(Matchers.any(DMNDiagramElement.class));
        ((DMNDiagramsSession)Mockito.verify((Object)this.dmnDiagramsSession, (VerificationMode)Mockito.times((int)1))).add((DMNDiagramElement)Matchers.any(DMNDiagramElement.class), (Diagram)Matchers.any(Diagram.class));
        ((Event)Mockito.verify(this.selectedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(DMNDiagramSelected.class));
    }

    @Test
    public void testAddToExistingDRD() {
        DMNDiagramTuple diagramTuple = this.mockDmnDiagramTuple();
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Node graphNode = (Node)Mockito.mock(Node.class);
        View graphNodeDefinition = (View)Mockito.mock(View.class);
        DMNDiagram dmnDiagram = (DMNDiagram)Mockito.spy((Object)new DMNDiagram());
        Collection<Node<Definition<?>, Edge>> selectedNodes = this.mockNodes();
        selectedNodes.add(graphNode);
        Mockito.when((Object)diagramTuple.getStunnerDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(selectedNodes);
        Mockito.when((Object)graphNode.getContent()).thenReturn((Object)graphNodeDefinition);
        Mockito.when((Object)graphNodeDefinition.getDefinition()).thenReturn((Object)dmnDiagram);
        this.drdContextMenuService.addToExistingDRD(diagramTuple, selectedNodes);
        ((Graph)Mockito.verify((Object)this.graph)).addNode((Node)Matchers.any(Node.class));
        ((Event)Mockito.verify(this.selectedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(DMNDiagramSelected.class));
    }

    @Test
    public void testRemoveFromCurrentDRD() {
        String nodeUUID = "UUID";
        Node node = (Node)Mockito.mock(Node.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramElement dmnDiagram = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)"UUID");
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentDiagram()).thenReturn(Optional.of(diagram));
        Mockito.when((Object)this.dmnDiagramsSession.getCurrentDMNDiagramElement()).thenReturn(Optional.of(dmnDiagram));
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)this.graph);
        this.drdContextMenuService.removeFromCurrentDRD(Collections.singleton(node));
        ((Graph)Mockito.verify((Object)this.graph, (VerificationMode)Mockito.times((int)1))).removeNode("UUID");
        ((Event)Mockito.verify(this.selectedEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(DMNDiagramSelected.class));
    }

    private Collection<Node<? extends Definition<?>, Edge>> mockNodes() {
        Node node = (Node)Mockito.mock(Node.class);
        Node clonedNode = (Node)Mockito.mock(Node.class);
        View content = (View)Mockito.mock(View.class);
        View clonedContent = (View)Mockito.mock(View.class);
        Bounds bounds = (Bounds)Mockito.mock(Bounds.class);
        Bound upperLeft = (Bound)Mockito.mock(Bound.class);
        Bound lowerRight = (Bound)Mockito.mock(Bound.class);
        InputData inputData = (InputData)Mockito.spy((Object)new InputData());
        InputData clonedInputData = (InputData)Mockito.spy((Object)new InputData());
        ArrayList nodes = new ArrayList();
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)inputData);
        Mockito.when((Object)content.getBounds()).thenReturn((Object)bounds);
        Mockito.when((Object)bounds.getUpperLeft()).thenReturn((Object)upperLeft);
        Mockito.when((Object)bounds.getLowerRight()).thenReturn((Object)lowerRight);
        Mockito.when((Object)this.factoryManager.newElement(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)clonedNode);
        Mockito.when((Object)clonedNode.asNode()).thenReturn((Object)clonedNode);
        Mockito.when((Object)clonedNode.getContent()).thenReturn((Object)clonedContent);
        Mockito.when((Object)clonedContent.getDefinition()).thenReturn((Object)clonedInputData);
        Mockito.when((Object)this.dmnDeepCloneProcess.clone(Matchers.eq((Object)inputData))).thenReturn((Object)clonedInputData);
        nodes.add(node);
        return nodes;
    }

    private DMNDiagramTuple mockDmnDiagramTuple() {
        DMNDiagramTuple dmnDiagramTuple = (DMNDiagramTuple)Mockito.mock(DMNDiagramTuple.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        DMNDiagramElement dmnDiagram = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        Id diagramId = new Id("DIAGRAM_ID");
        Mockito.when((Object)dmnDiagramTuple.getStunnerDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)dmnDiagramTuple.getDMNDiagram()).thenReturn((Object)dmnDiagram);
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)dmnDiagram.getId()).thenReturn((Object)diagramId);
        return dmnDiagramTuple;
    }
}

