/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.drd;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLBodyElement;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagramElement;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramTuple;
import org.kie.workbench.common.dmn.client.docks.navigator.drds.DMNDiagramsSession;
import org.kie.workbench.common.dmn.client.editors.contextmenu.ContextMenu;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenu;
import org.kie.workbench.common.dmn.client.editors.drd.DRDContextMenuService;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DRDContextMenuTest {
    private DRDContextMenu drdContextMenu;
    @Mock
    private ContextMenu contextMenu;
    @Mock
    private ClientTranslationService translationService;
    @Mock
    private DRDContextMenuService drdContextMenuService;
    @Mock
    private org.kie.workbench.common.stunner.core.graph.Node<? extends Definition<?>, Edge> node;
    @Mock
    private HTMLElement element;
    @Mock
    private CSSStyleDeclaration styleDeclaration;
    @Mock
    private HTMLDocument htmlDocument;
    @Mock
    private HTMLBodyElement body;
    @Mock
    private DMNDiagramsSession dmnDiagramsSession;

    @Before
    public void setUp() {
        this.drdContextMenu = new DRDContextMenu(this.contextMenu, this.translationService, this.drdContextMenuService, this.dmnDiagramsSession);
    }

    @Test
    public void testGetTitle() {
        this.drdContextMenu.getTitle();
        ((ClientTranslationService)Mockito.verify((Object)this.translationService)).getValue((String)Matchers.eq((Object)"DRDActions.ContextMenu.Title"));
    }

    @Test
    public void testGetElement() {
        this.drdContextMenu.getElement();
        ((ContextMenu)Mockito.verify((Object)this.contextMenu)).getElement();
    }

    @Test
    public void testShow() {
        this.drdContextMenu.show(new ArrayList());
        ((ContextMenu)Mockito.verify((Object)this.contextMenu)).show((Consumer)Matchers.any(Consumer.class));
    }

    @Test
    public void testContextMenuHandler() {
        DMNDiagramTuple diagramTuple1 = new DMNDiagramTuple((Diagram)Mockito.mock(Diagram.class), new DMNDiagramElement());
        DMNDiagramTuple diagramTuple2 = new DMNDiagramTuple((Diagram)Mockito.mock(Diagram.class), new DMNDiagramElement());
        List<DMNDiagramTuple> diagrams = Arrays.asList(diagramTuple1, diagramTuple2);
        DMNDiagramElement diagramElement = (DMNDiagramElement)Mockito.mock(DMNDiagramElement.class);
        PowerMockito.when((Object)this.translationService.getValue(Matchers.anyString())).thenReturn((Object)"");
        PowerMockito.when((Object)this.drdContextMenuService.getDiagrams()).thenReturn(diagrams);
        PowerMockito.when((Object)this.dmnDiagramsSession.getDRGDiagramElement()).thenReturn((Object)diagramElement);
        PowerMockito.when((Object)this.dmnDiagramsSession.getCurrentDMNDiagramElement()).thenReturn(Optional.of(diagramElement));
        this.drdContextMenu.setDRDContextMenuHandler(this.contextMenu, Collections.singletonList(this.node));
        ((ContextMenu)Mockito.verify((Object)this.contextMenu)).setHeaderMenu(Matchers.anyString(), Matchers.anyString());
        ((ContextMenu)Mockito.verify((Object)this.contextMenu, (VerificationMode)Mockito.times((int)4))).addTextMenuItem(Matchers.anyString(), Matchers.anyBoolean(), (Command)Matchers.any(Command.class));
    }

    @Test
    public void testAppendContextMenuToTheDOM() {
        PowerMockito.when((Object)this.contextMenu.getElement()).thenReturn((Object)this.element);
        Whitebox.setInternalState((Object)this.element, (String)"style", (Object)this.styleDeclaration);
        Whitebox.setInternalState(DomGlobal.class, (String)"document", (Object)this.htmlDocument);
        Whitebox.setInternalState((Object)this.htmlDocument, (String)"body", (Object)this.body);
        this.drdContextMenu.appendContextMenuToTheDOM(10.0, 10.0);
        ((HTMLBodyElement)Mockito.verify((Object)this.body)).appendChild((Node)Matchers.any(HTMLElement.class));
    }
}

