/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.BaseDecisionTableEditorDefinitionTest;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableEditorDefinitionEnricher;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DecisionTableEditorDefinitionEnricherTest
extends BaseDecisionTableEditorDefinitionTest {
    private static final String NODE_UUID = UUID.uuid();
    private static final String INPUT_DATA_NAME_1 = "z-inputData1";
    private static final String INPUT_DATA_NAME_2 = "a-inputData2";
    private static final QName INPUT_DATA_QNAME_1 = BuiltInType.STRING.asQName();
    private static final QName INPUT_DATA_QNAME_2 = BuiltInType.NUMBER.asQName();
    private static final String DECISION_NAME_1 = "b-decision1";
    private static final String DEFAULT_OUTPUT_NAME = "output-1";
    private static final String TYPE_PERSON = "tPerson";
    private static final String TYPE_COMPANY = "tCompany";
    private static final QName DECISION_QNAME_1 = BuiltInType.STRING.asQName();
    private static final QName OUTPUT_DATA_QNAME = BuiltInType.DATE.asQName();
    private static final QName T_ADDRESS_QNAME = new QName("", "tAddress");
    private DMNDiagram diagram;
    private InputData inputData1;
    private InputData inputData2;
    private Decision decision1;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.diagram = new DMNDiagram();
        this.inputData1 = new InputData();
        this.inputData2 = new InputData();
        this.decision1 = new Decision();
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithDecision() {
        this.setupGraphWithDiagram();
        this.setupGraphWithDecision();
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(1);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo(DECISION_NAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)DECISION_QNAME_1);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputData() {
        this.setupGraphWithDiagram();
        this.setupGraphWithInputData();
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_1);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithDecisionAndInputData() {
        this.setupGraphWithDiagram();
        this.setupGraphWithDecision();
        this.setupGraphWithInputData();
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(3);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo(DECISION_NAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)DECISION_QNAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(2)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_1);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputDataAndSimpleCustomType() {
        this.setupGraphWithDiagram();
        this.setupGraphWithInputData();
        Definitions definitions = this.diagram.getDefinitions();
        String simpleItemDefinitionName = "tSmurf";
        QName simpleItemDefinitionTypeRef = new QName("", BuiltInType.DATE.getName());
        ItemDefinition simpleItemDefinition = new ItemDefinition();
        simpleItemDefinition.setName(new Name("tSmurf"));
        simpleItemDefinition.setTypeRef(simpleItemDefinitionTypeRef);
        definitions.getItemDefinition().add(simpleItemDefinition);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_1);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)simpleItemDefinitionTypeRef);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputDataAndComplexCustomType() {
        this.setupGraphWithDiagram();
        this.setupGraphWithInputData();
        Definitions definitions = this.diagram.getDefinitions();
        String complexItemDefinitionName = "tSmurf";
        String complexItemDefinitionPart1Name = "tDateOfBirth";
        String complexItemDefinitionPart2Name = "tIsBlue";
        final QName complexItemDefinitionPart1TypeRef = new QName("", BuiltInType.DATE.getName());
        final QName complexItemDefinitionPart2TypeRef = new QName("", BuiltInType.BOOLEAN.getName());
        ItemDefinition complexItemDefinition = new ItemDefinition();
        complexItemDefinition.setName(new Name("tSmurf"));
        complexItemDefinition.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tDateOfBirth"));
                this.setTypeRef(complexItemDefinitionPart1TypeRef);
            }
        });
        complexItemDefinition.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tIsBlue"));
                this.setTypeRef(complexItemDefinitionPart2TypeRef);
            }
        });
        definitions.getItemDefinition().add(complexItemDefinition);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(3);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.tDateOfBirth");
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)complexItemDefinitionPart1TypeRef);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(2)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.tIsBlue");
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression().getTypeRef()).isEqualTo((Object)complexItemDefinitionPart2TypeRef);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithInputDataAndRecursiveCustomType() {
        this.setupGraphWithDiagram();
        this.setupGraphWithInputData();
        Definitions definitions = this.diagram.getDefinitions();
        String tSmurfName = "tSmurf";
        String tDateOfBirthName = "tDateOfBirth";
        String tIsBlueName = "tIsBlue";
        String tParentName = "tParent";
        final QName dateBuiltInType = new QName("", BuiltInType.DATE.getName());
        final QName booleanBuiltInType = new QName("", BuiltInType.BOOLEAN.getName());
        final QName parentCustomType = new QName("", "tSmurf");
        ItemDefinition tSmurfCustomDataType = new ItemDefinition();
        tSmurfCustomDataType.setName(new Name("tSmurf"));
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tDateOfBirth"));
                this.setTypeRef(dateBuiltInType);
            }
        });
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tIsBlue"));
                this.setTypeRef(booleanBuiltInType);
            }
        });
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("tParent"));
                this.setTypeRef(parentCustomType);
            }
        });
        definitions.getItemDefinition().add(tSmurfCustomDataType);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(4);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.tDateOfBirth");
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)dateBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(2)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.tIsBlue");
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression().getTypeRef()).isEqualTo((Object)booleanBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(3)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.tParent");
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression().getTypeRef()).isEqualTo((Object)parentCustomType);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithMultipleHierarchyCustomTypes() {
        this.setupGraphWithDiagram();
        this.setupGraphWithInputData();
        Definitions definitions = this.diagram.getDefinitions();
        String tSmurf = "tSmurf";
        String tSmurfAddress = "tSmurfAddress";
        final QName dateBuiltInType = new QName("", BuiltInType.DATE.getName());
        final QName stringBuiltInType = new QName("", BuiltInType.STRING.getName());
        final ItemDefinition tSmurfAddressCustomDataType = new ItemDefinition();
        tSmurfAddressCustomDataType.setName(new Name("tSmurfAddress"));
        tSmurfAddressCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("line1"));
                this.setTypeRef(stringBuiltInType);
            }
        });
        tSmurfAddressCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("line2"));
                this.setTypeRef(stringBuiltInType);
            }
        });
        ItemDefinition tSmurfCustomDataType = new ItemDefinition();
        tSmurfCustomDataType.setName(new Name("tSmurf"));
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("dob"));
                this.setTypeRef(dateBuiltInType);
            }
        });
        tSmurfCustomDataType.getItemComponent().add(new ItemDefinition(){
            {
                this.setName(new Name("address"));
                this.getItemComponent().add(tSmurfAddressCustomDataType);
            }
        });
        definitions.getItemDefinition().add(tSmurfCustomDataType);
        QName inputData1TypeRef = new QName("", "tSmurf");
        this.inputData1.getVariable().setTypeRef(inputData1TypeRef);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(NODE_UUID), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(4);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo(INPUT_DATA_NAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression().getTypeRef()).isEqualTo((Object)INPUT_DATA_QNAME_2);
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(1)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.address.tSmurfAddress.line1");
        Assertions.assertThat((Object)((InputClause)input.get(1)).getInputExpression().getTypeRef()).isEqualTo((Object)stringBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(2)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.address.tSmurfAddress.line2");
        Assertions.assertThat((Object)((InputClause)input.get(2)).getInputExpression().getTypeRef()).isEqualTo((Object)stringBuiltInType);
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(3)).getInputExpression().getText().getValue()).isEqualTo("z-inputData1.dob");
        Assertions.assertThat((Object)((InputClause)input.get(3)).getInputExpression().getTypeRef()).isEqualTo((Object)dateBuiltInType);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    private void setupGraphWithDiagram() {
        NodeImpl diagramNode = new NodeImpl(UUID.uuid());
        DefinitionImpl diagramDefinition = new DefinitionImpl((Object)this.diagram);
        diagramNode.setContent((Object)diagramDefinition);
        this.graph.addNode((Node)diagramNode);
    }

    private void setupGraphWithDecision() {
        Node targetNode = this.graph.getNode(NODE_UUID);
        if (Objects.isNull(targetNode)) {
            targetNode = new NodeImpl(NODE_UUID);
            this.graph.addNode(targetNode);
        }
        NodeImpl sourceNode1 = new NodeImpl(UUID.uuid());
        this.decision1.getName().setValue(DECISION_NAME_1);
        QName decision1QName = new QName("", BuiltInType.STRING.getName());
        this.decision1.getVariable().setTypeRef(decision1QName);
        DefinitionImpl sourceNode1Definition = new DefinitionImpl((Object)this.decision1);
        sourceNode1.setContent((Object)sourceNode1Definition);
        EdgeImpl edge1 = new EdgeImpl(UUID.uuid());
        edge1.setTargetNode(targetNode);
        edge1.setSourceNode((Node)sourceNode1);
        targetNode.getInEdges().add(edge1);
        sourceNode1.getOutEdges().add(edge1);
        this.graph.addNode((Node)sourceNode1);
    }

    private void setupGraphWithInputData() {
        Node targetNode = this.graph.getNode(NODE_UUID);
        if (Objects.isNull(targetNode)) {
            targetNode = new NodeImpl(NODE_UUID);
            this.graph.addNode(targetNode);
        }
        NodeImpl sourceNode1 = new NodeImpl(UUID.uuid());
        NodeImpl sourceNode2 = new NodeImpl(UUID.uuid());
        this.inputData1.getName().setValue(INPUT_DATA_NAME_1);
        this.inputData2.getName().setValue(INPUT_DATA_NAME_2);
        QName inputData1QName = new QName("", BuiltInType.STRING.getName());
        QName inputData2QName = new QName("", BuiltInType.NUMBER.getName());
        this.inputData1.getVariable().setTypeRef(inputData1QName);
        this.inputData2.getVariable().setTypeRef(inputData2QName);
        DefinitionImpl sourceNode1Definition = new DefinitionImpl((Object)this.inputData1);
        DefinitionImpl sourceNode2Definition = new DefinitionImpl((Object)this.inputData2);
        sourceNode1.setContent((Object)sourceNode1Definition);
        sourceNode2.setContent((Object)sourceNode2Definition);
        EdgeImpl edge1 = new EdgeImpl(UUID.uuid());
        EdgeImpl edge2 = new EdgeImpl(UUID.uuid());
        edge1.setTargetNode(targetNode);
        edge1.setSourceNode((Node)sourceNode1);
        edge2.setTargetNode(targetNode);
        edge2.setSourceNode((Node)sourceNode2);
        targetNode.getInEdges().add(edge1);
        targetNode.getInEdges().add(edge2);
        sourceNode1.getOutEdges().add(edge1);
        sourceNode2.getOutEdges().add(edge2);
        this.graph.addNode((Node)sourceNode1);
        this.graph.addNode((Node)sourceNode2);
    }

    @Test
    public void testModelEnrichmentWhenTopLevelDecisionTableWithoutInputData() {
        String uuid = UUID.uuid();
        NodeImpl node = new NodeImpl(uuid);
        this.graph.addNode((Node)node);
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.of(uuid), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenParentIsContextEntry() {
        Decision decision = (Decision)Mockito.mock(Decision.class);
        String name = "context-entry";
        Context context = new Context();
        ContextEntry contextEntry = new ContextEntry();
        context.getContextEntry().add(contextEntry);
        contextEntry.setVariable(new InformationItem(new Id(), new Description(), new Name("context-entry"), OUTPUT_DATA_QNAME));
        Optional oModel = this.definition.getModelClass();
        ((DecisionTable)oModel.get()).setParent((DMNModelInstrumentedBase)contextEntry);
        contextEntry.setParent((DMNModelInstrumentedBase)context);
        context.setParent((DMNModelInstrumentedBase)decision);
        Mockito.when((Object)decision.asDMNModelInstrumentedBase()).thenReturn((Object)contextEntry);
        this.definition.enrich(Optional.empty(), (HasExpression)decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo(DEFAULT_OUTPUT_NAME);
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenParentIsBKM() {
        FunctionDefinition functionDefinition = (FunctionDefinition)Mockito.mock(FunctionDefinition.class);
        DMNModelInstrumentedBase dmnModelInstrumentedBase = (DMNModelInstrumentedBase)Mockito.mock(DMNModelInstrumentedBase.class);
        BusinessKnowledgeModel businessKnowledgeModel = new BusinessKnowledgeModel();
        businessKnowledgeModel.setVariable(new InformationItemPrimary(new Id(), new Name(), OUTPUT_DATA_QNAME));
        businessKnowledgeModel.setEncapsulatedLogic(functionDefinition);
        Optional oModel = this.definition.getModelClass();
        ((DecisionTable)oModel.get()).setParent((DMNModelInstrumentedBase)functionDefinition);
        Mockito.when((Object)functionDefinition.asDMNModelInstrumentedBase()).thenReturn((Object)dmnModelInstrumentedBase);
        Mockito.when((Object)dmnModelInstrumentedBase.getParent()).thenReturn((Object)businessKnowledgeModel);
        this.definition.enrich(Optional.empty(), (HasExpression)functionDefinition, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo(DEFAULT_OUTPUT_NAME);
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenParentIsContextEntryDefaultResult() {
        String name = "decision";
        Context context = new Context();
        ContextEntry contextEntry = new ContextEntry();
        context.getContextEntry().add(contextEntry);
        contextEntry.setParent((DMNModelInstrumentedBase)context);
        context.setParent((DMNModelInstrumentedBase)this.decision);
        this.decision.setName(new Name("decision"));
        this.decision.getVariable().setTypeRef(OUTPUT_DATA_QNAME);
        Optional oModel = this.definition.getModelClass();
        ((DecisionTable)oModel.get()).setParent((DMNModelInstrumentedBase)contextEntry);
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo(DEFAULT_OUTPUT_NAME);
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenParentIsNestedContextEntryDefaultResult() {
        Decision decision = (Decision)Mockito.mock(Decision.class);
        String name = "context-entry";
        Context innerContext = new Context();
        ContextEntry innerContextEntry = new ContextEntry();
        innerContext.getContextEntry().add(innerContextEntry);
        innerContextEntry.setParent((DMNModelInstrumentedBase)innerContext);
        Context outerContext = new Context();
        ContextEntry outerContextEntry = new ContextEntry();
        outerContext.getContextEntry().add(outerContextEntry);
        outerContextEntry.setParent((DMNModelInstrumentedBase)outerContext);
        innerContext.setParent((DMNModelInstrumentedBase)outerContextEntry);
        outerContext.setParent((DMNModelInstrumentedBase)decision);
        outerContextEntry.setVariable(new InformationItem(new Id(), new Description(), new Name("context-entry"), OUTPUT_DATA_QNAME));
        Mockito.when((Object)decision.asDMNModelInstrumentedBase()).thenReturn((Object)outerContextEntry);
        Optional oModel = this.definition.getModelClass();
        ((DecisionTable)oModel.get()).setParent((DMNModelInstrumentedBase)innerContextEntry);
        this.definition.enrich(Optional.empty(), (HasExpression)decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo(DEFAULT_OUTPUT_NAME);
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenHasExpressionIsHasVariable() {
        this.decision.setVariable(new InformationItemPrimary(new Id(), new Name(), OUTPUT_DATA_QNAME));
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo(DEFAULT_OUTPUT_NAME);
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)OUTPUT_DATA_QNAME);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenHasExpressionIsNotHasVariable() {
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo(DEFAULT_OUTPUT_NAME);
        Assertions.assertThat((Object)((OutputClause)output.get(0)).getTypeRef()).isEqualTo((Object)BuiltInType.UNDEFINED.asQName());
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testModelEnrichmentWhenDecisionTypeRefIsStructureWithMultipleFields() {
        DMNGraphUtils dmnGraphUtils = (DMNGraphUtils)Mockito.mock(DMNGraphUtils.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        InformationItemPrimary informationItemPrimary = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        ItemDefinition tPerson = this.mockTPersonStructure();
        Mockito.when((Object)dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(Collections.singletonList(tPerson));
        Mockito.when((Object)hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        Mockito.when((Object)decision.getVariable()).thenReturn((Object)informationItemPrimary);
        Mockito.when((Object)informationItemPrimary.getTypeRef()).thenReturn((Object)new QName("", TYPE_PERSON));
        DecisionTableEditorDefinitionEnricher enricher = new DecisionTableEditorDefinitionEnricher(null, dmnGraphUtils, this.itemDefinitionUtils);
        Optional oModel = this.definition.getModelClass();
        DecisionTable model = (DecisionTable)oModel.get();
        enricher.buildOutputClausesByDataType(hasExpression, model, new DecisionRule());
        List outputClauses = model.getOutput();
        Assertions.assertThat((int)outputClauses.size()).isEqualTo(2);
        OutputClause outputClause1 = (OutputClause)outputClauses.get(0);
        OutputClause outputClause2 = (OutputClause)outputClauses.get(1);
        Assert.assertEquals((Object)"age", (Object)outputClause1.getName());
        Assert.assertEquals((Object)BuiltInType.NUMBER.asQName(), (Object)outputClause1.getTypeRef());
        Assert.assertEquals((Object)"name", (Object)outputClause2.getName());
        Assert.assertEquals((Object)BuiltInType.STRING.asQName(), (Object)outputClause2.getTypeRef());
    }

    @Test
    public void testModelEnrichmentWhenDecisionTypeRefIsStructureAndOneSubfieldIsStructure() {
        DMNGraphUtils dmnGraphUtils = (DMNGraphUtils)Mockito.mock(DMNGraphUtils.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        InformationItemPrimary informationItemPrimary = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        ItemDefinition tCompany = this.mockTCompanyStructure();
        Mockito.when((Object)dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(Collections.singletonList(tCompany));
        Mockito.when((Object)hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        Mockito.when((Object)decision.getVariable()).thenReturn((Object)informationItemPrimary);
        Mockito.when((Object)informationItemPrimary.getTypeRef()).thenReturn((Object)new QName("", TYPE_COMPANY));
        DecisionTableEditorDefinitionEnricher enricher = new DecisionTableEditorDefinitionEnricher(null, dmnGraphUtils, this.itemDefinitionUtils);
        Optional oModel = this.definition.getModelClass();
        DecisionTable model = (DecisionTable)oModel.get();
        enricher.buildOutputClausesByDataType(hasExpression, model, new DecisionRule());
        List outputClauses = model.getOutput();
        Assertions.assertThat((int)outputClauses.size()).isEqualTo(2);
        OutputClause outputClause1 = (OutputClause)outputClauses.get(0);
        OutputClause outputClause2 = (OutputClause)outputClauses.get(1);
        Assert.assertEquals((Object)"address", (Object)outputClause1.getName());
        Assert.assertEquals((Object)BuiltInType.ANY.asQName(), (Object)outputClause1.getTypeRef());
        Assert.assertEquals((Object)"name", (Object)outputClause2.getName());
        Assert.assertEquals((Object)BuiltInType.STRING.asQName(), (Object)outputClause2.getTypeRef());
    }

    private ItemDefinition mockTCompanyStructure() {
        ItemDefinition tCompany = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition name = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition tAddress = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)name.getName()).thenReturn((Object)new Name("name"));
        Mockito.when((Object)name.getTypeRef()).thenReturn((Object)BuiltInType.STRING.asQName());
        Mockito.when((Object)name.getItemComponent()).thenReturn(Collections.emptyList());
        Mockito.when((Object)tAddress.getName()).thenReturn((Object)new Name("address"));
        Mockito.when((Object)tAddress.getTypeRef()).thenReturn((Object)T_ADDRESS_QNAME);
        Mockito.when((Object)tAddress.getItemComponent()).thenReturn(Collections.singletonList(name));
        Mockito.when((Object)tCompany.getName()).thenReturn((Object)new Name(TYPE_COMPANY));
        Mockito.when((Object)tCompany.getTypeRef()).thenReturn(null);
        Mockito.when((Object)tCompany.getItemComponent()).thenReturn(Arrays.asList(name, tAddress));
        return tCompany;
    }

    @Test
    public void testModelEnrichmentWhenDecisionTypeRefIsStructureWithNoFields() {
        DMNGraphUtils dmnGraphUtils = (DMNGraphUtils)Mockito.mock(DMNGraphUtils.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Decision decision = (Decision)Mockito.mock(Decision.class);
        InformationItemPrimary informationItemPrimary = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        ItemDefinition tPerson = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        QName tPersonTypeRef = new QName("", TYPE_PERSON);
        Mockito.when((Object)tPerson.getName()).thenReturn((Object)new Name(TYPE_PERSON));
        Mockito.when((Object)tPerson.getTypeRef()).thenReturn((Object)tPersonTypeRef);
        Mockito.when((Object)tPerson.getItemComponent()).thenReturn(Collections.emptyList());
        Mockito.when((Object)dmnGraphUtils.getModelDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(Collections.singletonList(tPerson));
        Mockito.when((Object)hasExpression.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        Mockito.when((Object)decision.getVariable()).thenReturn((Object)informationItemPrimary);
        Mockito.when((Object)informationItemPrimary.getTypeRef()).thenReturn((Object)tPersonTypeRef);
        DecisionTableEditorDefinitionEnricher enricher = new DecisionTableEditorDefinitionEnricher(null, dmnGraphUtils, this.itemDefinitionUtils);
        Optional oModel = this.definition.getModelClass();
        DecisionTable model = (DecisionTable)oModel.get();
        enricher.buildOutputClausesByDataType(hasExpression, model, new DecisionRule());
        List outputClauses = model.getOutput();
        Assertions.assertThat((int)outputClauses.size()).isEqualTo(1);
        OutputClause outputClause = (OutputClause)outputClauses.get(0);
        Assert.assertEquals((Object)DEFAULT_OUTPUT_NAME, (Object)outputClause.getName());
        Assert.assertEquals((Object)tPersonTypeRef, (Object)outputClause.getTypeRef());
    }

    @Test
    public void testAddInputClauseRequirement() {
        ArrayList inputClauseRequirements = new ArrayList();
        String inputData = "InputData";
        DecisionTableEditorDefinitionEnricher enricher = new DecisionTableEditorDefinitionEnricher(null, null, this.itemDefinitionUtils);
        ItemDefinition tPerson = this.mockTPersonStructure();
        enricher.addInputClauseRequirement(tPerson, inputClauseRequirements, "InputData");
        Assert.assertEquals((long)2L, (long)inputClauseRequirements.size());
        DecisionTableEditorDefinitionEnricher.ClauseRequirement inputClause1 = (DecisionTableEditorDefinitionEnricher.ClauseRequirement)inputClauseRequirements.get(0);
        DecisionTableEditorDefinitionEnricher.ClauseRequirement inputClause2 = (DecisionTableEditorDefinitionEnricher.ClauseRequirement)inputClauseRequirements.get(1);
        Assert.assertEquals((Object)"InputData.name", (Object)inputClause1.text);
        Assert.assertEquals((Object)BuiltInType.STRING.getName(), (Object)inputClause1.typeRef.getLocalPart());
        Assert.assertEquals((Object)"InputData.age", (Object)inputClause2.text);
        Assert.assertEquals((Object)BuiltInType.NUMBER.getName(), (Object)inputClause2.typeRef.getLocalPart());
    }

    private ItemDefinition mockTPersonStructure() {
        ItemDefinition tPerson = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition name = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition age = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)name.getName()).thenReturn((Object)new Name("name"));
        Mockito.when((Object)name.getTypeRef()).thenReturn((Object)BuiltInType.STRING.asQName());
        Mockito.when((Object)name.getItemComponent()).thenReturn(Collections.emptyList());
        Mockito.when((Object)age.getName()).thenReturn((Object)new Name("age"));
        Mockito.when((Object)age.getTypeRef()).thenReturn((Object)BuiltInType.NUMBER.asQName());
        Mockito.when((Object)age.getItemComponent()).thenReturn(Collections.emptyList());
        Mockito.when((Object)tPerson.getName()).thenReturn((Object)new Name(TYPE_PERSON));
        Mockito.when((Object)tPerson.getTypeRef()).thenReturn(null);
        Mockito.when((Object)tPerson.getItemComponent()).thenReturn(Arrays.asList(name, age));
        return tPerson;
    }

    @Test
    public void testAddInputClauseRequirementWhenDataTypeIsStructureAndDontHaveFields() {
        ItemDefinition tPerson = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String inputData = "InputData";
        ArrayList inputClauseRequirements = new ArrayList();
        ItemDefinitionUtils itemDefinitionUtils = new ItemDefinitionUtils((DMNGraphUtils)Mockito.mock(DMNGraphUtils.class));
        DecisionTableEditorDefinitionEnricher enricher = new DecisionTableEditorDefinitionEnricher(null, null, itemDefinitionUtils);
        Mockito.when((Object)tPerson.getName()).thenReturn((Object)new Name(TYPE_PERSON));
        Mockito.when((Object)tPerson.getTypeRef()).thenReturn(null);
        Mockito.when((Object)tPerson.getItemComponent()).thenReturn(Collections.emptyList());
        enricher.addInputClauseRequirement(tPerson, inputClauseRequirements, "InputData");
        Assert.assertEquals((long)1L, (long)inputClauseRequirements.size());
        Assert.assertEquals((Object)"InputData", (Object)((DecisionTableEditorDefinitionEnricher.ClauseRequirement)inputClauseRequirements.get((int)0)).text);
        Assert.assertEquals((Object)TYPE_PERSON, (Object)((DecisionTableEditorDefinitionEnricher.ClauseRequirement)inputClauseRequirements.get((int)0)).typeRef.getLocalPart());
    }

    @Test
    public void testComputingClauseNameWithoutModelRef() {
        ItemDefinition itemComponent = new ItemDefinition();
        itemComponent.setName(new Name("model.age"));
        itemComponent.setAllowOnlyVisualChange(true);
        Assert.assertEquals((Object)"age", (Object)new DecisionTableEditorDefinitionEnricher(null, null, null).computeClauseName(itemComponent));
    }

    @Test
    public void testComputingClauseNameWithoutModelRefWhenModelRefHasMultipleLevels() {
        ItemDefinition itemComponent = new ItemDefinition();
        itemComponent.setName(new Name("a.b.c.age"));
        itemComponent.setAllowOnlyVisualChange(true);
        Assert.assertEquals((Object)"age", (Object)new DecisionTableEditorDefinitionEnricher(null, null, null).computeClauseName(itemComponent));
    }

    @Test
    public void testComputingClauseNameWithoutModelRefWhenModelRefAlreadyMissing() {
        ItemDefinition itemComponent = new ItemDefinition();
        itemComponent.setName(new Name("age"));
        itemComponent.setAllowOnlyVisualChange(true);
        Assert.assertEquals((Object)"age", (Object)new DecisionTableEditorDefinitionEnricher(null, null, null).computeClauseName(itemComponent));
    }

    @Test
    public void testComputingClauseNameWithoutModelRefWhenLocalPartEndsWithDot() {
        ItemDefinition itemComponent = new ItemDefinition();
        itemComponent.setName(new Name("age."));
        itemComponent.setAllowOnlyVisualChange(true);
        Assert.assertEquals((Object)"age.", (Object)new DecisionTableEditorDefinitionEnricher(null, null, null).computeClauseName(itemComponent));
    }
}

