/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.BaseDecisionTableEditorDefinitionTest;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableGrid;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DecisionTableEditorDefinitionTest
extends BaseDecisionTableEditorDefinitionTest {
    @Test
    public void testType() {
        Assertions.assertThat((Comparable)this.definition.getType()).isEqualTo((Object)ExpressionType.DECISION_TABLE);
    }

    @Test
    public void testName() {
        Assertions.assertThat((String)this.definition.getName()).isEqualTo("ExpressionEditor.DecisionTableExpressionType");
    }

    @Test
    public void testModelDefinition() {
        Optional oModel = this.definition.getModelClass();
        Assertions.assertThat((Optional)oModel).isPresent();
    }

    @Test
    public void testModelEnrichment() {
        Optional oModel = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.decision, oModel);
        DecisionTable model = (DecisionTable)oModel.get();
        this.assertBasicEnrichment(model);
        this.assertStandardInputClauseEnrichment(model);
        this.assertStandardOutputClauseEnrichment(model);
        this.assertStandardDecisionRuleEnrichment(model);
        this.assertParentHierarchyEnrichment(model);
    }

    @Test
    public void testEditor() {
        Optional oEditor = this.definition.getEditor(this.parent, Optional.empty(), (HasExpression)this.decision, this.hasName, false, 0);
        Assertions.assertThat((Optional)oEditor).isPresent();
        GridWidget editor = (GridWidget)oEditor.get();
        Assertions.assertThat((Object)editor).isInstanceOf(DecisionTableGrid.class);
    }

    @Test
    public void testIsUserSelectable() {
        Assertions.assertThat((boolean)this.definition.isUserSelectable()).isTrue();
    }
}

