/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;

public class KindUtilitiesTest {
    private FunctionDefinition function;

    @Before
    public void setup() {
        this.function = new FunctionDefinition();
    }

    @Test
    public void testGetKindNoneSet() {
        Assertions.assertThat((Comparable)KindUtilities.getKind((FunctionDefinition)this.function)).isEqualTo((Object)FunctionDefinition.Kind.FEEL);
    }

    @Test
    public void testGetKindWhenSet() {
        this.function.setKind(FunctionDefinition.Kind.FEEL);
        Assertions.assertThat((Comparable)KindUtilities.getKind((FunctionDefinition)this.function)).isEqualTo((Object)FunctionDefinition.Kind.FEEL);
    }

    @Test
    public void testSetKindFEEL() {
        this.assertSetKind(FunctionDefinition.Kind.FEEL);
    }

    @Test
    public void testSetKindJAVA() {
        this.assertSetKind(FunctionDefinition.Kind.JAVA);
    }

    @Test
    public void testSetKindPMML() {
        this.assertSetKind(FunctionDefinition.Kind.PMML);
    }

    @Test
    public void testSetKindNullWithNSSet() {
        KindUtilities.setKind((FunctionDefinition)this.function, null);
        Assertions.assertThat((Comparable)this.function.getKind()).isNull();
    }

    @Test
    public void testSetKindNullWithNSNotSet() {
        KindUtilities.setKind((FunctionDefinition)this.function, null);
        Assertions.assertThat((Comparable)this.function.getKind()).isNull();
    }

    private void assertSetKind(FunctionDefinition.Kind kind) {
        KindUtilities.setKind((FunctionDefinition)this.function, (FunctionDefinition.Kind)kind);
        Assertions.assertThat((String)this.function.getKind().code()).isEqualTo(kind.code());
    }
}

