/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.kindselector;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.kindselector.HasKindSelectControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.kindselector.KindPopoverImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.kindselector.KindPopoverView;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KindPopoverImplTest {
    @Mock
    private KindPopoverView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private HasKindSelectControl hasKindSelectorControl;
    private FunctionDefinition.Kind kind;
    @Captor
    private ArgumentCaptor<FunctionDefinition.Kind[]> kindsArgumentCaptor;
    private KindPopoverImpl popover;

    @Before
    public void setup() {
        this.popover = new KindPopoverImpl(this.view, this.translationService);
        this.kind = FunctionDefinition.Kind.JAVA;
    }

    @Test
    public void testInitialization() {
        ((KindPopoverView)Mockito.verify((Object)this.view)).setFunctionKinds((FunctionDefinition.Kind[])this.kindsArgumentCaptor.capture());
        Object[] values = (FunctionDefinition.Kind[])this.kindsArgumentCaptor.getValue();
        Assertions.assertThat((Object[])values).hasSize(3);
        Assertions.assertThat((Object[])values).contains((Object[])new FunctionDefinition.Kind[]{FunctionDefinition.Kind.FEEL, FunctionDefinition.Kind.JAVA, FunctionDefinition.Kind.PMML});
    }

    @Test
    public void testShowWhenBound() {
        this.popover.bind((Object)this.hasKindSelectorControl, 0, 0);
        this.popover.show();
        ((KindPopoverView)Mockito.verify((Object)this.view)).show(Optional.ofNullable(this.popover.getPopoverTitle()));
    }

    @Test
    public void testShowWhenNotBound() {
        this.popover.show();
        ((KindPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show((Optional)Matchers.any(Optional.class));
    }

    @Test
    public void testHideWhenBound() {
        this.popover.bind((Object)this.hasKindSelectorControl, 0, 0);
        this.popover.hide();
        ((KindPopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testHideWhenNotBound() {
        this.popover.hide();
        ((KindPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testOnFunctionKindSelectedWhenBound() {
        this.popover.bind((Object)this.hasKindSelectorControl, 0, 0);
        this.popover.onFunctionKindSelected(this.kind);
        ((HasKindSelectControl)Mockito.verify((Object)this.hasKindSelectorControl)).setFunctionKind((FunctionDefinition.Kind)Matchers.eq((Object)FunctionDefinition.Kind.JAVA));
        ((KindPopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testOnExpressionEditorDefinitionSelectedWhenNotBound() {
        this.popover.onFunctionKindSelected(this.kind);
        ((HasKindSelectControl)Mockito.verify((Object)this.hasKindSelectorControl, (VerificationMode)Mockito.never())).setFunctionKind((FunctionDefinition.Kind)Matchers.any(FunctionDefinition.Kind.class));
        ((KindPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }
}

